/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.SimplePacketComs;

import edu.wpi.SimplePacketComs.PacketType;
import edu.wpi.SimplePacketComs.bytepacket.BytePacketType;
import edu.wpi.SimplePacketComs.floatpacket.FloatPacketType;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class AbstractSimpleComsDevice {
    HashMap<Integer, ArrayList<Runnable>> events = new HashMap();
    boolean connected = false;
    ArrayList<PacketType> processQueue = new ArrayList();
    ArrayList<PacketType> pollingQueue = new ArrayList();
    private boolean virtual = false;

    public void addPollingPacket(PacketType packet) {
        for (PacketType q : this.pollingQueue) {
            if (q.idOfCommand != packet.idOfCommand) continue;
            throw new RuntimeException("Only one packet of a given ID is allowed to poll. Add an event to recive data");
        }
        this.pollingQueue.add(packet);
    }

    public void pushPacket(PacketType packet) {
        packet.done = false;
        packet.started = false;
        this.processQueue.add(packet);
        while (!packet.done) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void removeEvent(Integer id, Runnable event) {
        if (this.events.get(id) == null) {
            this.events.put(id, new ArrayList());
        }
        this.events.get(id).remove(event);
    }

    public void addEvent(Integer id, Runnable event) {
        if (this.events.get(id) == null) {
            this.events.put(id, new ArrayList());
        }
        this.events.get(id).add(event);
    }

    public ArrayList<Integer> getIDs() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (PacketType pt : this.pollingQueue) {
            ids.add(pt.idOfCommand);
        }
        return ids;
    }

    public void writeFloats(int id, double[] values) {
        for (PacketType pt : this.pollingQueue) {
            if (!FloatPacketType.class.isInstance(pt) || pt.idOfCommand != id) continue;
            for (int i = 0; i < pt.downstream.length; ++i) {
                pt.downstream[i] = Float.valueOf((float)values[i]);
            }
            return;
        }
    }

    public void writeBytes(int id, byte[] values) {
        for (PacketType pt : this.pollingQueue) {
            if (!BytePacketType.class.isInstance(pt) || pt.idOfCommand != id) continue;
            for (int i = 0; i < pt.downstream.length; ++i) {
                pt.downstream[i] = values[i];
            }
            return;
        }
    }

    public void readFloats(int id, double[] values) {
        for (PacketType pt : this.pollingQueue) {
            if (!FloatPacketType.class.isInstance(pt) || pt.idOfCommand != id) continue;
            for (int i = 0; i < pt.upstream.length; ++i) {
                values[i] = (Double)pt.upstream[i];
            }
            return;
        }
    }

    public void readBytes(int id, byte[] values) {
        for (PacketType pt : this.pollingQueue) {
            if (!BytePacketType.class.isInstance(pt) || pt.idOfCommand != id) continue;
            for (int i = 0; i < pt.upstream.length; ++i) {
                values[i] = (Byte)pt.upstream[i];
            }
            return;
        }
    }

    private void process(PacketType packet) {
        packet.started = true;
        try {
            block16: {
                if (!this.isVirtual()) {
                    long start = System.currentTimeMillis();
                    try {
                        byte[] message = packet.command(packet.idOfCommand, packet.downstream);
                        int val = this.write(message, message.length, 1);
                        if (val > 0) {
                            int read = this.read(message, 1000);
                            if (read >= packet.upstream.length) {
                                int ID = PacketType.getId(message);
                                if (ID == packet.idOfCommand) {
                                    Number[] up = packet.parse(message);
                                    for (int i = 0; i < packet.upstream.length; ++i) {
                                        packet.upstream[i] = up[i];
                                    }
                                    break block16;
                                }
                                System.out.print("\r\nCross Talk " + ID + " expected " + packet.idOfCommand + " ");
                                for (int i = 0; i < 8; ++i) {
                                    System.out.print(message[i] + " ");
                                }
                                System.out.println(" ");
                                return;
                            }
                            System.out.println("Read failed");
                            return;
                        }
                        return;
                    }
                    catch (Throwable t) {
                        t.printStackTrace(System.out);
                        this.disconnect();
                    }
                } else {
                    for (int j = 0; j < packet.downstream.length && j < packet.upstream.length; ++j) {
                        packet.upstream[j] = packet.downstream[j];
                    }
                }
            }
            if (this.events.get(packet.idOfCommand) != null) {
                for (Runnable e : this.events.get(packet.idOfCommand)) {
                    if (e == null) continue;
                    try {
                        e.run();
                    }
                    catch (Throwable t) {
                        t.printStackTrace(System.out);
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
        }
        packet.done = true;
    }

    public boolean connect() {
        if (this.connectDeviceImp()) {
            this.setVirtual(false);
        } else {
            this.setVirtual(true);
        }
        this.connected = true;
        new Thread(){

            @Override
            public void run() {
                while (AbstractSimpleComsDevice.this.connected) {
                    try {
                        for (PacketType pollingPacket : AbstractSimpleComsDevice.this.pollingQueue) {
                            AbstractSimpleComsDevice.this.process(pollingPacket);
                        }
                        while (AbstractSimpleComsDevice.this.processQueue.size() > 0) {
                            try {
                                PacketType temPack = AbstractSimpleComsDevice.this.processQueue.get(0);
                                if (temPack == null) continue;
                                AbstractSimpleComsDevice.this.process(temPack);
                                AbstractSimpleComsDevice.this.processQueue.remove(0);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                        AbstractSimpleComsDevice.this.connected = false;
                    }
                }
                AbstractSimpleComsDevice.this.disconnect();
            }
        }.start();
        return true;
    }

    public void disconnect() {
        this.connected = false;
        this.disconnectDeviceImp();
    }

    private boolean isVirtual() {
        return this.virtual;
    }

    public void setVirtual(boolean virtual) {
        this.virtual = virtual;
    }

    public abstract int read(byte[] var1, int var2);

    public abstract int write(byte[] var1, int var2, int var3);

    public abstract boolean disconnectDeviceImp();

    public abstract boolean connectDeviceImp();
}

