/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.SimplePacketComs.phy;

import edu.wpi.SimplePacketComs.AbstractSimpleComsDevice;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.HashSet;

public class UDPSimplePacketComs
extends AbstractSimpleComsDevice {
    private InetAddress address;
    private static InetAddress broadcast;
    private static final HashSet<InetAddress> addrs;
    private DatagramSocket udpSock;
    private byte[] receiveData = new byte[64];
    private static final int port = 1865;
    private DatagramPacket receivePacket = new DatagramPacket(this.receiveData, this.receiveData.length);

    public UDPSimplePacketComs(InetAddress address) throws Exception {
        this.address = address;
    }

    public static HashSet<InetAddress> getAllAddresses() throws Exception {
        broadcast = InetAddress.getByAddress(new byte[]{-1, -1, -1, -1});
        addrs.clear();
        UDPSimplePacketComs pinger = new UDPSimplePacketComs(broadcast);
        pinger.connect();
        byte[] data = new byte[64];
        pinger.write(data, data.length, 1000);
        for (int i = 0; i < 100; ++i) {
            pinger.read(data, 2);
            Thread.sleep(2L);
        }
        pinger.disconnect();
        return addrs;
    }

    @Override
    public int read(byte[] message, int howLongToWaitBeforeTimeout) {
        try {
            this.udpSock.setSoTimeout(howLongToWaitBeforeTimeout);
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        try {
            this.udpSock.receive(this.receivePacket);
        }
        catch (SocketTimeoutException ste) {
            return 0;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        addrs.add(this.receivePacket.getAddress());
        int len = this.receivePacket.getLength();
        byte[] data = this.receivePacket.getData();
        for (int i = 0; i < len; ++i) {
            message[i] = data[i];
        }
        return len;
    }

    @Override
    public int write(byte[] message, int length, int howLongToWaitBeforeTimeout) {
        DatagramPacket sendPacket = new DatagramPacket(message, length, this.address, 1865);
        try {
            this.udpSock.send(sendPacket);
            return length;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public boolean disconnectDeviceImp() {
        this.udpSock.disconnect();
        return true;
    }

    @Override
    public boolean connectDeviceImp() {
        try {
            this.udpSock = new DatagramSocket();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return true;
    }

    static {
        addrs = new HashSet();
    }
}

