/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.SimplePacketComs.bytepacket;

import edu.wpi.SimplePacketComs.PacketType;

public class BytePacketType
extends PacketType {
    private final byte[] message;
    private final Number[] returnValues;

    public BytePacketType(int id, int size) {
        super(id);
        packetSize = size;
        this.message = new byte[packetSize];
        this.numberOfBytesPerValue = 1;
        this.numValues = packetSize / this.numberOfBytesPerValue - 4 / this.numberOfBytesPerValue;
        this.returnValues = new Number[this.numValues];
        this.downstream = new Byte[this.numValues];
        this.upstream = new Byte[this.numValues];
        for (int i = 0; i < this.numValues; ++i) {
            this.downstream[i] = (byte)0;
            this.upstream[i] = (byte)0;
        }
    }

    @Override
    public Number[] parse(byte[] bytes) {
        for (int i = 0; i < this.numValues; ++i) {
            int baseIndex = this.numberOfBytesPerValue * i + 4;
            this.returnValues[i] = bytes[baseIndex];
        }
        return this.returnValues;
    }

    @Override
    public byte[] command(int idOfCommand, Number[] values) {
        BytePacketType.writeId(idOfCommand, this.message);
        for (int i = 0; i < this.numValues && i < values.length; ++i) {
            int baseIndex = this.numberOfBytesPerValue * i + 4;
            this.message[baseIndex] = values[i].byteValue();
        }
        return this.message;
    }
}

