/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.SimplePacketComs.phy;

import edu.wpi.SimplePacketComs.AbstractSimpleComsDevice;
import org.hid4java.HidDevice;
import org.hid4java.HidManager;
import org.hid4java.HidServices;

public class HIDSimplePacketComs
extends AbstractSimpleComsDevice {
    private int vid = 0;
    private int pid = 0;
    private HidServices hidServices = null;
    private HidDevice hidDevice = null;

    public HIDSimplePacketComs(int vidIn, int pidIn) {
        this.vid = vidIn;
        this.pid = pidIn;
    }

    @Override
    public int read(byte[] message, int howLongToWaitBeforeTimeout) {
        return this.hidDevice.read(message, howLongToWaitBeforeTimeout);
    }

    @Override
    public int write(byte[] message, int length, int howLongToWaitBeforeTimeout) {
        return this.hidDevice.write(message, length, (byte)0);
    }

    @Override
    public boolean disconnectDeviceImp() {
        if (this.hidDevice != null) {
            this.hidDevice.close();
        }
        if (this.hidServices != null) {
            this.hidServices.shutdown();
        }
        System.out.println("HID device clean shutdown");
        return false;
    }

    @Override
    public boolean connectDeviceImp() {
        if (this.hidServices == null) {
            this.hidServices = HidManager.getHidServices();
        }
        this.hidDevice = null;
        for (HidDevice h : this.hidServices.getAttachedHidDevices()) {
            if (!h.isVidPidSerial(this.vid, this.pid, null)) continue;
            if (this.hidDevice == null) {
                this.hidDevice = h;
                this.hidDevice.open();
                System.out.println("Found! " + this.hidDevice);
                return true;
            }
            System.out.println("Already opened! this matches too.. " + h);
        }
        return false;
    }
}

