/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.SimplePacketComs.device.hephaestus;

import edu.wpi.SimplePacketComs.FloatPacketType;
import edu.wpi.SimplePacketComs.PacketType;
import edu.wpi.SimplePacketComs.phy.HIDSimplePacketComs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class HephaestusArm
extends HIDSimplePacketComs {
    PacketType pollingPacket = new FloatPacketType(37, 64);
    PacketType pidPacket = new FloatPacketType(65, 64);
    PacketType PDVelPacket = new FloatPacketType(48, 64);
    PacketType SetVelocity = new FloatPacketType(42, 64);

    public HephaestusArm(int vidIn, int pidIn) {
        super(vidIn, pidIn);
        this.pidPacket.oneShotMode();
        this.pidPacket.sendOk();
        this.PDVelPacket.oneShotMode();
        this.PDVelPacket.sendOk();
        this.SetVelocity.oneShotMode();
        this.SetVelocity.sendOk();
        for (PacketType pt : Arrays.asList(this.pollingPacket, this.pidPacket, this.PDVelPacket, this.SetVelocity)) {
            this.addPollingPacket(pt);
        }
    }

    public void addPollingPacketEvent(Runnable event) {
        this.addEvent(this.pollingPacket.idOfCommand, event);
    }

    public void setValuesevent(int index, float position, float velocity, float force) {
        this.pollingPacket.downstream[index * 3 + 0] = Float.valueOf(position);
        this.pollingPacket.downstream[index * 3 + 1] = Float.valueOf(velocity);
        this.pollingPacket.downstream[index * 3 + 2] = Float.valueOf(force);
    }

    public void setPIDGains(int index, float kp, float ki, float kd) {
        this.pidPacket.downstream[index * 3 + 0] = Float.valueOf(kp);
        this.pidPacket.downstream[index * 3 + 1] = Float.valueOf(ki);
        this.pidPacket.downstream[index * 3 + 2] = Float.valueOf(kd);
    }

    public void pushPIDGains() {
        this.pidPacket.oneShotMode();
    }

    public void setPDVelGains(int index, float kp, float kd) {
        this.PDVelPacket.downstream[index * 2 + 0] = Float.valueOf(kp);
        this.PDVelPacket.downstream[index * 2 + 1] = Float.valueOf(kd);
    }

    public void pushPDVelGains() {
        this.PDVelPacket.oneShotMode();
    }

    public void setVelocity(int index, float TPS) {
        this.SetVelocity.downstream[index] = Float.valueOf(TPS);
    }

    public void pushVelocity() {
        this.SetVelocity.oneShotMode();
    }

    public List<Double> getValues(int index) {
        ArrayList<Double> back = new ArrayList<Double>();
        back.add(this.pollingPacket.upstream[index * 3 + 0].doubleValue());
        back.add(this.pollingPacket.upstream[index * 3 + 1].doubleValue());
        back.add(this.pollingPacket.upstream[index * 3 + 2].doubleValue());
        return back;
    }

    public double getPosition(int index) {
        return this.pollingPacket.upstream[index * 3 + 0].doubleValue();
    }

    public Number[] getRawValues() {
        return this.pollingPacket.upstream;
    }

    public void setRawValues(Number[] set) {
        for (int i = 0; i < set.length && i < this.pollingPacket.downstream.length; ++i) {
            this.pollingPacket.downstream[i] = set[i];
        }
    }
}

