/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.SimplePacketComs;

import edu.wpi.SimplePacketComs.BytePacketType;
import edu.wpi.SimplePacketComs.FloatPacketType;
import edu.wpi.SimplePacketComs.PacketType;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class AbstractSimpleComsDevice {
    HashMap<Integer, ArrayList<Runnable>> events = new HashMap();
    boolean connected = false;
    ArrayList<PacketType> pollingQueue = new ArrayList();
    private boolean virtual = false;
    private String name = "SimpleComsDevice";
    private int readTimeout = 100;
    private boolean isTimedOut = false;

    public abstract int read(byte[] var1, int var2);

    public abstract int write(byte[] var1, int var2, int var3);

    public abstract boolean disconnectDeviceImp();

    public abstract boolean connectDeviceImp();

    public void addPollingPacket(PacketType packet) {
        if (this.getPacket(packet.idOfCommand) != null) {
            throw new RuntimeException("Only one packet of a given ID is allowed to poll. Add an event to recive data");
        }
        this.pollingQueue.add(packet);
    }

    private PacketType getPacket(int ID) {
        for (PacketType q : this.pollingQueue) {
            if (q.idOfCommand != ID) continue;
            return q;
        }
        return null;
    }

    public void removeEvent(Integer id, Runnable event) {
        if (this.events.get(id) == null) {
            this.events.put(id, new ArrayList());
        }
        this.events.get(id).remove(event);
    }

    public void addEvent(Integer id, Runnable event) {
        if (this.events.get(id) == null) {
            this.events.put(id, new ArrayList());
        }
        this.events.get(id).add(event);
    }

    public ArrayList<Integer> getIDs() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (PacketType pt : this.pollingQueue) {
            ids.add(pt.idOfCommand);
        }
        return ids;
    }

    public void writeFloats(int id, double[] values) {
        for (PacketType pt : this.pollingQueue) {
            if (!FloatPacketType.class.isInstance(pt) || pt.idOfCommand != id) continue;
            for (int i = 0; i < pt.downstream.length && i < values.length; ++i) {
                pt.downstream[i] = Float.valueOf((float)values[i]);
            }
            return;
        }
    }

    public void writeBytes(int id, byte[] values) {
        for (PacketType pt : this.pollingQueue) {
            if (!BytePacketType.class.isInstance(pt) || pt.idOfCommand != id) continue;
            for (int i = 0; i < pt.downstream.length && i < values.length; ++i) {
                pt.downstream[i] = values[i];
            }
            return;
        }
    }

    public void readFloats(int id, double[] values) {
        for (PacketType pt : this.pollingQueue) {
            if (!FloatPacketType.class.isInstance(pt) || pt.idOfCommand != id) continue;
            for (int i = 0; i < pt.upstream.length && i < values.length; ++i) {
                float d = ((Float)pt.upstream[i]).floatValue();
                values[i] = d;
            }
            return;
        }
    }

    public void readBytes(int id, byte[] values) {
        for (PacketType pt : this.pollingQueue) {
            if (!BytePacketType.class.isInstance(pt) || pt.idOfCommand != id) continue;
            for (int i = 0; i < pt.upstream.length && i < values.length; ++i) {
                values[i] = (Byte)pt.upstream[i];
            }
            return;
        }
    }

    private void process(PacketType packet) {
        packet.started = true;
        try {
            block16: {
                if (!this.isVirtual()) {
                    try {
                        byte[] message = packet.command(packet.idOfCommand, packet.downstream);
                        int val = this.write(message, message.length, 1);
                        if (val > 0) {
                            int read = this.read(message, this.getReadTimeout());
                            if (read >= packet.upstream.length) {
                                this.isTimedOut = false;
                                int ID = PacketType.getId(message);
                                if (ID == packet.idOfCommand) {
                                    Number[] up = packet.parse(message);
                                    for (int i = 0; i < packet.upstream.length; ++i) {
                                        packet.upstream[i] = up[i];
                                    }
                                    break block16;
                                }
                                System.out.print("\r\nCross Talk " + ID + " expected " + packet.idOfCommand + " ");
                                for (int i = 0; i < 8; ++i) {
                                    System.out.print(message[i] + " ");
                                }
                                System.out.println(" ");
                                return;
                            }
                            this.isTimedOut = true;
                            return;
                        }
                        return;
                    }
                    catch (Throwable t) {
                        t.printStackTrace(System.out);
                        this.disconnect();
                    }
                } else {
                    for (int j = 0; j < packet.downstream.length && j < packet.upstream.length; ++j) {
                        packet.upstream[j] = packet.downstream[j];
                    }
                }
            }
            if (this.events.get(packet.idOfCommand) != null) {
                for (Runnable e : this.events.get(packet.idOfCommand)) {
                    if (e == null) continue;
                    try {
                        e.run();
                    }
                    catch (Throwable t) {
                        t.printStackTrace(System.out);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        packet.done = true;
    }

    private int getReadTimeout() {
        return this.readTimeout;
    }

    public boolean connect() {
        if (this.connectDeviceImp()) {
            this.setVirtual(false);
        } else {
            this.setVirtual(true);
        }
        this.connected = true;
        new Thread(){

            @Override
            public void run() {
                while (AbstractSimpleComsDevice.this.connected) {
                    try {
                        for (PacketType pollingPacket : AbstractSimpleComsDevice.this.pollingQueue) {
                            if (!pollingPacket.sendOk()) continue;
                            AbstractSimpleComsDevice.this.process(pollingPacket);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                        AbstractSimpleComsDevice.this.connected = false;
                    }
                }
                AbstractSimpleComsDevice.this.disconnectDeviceImp();
                System.out.println("SimplePacketComs disconnect");
            }
        }.start();
        return true;
    }

    public void disconnect() {
        this.connected = false;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public void setVirtual(boolean virtual) {
        this.virtual = virtual;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isTimedOut() {
        return this.isTimedOut;
    }

    public void setTimedOut(boolean isTimedOut) {
        this.isTimedOut = isTimedOut;
    }
}

