/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.SimplePacketComs.server;

import edu.wpi.SimplePacketComs.IPhysicalLayer;
import edu.wpi.SimplePacketComs.PacketType;
import edu.wpi.SimplePacketComs.device.Device;
import edu.wpi.SimplePacketComs.server.IOnPacketEvent;
import edu.wpi.SimplePacketComs.server.IServerImplementation;
import java.util.HashMap;

public abstract class AbstractSimpleComsServer
implements Device,
IPhysicalLayer {
    private HashMap<Integer, IOnPacketEvent> servers = new HashMap();
    private HashMap<IOnPacketEvent, PacketType> packets = new HashMap();
    boolean connected = false;
    private byte[] data = null;

    public void addServer(PacketType packet, IOnPacketEvent iOnBytePacketEvent) {
        this.servers.put(packet.idOfCommand, iOnBytePacketEvent);
        this.packets.put(iOnBytePacketEvent, packet);
    }

    public void addServer(IServerImplementation imp) {
        PacketType packet = imp.getPacket();
        IServerImplementation iOnBytePacketEvent = imp;
        this.addServer(packet, iOnBytePacketEvent);
    }

    @Override
    public boolean connect() {
        this.connected = this.connectDeviceImp();
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (AbstractSimpleComsServer.this.connected) {
                    try {
                        Number[] dataValues;
                        PacketType packet;
                        int readAmount = AbstractSimpleComsServer.this.read(AbstractSimpleComsServer.this.getData(), 2);
                        if (readAmount <= 0) continue;
                        int ID = PacketType.getId(AbstractSimpleComsServer.this.getData());
                        IOnPacketEvent event = (IOnPacketEvent)AbstractSimpleComsServer.this.servers.get(ID);
                        if (event == null || (packet = (PacketType)AbstractSimpleComsServer.this.packets.get(event)) == null || !event.event(dataValues = packet.parse(AbstractSimpleComsServer.this.getData()))) continue;
                        byte[] backData = packet.command(ID, dataValues);
                        AbstractSimpleComsServer.this.write(backData, AbstractSimpleComsServer.this.getPacketSize(), 2);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                AbstractSimpleComsServer.this.disconnectDeviceImp();
                System.out.println("Disconnect AbstractSimpleComsServer");
            }
        }).start();
        return this.connected;
    }

    @Override
    public void disconnect() {
        this.connected = false;
    }

    private byte[] getData() {
        if (this.data == null) {
            this.data = new byte[this.getPacketSize()];
        }
        return this.data;
    }

    @Override
    public abstract int read(byte[] var1, int var2);

    @Override
    public abstract int write(byte[] var1, int var2, int var3);

    public abstract int getPacketSize();
}

