/*
 * Decompiled with CFR 0.152.
 */
package com.neverbounce.api.internal;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonParser;
import com.google.api.client.util.Data;
import com.google.api.client.util.ObjectParser;
import com.neverbounce.api.Version;
import com.neverbounce.api.client.exception.NeverbounceApiException;
import com.neverbounce.api.client.exception.NeverbounceIoException;
import com.neverbounce.api.internal.HttpClient;
import com.neverbounce.api.model.Request;
import com.neverbounce.api.model.Response;
import com.neverbounce.api.model.Status;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientImpl
implements HttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientImpl.class);
    private static final HttpTransport HTTP_TRANSPORT = new NetHttpTransport();
    private static final Integer SOCKET_READ_TIMEOUT = 40000;
    private final String apiKey;
    private final HttpRequestFactory requestFactory;
    private final String apiVersion;

    public HttpClientImpl(String apiKey) {
        this(apiKey, HTTP_TRANSPORT, "v4");
    }

    public HttpClientImpl(String apiKey, String apiVersion) {
        this(apiKey, HTTP_TRANSPORT, apiVersion);
    }

    HttpClientImpl(String apiKey, HttpTransport httpTransport) {
        this(apiKey, httpTransport, "v4");
    }

    HttpClientImpl(String apiKey, HttpTransport httpTransport, String apiVersion) {
        this.apiVersion = apiVersion;
        this.apiKey = apiKey;
        HttpRequestInitializer httpRequestInitializer = new HttpRequestInitializer(){

            public void initialize(HttpRequest httpRequest) throws IOException {
                httpRequest.setParser((ObjectParser)HttpClient.JSON_FACTORY.createJsonObjectParser());
            }
        };
        this.requestFactory = httpTransport.createRequestFactory(httpRequestInitializer);
        String version = Version.INSTANCE.getVersion();
        LOGGER.info("Initialized Neverbounce API HTTP client; version: {}.", (Object)version);
    }

    @Override
    public <R extends Response> R getForObject(String path, Class<R> responseClass) {
        return this.getForObject(path, null, responseClass);
    }

    @Override
    public <R extends Response> R getForObject(String path, Request<R> request, Class<R> responseClass) {
        GenericUrl url = new GenericUrl("https://api.neverbounce.com/" + this.apiVersion + "/" + path);
        if (request != null) {
            Map requestData = Data.mapOf(request);
            url.putAll(requestData);
        }
        try {
            HttpRequest httpRequest = this.requestFactory.buildGetRequest(url);
            return this.execute(httpRequest, responseClass);
        }
        catch (IOException ioe) {
            throw new NeverbounceIoException(ioe);
        }
    }

    @Override
    public <R extends Response> R postForObject(String path, Request<R> request, Class<R> responseClass) {
        GenericUrl url = new GenericUrl("https://api.neverbounce.com/" + this.apiVersion + "/" + path);
        try {
            HttpRequest httpRequest = this.requestFactory.buildPostRequest(url, (HttpContent)new JsonHttpContent(JSON_FACTORY, request));
            return this.execute(httpRequest, responseClass);
        }
        catch (IOException ioe) {
            throw new NeverbounceIoException(ioe);
        }
    }

    private <R extends Response> R execute(HttpRequest httpRequest, Class<R> responseClass) {
        try {
            this.prepareRequest(httpRequest);
            Response response = (Response)httpRequest.execute().parseAs(responseClass);
            Status status = response.getStatus();
            LOGGER.debug("Executed {} HTTP request, response status is {}.", (Object)httpRequest.getRequestMethod(), (Object)status.name());
            if (!Status.SUCCESS.equals((Object)status)) {
                throw new NeverbounceApiException(response);
            }
            return (R)response;
        }
        catch (HttpResponseException hre) {
            throw this.translateHttpResponseException(hre);
        }
        catch (IOException ioe) {
            throw new NeverbounceIoException(ioe);
        }
    }

    private void prepareRequest(HttpRequest httpRequest) {
        HttpHeaders headers = httpRequest.getHeaders();
        String version = Version.INSTANCE.getVersion();
        headers.setUserAgent("NeverBounceApi-Java/" + version);
        httpRequest.setSuppressUserAgentSuffix(true);
        httpRequest.setReadTimeout(SOCKET_READ_TIMEOUT.intValue());
        String requestMethod = httpRequest.getRequestMethod();
        if ("GET".equals(requestMethod)) {
            GenericUrl url = httpRequest.getUrl();
            url.set("key", (Object)this.apiKey);
            LOGGER.debug("Prepared {} request, for url {}.", (Object)"GET", (Object)url.toString());
            return;
        }
        if ("POST".equals(requestMethod)) {
            JsonHttpContent jsonHttpContent = (JsonHttpContent)httpRequest.getContent();
            HashMap<String, String> requestData = new HashMap<String, String>(Data.mapOf((Object)jsonHttpContent.getData()));
            requestData.put("key", this.apiKey);
            httpRequest.setContent((HttpContent)new JsonHttpContent(JSON_FACTORY, requestData));
            LOGGER.debug("Prepared {} request, for url {} with data {}.", new Object[]{"POST", httpRequest.getUrl().toString(), requestData});
            return;
        }
        throw new UnsupportedOperationException("Cannot authenticate request for unimplemented HTTP method " + requestMethod);
    }

    private RuntimeException translateHttpResponseException(HttpResponseException hre) {
        NeverbounceApiException neverbounceApiException;
        try {
            JsonParser jsonParser = JSON_FACTORY.createJsonParser(hre.getContent());
            neverbounceApiException = (NeverbounceApiException)jsonParser.parse(NeverbounceApiException.class);
        }
        catch (IOException ioe) {
            return new NeverbounceIoException(ioe);
        }
        return neverbounceApiException;
    }
}

