/*
 * Decompiled with CFR 0.152.
 */
package com.neverbounce.api.model;

import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.neverbounce.api.internal.HttpClient;
import com.neverbounce.api.model.AbstractRequest;
import com.neverbounce.api.model.AbstractRequestBuilder;
import com.neverbounce.api.model.InputLocation;
import com.neverbounce.api.model.JobsCreateResponse;

public abstract class JobsCreateRequest<T>
extends AbstractRequest<JobsCreateResponse> {
    public static final String PATH = "jobs/create";
    @Key(value="input_location")
    private final InputLocation inputLocation;
    @Key
    private final T input;
    @Key(value="auto_parse")
    private final int autoParse;
    @Key(value="auto_start")
    private final int autoStart;
    @Key(value="run_sample")
    private final Integer runSample;
    @Key
    private final String filename;
    @Key(value="request_meta_data[leverage_historical_data]")
    private final Integer historicalData;

    JobsCreateRequest(HttpClient httpClient, InputLocation inputLocation, T input, int autoParse, int autoStart, Integer runSample, String filename, Integer historicalData) {
        super(httpClient);
        this.inputLocation = inputLocation;
        this.input = input;
        this.autoParse = autoParse;
        this.autoStart = autoStart;
        this.runSample = runSample;
        this.filename = filename;
        this.historicalData = historicalData;
    }

    @Override
    public JobsCreateResponse execute() {
        return this.getHttpClient().postForObject(PATH, this, JobsCreateResponse.class);
    }

    public static abstract class Builder<T, R extends JobsCreateRequest<T>>
    extends AbstractRequestBuilder<R> {
        protected final InputLocation inputLocation;
        protected T input;
        protected Boolean autoParse;
        protected Boolean autoStart;
        protected Boolean runSample;
        protected String filename;
        protected Integer historicalData;

        public Builder(HttpClient httpClient, InputLocation inputLocation) {
            super(httpClient);
            this.inputLocation = inputLocation;
        }

        public Builder<T, R> withAutoParse(boolean autoParse) {
            this.autoParse = autoParse;
            return this;
        }

        public Builder<T, R> withAutoStart(boolean autoStart) {
            this.autoStart = autoStart;
            return this;
        }

        public Builder<T, R> withRunSample(Boolean runSample) {
            this.runSample = runSample;
            return this;
        }

        public Builder<T, R> withFilename(String filename) {
            this.filename = filename;
            return this;
        }

        public Builder<T, R> withHistoricalData(boolean historicalData) {
            this.historicalData = historicalData ? 1 : 0;
            return this;
        }

        @Override
        protected void validate() {
            Preconditions.checkState((this.input != null ? 1 : 0) != 0, (Object)"input must not be null");
            Preconditions.checkState((this.autoParse != null ? 1 : 0) != 0, (Object)"auto_parse must not be null");
            Preconditions.checkState((this.autoStart != null ? 1 : 0) != 0, (Object)"auto_start must not be null");
        }
    }
}

