/*
 * Decompiled with CFR 0.152.
 */
package com.neverbounce.api.model;

import com.google.api.client.util.Preconditions;
import com.neverbounce.api.internal.HttpClient;
import com.neverbounce.api.internal.IntegerUtils;
import com.neverbounce.api.model.EmailData;
import com.neverbounce.api.model.InputLocation;
import com.neverbounce.api.model.JobsCreateRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JobsCreateWithSuppliedJsonRequest
extends JobsCreateRequest<List<EmailData>> {
    public JobsCreateWithSuppliedJsonRequest(HttpClient httpClient, InputLocation inputLocation, List<EmailData> input, int autoParse, int autoStart, Integer runSample, String filename, Integer historicalData) {
        super(httpClient, inputLocation, input, autoParse, autoStart, runSample, filename, historicalData);
    }

    public static class Builder
    extends JobsCreateRequest.Builder<List<EmailData>, JobsCreateWithSuppliedJsonRequest> {
        public Builder(HttpClient httpClient) {
            super(httpClient, InputLocation.SUPPLIED);
            this.input = new ArrayList();
        }

        public Builder addInput(Map<String, Object> data) {
            ((List)this.input).add(new EmailData(data));
            return this;
        }

        public Builder addInput(String email) {
            return this.addInput(null, email, null);
        }

        public Builder addInput(String email, String name) {
            return this.addInput(null, email, name);
        }

        public Builder addInput(String id, String email, String name) {
            ((List)this.input).add(new EmailData(id, email, name));
            return this;
        }

        @Override
        public JobsCreateWithSuppliedJsonRequest build() {
            return (JobsCreateWithSuppliedJsonRequest)super.build();
        }

        @Override
        protected JobsCreateWithSuppliedJsonRequest doBuild() {
            return new JobsCreateWithSuppliedJsonRequest(this.httpClient, this.inputLocation, (List)this.input, (int)IntegerUtils.toInteger(this.autoParse), (int)IntegerUtils.toInteger(this.autoStart), IntegerUtils.toInteger(this.runSample), this.filename, this.historicalData);
        }

        @Override
        protected void validate() {
            super.validate();
            for (int index = 0; index < ((List)this.input).size(); ++index) {
                EmailData data = (EmailData)((Object)((List)this.input).get(index));
                Preconditions.checkState((data.get("email") != null ? 1 : 0) != 0, (Object)("Field email in input #" + index + " is null."));
            }
        }
    }
}

