/*
 * Decompiled with CFR 0.152.
 */
package com.neverbounce.api.model;

import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.neverbounce.api.internal.HttpClient;
import com.neverbounce.api.internal.IntegerUtils;
import com.neverbounce.api.model.AbstractJobsRequest;
import com.neverbounce.api.model.JobsParseResponse;

public class JobsParseRequest
extends AbstractJobsRequest<JobsParseResponse> {
    public static final String PATH = "jobs/parse";
    @Key(value="auto_start")
    private final Integer autoStart;

    JobsParseRequest(HttpClient httpClient, long jobId, Integer autoStart) {
        super(httpClient, jobId);
        this.autoStart = autoStart;
    }

    @Override
    public JobsParseResponse execute() {
        return this.getHttpClient().postForObject(PATH, this, JobsParseResponse.class);
    }

    public static class Builder
    extends AbstractJobsRequest.Builder<JobsParseRequest, Builder> {
        private Boolean autoStart;

        public Builder(HttpClient httpClient) {
            super(httpClient);
        }

        public Builder withAutoStart(Boolean autoStart) {
            this.autoStart = autoStart;
            return this;
        }

        @Override
        protected JobsParseRequest doBuild() {
            return new JobsParseRequest(this.httpClient, this.jobId, IntegerUtils.toInteger(this.autoStart));
        }

        @Override
        protected void validate() {
            super.validate();
            Preconditions.checkState((this.autoStart != null ? 1 : 0) != 0, (Object)"auto_start must not be null");
        }
    }
}

