/*
 * Decompiled with CFR 0.152.
 */
package com.neverbounce.api.model;

import com.google.api.client.util.Key;
import com.neverbounce.api.internal.HttpClient;
import com.neverbounce.api.internal.IntegerUtils;
import com.neverbounce.api.model.AbstractJobsRequest;
import com.neverbounce.api.model.JobsStartResponse;

public class JobsStartRequest
extends AbstractJobsRequest<JobsStartResponse> {
    public static final String PATH = "jobs/start";
    @Key(value="run_sample")
    private final Integer runSample;

    JobsStartRequest(HttpClient httpClient, long jobId, Integer runSample) {
        super(httpClient, jobId);
        this.runSample = runSample;
    }

    @Override
    public JobsStartResponse execute() {
        return this.getHttpClient().postForObject(PATH, this, JobsStartResponse.class);
    }

    public static class Builder
    extends AbstractJobsRequest.Builder<JobsStartRequest, Builder> {
        private Boolean runSample;

        public Builder(HttpClient httpClient) {
            super(httpClient);
        }

        public Builder withRunSample(Boolean runSample) {
            this.runSample = runSample;
            return this;
        }

        @Override
        protected JobsStartRequest doBuild() {
            return new JobsStartRequest(this.httpClient, this.jobId, IntegerUtils.toInteger(this.runSample));
        }
    }
}

