/*
 * Decompiled with CFR 0.152.
 */
package com.neverbounce.api.model;

import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.neverbounce.api.internal.HttpClient;
import com.neverbounce.api.model.AbstractRequest;
import com.neverbounce.api.model.AbstractRequestBuilder;
import com.neverbounce.api.model.PoeConfirmResponse;

public class PoeConfirmRequest
extends AbstractRequest<PoeConfirmResponse> {
    public static final String PATH = "poe/confirm";
    @Key
    private final String email;
    @Key
    private final String result;
    @Key(value="transaction_id")
    private final String transactionId;
    @Key(value="confirmation_token")
    private final String confirmationToken;

    public PoeConfirmRequest(HttpClient httpClient, String email, String result, String transactionId, String confirmationToken) {
        super(httpClient);
        this.email = email;
        this.result = result;
        this.transactionId = transactionId;
        this.confirmationToken = confirmationToken;
    }

    @Override
    public PoeConfirmResponse execute() {
        return this.getHttpClient().getForObject(PATH, this, PoeConfirmResponse.class);
    }

    public static class Builder
    extends AbstractRequestBuilder<PoeConfirmRequest> {
        private String email;
        private String result;
        private String transactionId;
        private String confirmationToken;

        public Builder(HttpClient httpClient) {
            super(httpClient);
        }

        public Builder withEmail(String email) {
            this.email = email;
            return this;
        }

        public Builder withTransactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public Builder withConfirmationToken(String confirmationToken) {
            this.confirmationToken = confirmationToken;
            return this;
        }

        public Builder withResult(String result) {
            this.result = result;
            return this;
        }

        @Override
        protected void validate() {
            Preconditions.checkState((this.email != null ? 1 : 0) != 0, (Object)"email must not be null");
        }

        @Override
        protected PoeConfirmRequest doBuild() {
            return new PoeConfirmRequest(this.httpClient, this.email, this.result, this.transactionId, this.confirmationToken);
        }
    }
}

