/*
 * Decompiled with CFR 0.152.
 */
package com.neverbounce.api.model;

import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.neverbounce.api.internal.HttpClient;
import com.neverbounce.api.model.AbstractRequest;
import com.neverbounce.api.model.AbstractRequestBuilder;
import com.neverbounce.api.model.SingleCheckResponse;

public class SingleCheckRequest
extends AbstractRequest<SingleCheckResponse> {
    public static final String PATH = "single/check";
    @Key
    private final String email;
    @Key(value="address_info")
    private final Integer addressInfo;
    @Key(value="credits_info")
    private final Integer creditsInfo;
    @Key
    private final Integer timeout;
    @Key(value="request_meta_data[leverage_historical_data]")
    private final Integer historicalData;

    SingleCheckRequest(HttpClient httpClient, String email, Integer addressInfo, Integer creditsInfo, Integer timeout, Integer historicalData) {
        super(httpClient);
        this.email = email;
        this.addressInfo = addressInfo;
        this.creditsInfo = creditsInfo;
        this.timeout = timeout;
        this.historicalData = historicalData;
    }

    @Override
    public SingleCheckResponse execute() {
        return this.getHttpClient().getForObject(PATH, this, SingleCheckResponse.class);
    }

    public static class Builder
    extends AbstractRequestBuilder<SingleCheckRequest> {
        private String email;
        private Integer addressInfo;
        private Integer creditsInfo;
        private Integer timeout;
        private Integer historicalData;

        public Builder(HttpClient httpClient) {
            super(httpClient);
        }

        public Builder withEmail(String email) {
            this.email = email;
            return this;
        }

        public Builder withAddressInfo(boolean addressInfo) {
            this.addressInfo = addressInfo ? 1 : 0;
            return this;
        }

        public Builder withCreditsInfo(boolean creditsInfo) {
            this.creditsInfo = creditsInfo ? 1 : 0;
            return this;
        }

        public Builder withTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder withHistoricalData(boolean historicalData) {
            this.historicalData = historicalData ? 1 : 0;
            return this;
        }

        @Override
        protected SingleCheckRequest doBuild() {
            return new SingleCheckRequest(this.httpClient, this.email, this.addressInfo, this.creditsInfo, this.timeout, this.historicalData);
        }

        @Override
        protected void validate() {
            Preconditions.checkState((this.email != null ? 1 : 0) != 0, (Object)"email must not be null");
        }
    }
}

