/*
 * Decompiled with CFR 0.152.
 */
package com.neverbounce.api.model;

import com.google.api.client.util.Key;
import com.neverbounce.api.model.CreditsInfo;
import com.neverbounce.api.model.Flag;
import com.neverbounce.api.model.GenericResponse;
import com.neverbounce.api.model.Result;
import java.util.HashSet;
import java.util.Set;

public class SingleCheckResponse
extends GenericResponse {
    @Key
    private Result result;
    private Set<Flag> flagsEnum;
    @Key(value="flags")
    private Set<String> flagsStrings;
    @Key(value="suggested_correction")
    private String suggestedCorrection;
    @Key(value="retry_token")
    private String retryToken;
    @Key(value="address_info")
    private AddressInfo addressInfo;
    @Key(value="credits_info")
    private CreditsInfo creditsInfo;

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public Set<Flag> getFlags() {
        return this.flagsEnum;
    }

    public void setFlags(Set<Flag> flags) {
        this.flagsEnum = flags;
    }

    public Set<String> getFlagsStrings() {
        return this.flagsStrings;
    }

    public void setFlagsStrings(Set<String> flags) {
        this.flagsStrings = flags;
        HashSet<Flag> flagsSet = new HashSet<Flag>();
        for (String flagString : this.hydrateFlags(flags)) {
            Flag flag;
            if (flagString == null) continue;
            try {
                flag = Flag.valueOf(flagString.toUpperCase());
            }
            catch (Exception e) {
                continue;
            }
            flagsSet.add(flag);
        }
        this.flagsEnum = flagsSet;
    }

    public String getSuggestedCorrection() {
        return this.suggestedCorrection;
    }

    public void setSuggestedCorrection(String suggestedCorrection) {
        this.suggestedCorrection = suggestedCorrection;
    }

    public String getRetryToken() {
        return this.retryToken;
    }

    public void setRetryToken(String retryToken) {
        this.retryToken = retryToken;
    }

    public AddressInfo getAddressInfo() {
        return this.addressInfo;
    }

    public void setAddressInfo(AddressInfo addressInfo) {
        this.addressInfo = addressInfo;
    }

    public CreditsInfo getCreditsInfo() {
        return this.creditsInfo;
    }

    public void setCreditsInfo(CreditsInfo creditsInfo) {
        this.creditsInfo = creditsInfo;
    }

    private Set<String> hydrateFlags(Set<String> flags) {
        HashSet<String> hydratedFlags = new HashSet<String>();
        for (String flag : flags) {
            if (flag.toUpperCase().equals("ACCEPTS_ALL")) {
                flag = Flag.ACCEPT_ALL.name();
            }
            hydratedFlags.add(flag);
        }
        return hydratedFlags;
    }

    public static class AddressInfo {
        @Key(value="original_email")
        private String originalEmail;
        @Key(value="normalized_email")
        private String normalizedEmail;
        @Key
        private String addr;
        @Key
        private String alias;
        @Key
        private String host;
        @Key
        private String fqdn;
        @Key
        private String domain;
        @Key
        private String subdomain;
        @Key
        private String tld;

        public String getOriginalEmail() {
            return this.originalEmail;
        }

        public void setOriginalEmail(String originalEmail) {
            this.originalEmail = originalEmail;
        }

        public String getNormalizedEmail() {
            return this.normalizedEmail;
        }

        public void setNormalizedEmail(String normalizedEmail) {
            this.normalizedEmail = normalizedEmail;
        }

        public String getAddr() {
            return this.addr;
        }

        public void setAddr(String addr) {
            this.addr = addr;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public String getFqdn() {
            return this.fqdn;
        }

        public void setFqdn(String fqdn) {
            this.fqdn = fqdn;
        }

        public String getDomain() {
            return this.domain;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public String getSubdomain() {
            return this.subdomain;
        }

        public void setSubdomain(String subdomain) {
            this.subdomain = subdomain;
        }

        public String getTld() {
            return this.tld;
        }

        public void setTld(String tld) {
            this.tld = tld;
        }
    }
}

