/*
 * Decompiled with CFR 0.152.
 */
package com.nfbsoftware.opensalt;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.difflib.algorithm.DiffException;
import com.github.difflib.text.DiffRow;
import com.github.difflib.text.DiffRowGenerator;
import com.nfbsoftware.opensalt.CrosswalkClient;
import com.nfbsoftware.opensalt.model.CFAssociation;
import com.nfbsoftware.opensalt.model.CFDocument;
import com.nfbsoftware.opensalt.model.CFDocumentURI;
import com.nfbsoftware.opensalt.model.CFItem;
import com.nfbsoftware.opensalt.model.CFItemTypeURI;
import com.nfbsoftware.opensalt.model.CFPackages;
import com.nfbsoftware.opensalt.model.DestinationNodeURI;
import com.nfbsoftware.opensalt.model.Documents;
import com.nfbsoftware.opensalt.model.OriginNodeURI;
import com.nfbsoftware.pcg.model.ExactMatchOf;
import com.nfbsoftware.pcg.model.IsRelatedTo;
import com.nfbsoftware.pcg.model.PCGCrosswalk;
import com.nfbsoftware.standards.model.Crosswalk;
import com.nfbsoftware.standards.model.Standard;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

public class OpenSALTClient {
    private static final Log logger = LogFactory.getLog(OpenSALTClient.class);
    private String m_hostDomain;
    private String m_hostScheme;
    private int m_hostPort;
    private String m_authenticationUrl;
    private String m_grantType;
    private String m_scope;
    private String m_clientId;
    private String m_clientSecret;
    private String m_token;

    public OpenSALTClient(String hostDomain, int hostPort, String hostScheme) {
        this.m_hostDomain = hostDomain;
        this.m_hostPort = hostPort;
        this.m_hostScheme = hostScheme;
    }

    public void setCredentials(String authenticationUrl, String clientId, String clientSecret, String grantType, String scope) throws Exception {
        this.m_authenticationUrl = authenticationUrl;
        this.m_clientId = clientId;
        this.m_clientSecret = clientSecret;
        this.m_grantType = grantType;
        this.m_scope = scope;
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost postRequest = new HttpPost(this.m_authenticationUrl);
        String usernamePassword = this.m_clientId + ":" + this.m_clientSecret;
        String encodedString = Base64.getEncoder().encodeToString(usernamePassword.getBytes());
        postRequest.setHeader("Authorization", "Basic " + encodedString);
        postRequest.setHeader("Content-Type", "application/x-www-form-urlencoded");
        ArrayList<BasicNameValuePair> postParameters = new ArrayList<BasicNameValuePair>();
        postParameters.add(new BasicNameValuePair("grant_type", this.m_grantType));
        postParameters.add(new BasicNameValuePair("scope", this.m_scope));
        postRequest.setEntity((HttpEntity)new UrlEncodedFormEntity(postParameters, "UTF-8"));
        HttpResponse saltyResponse = httpClient.execute((HttpUriRequest)postRequest);
        HttpEntity entity = saltyResponse.getEntity();
        if (entity != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            JSONObject responseJSON = new JSONObject(responseString);
            this.m_token = StringUtils.stripToEmpty((String)responseJSON.getString("access_token"));
        }
    }

    public void refreshAccessToken() throws Exception {
        if (this.m_token != null) {
            this.setCredentials(this.m_authenticationUrl, this.m_clientId, this.m_clientSecret, this.m_grantType, this.m_scope);
        }
    }

    public List<CFDocument> getAllCFDocuments() throws Exception {
        HttpResponse saltyResponse;
        HttpEntity entity;
        List<CFDocument> cfDocumentList = new ArrayList<CFDocument>();
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpHost target = new HttpHost(this.m_hostDomain, this.m_hostPort, this.m_hostScheme);
        logger.debug((Object)"Getting All CFDocuments");
        HttpGet getRequest = new HttpGet("/ims/case/v1p0/CFDocuments");
        if (this.m_token != null) {
            getRequest.setHeader("Authorization", "Bearer " + this.m_token);
        }
        if ((entity = (saltyResponse = httpClient.execute(target, (HttpRequest)getRequest)).getEntity()) != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            JSONObject responseJSON = new JSONObject(responseString);
            ObjectMapper mapper = new ObjectMapper();
            Documents objectValue = (Documents)mapper.readValue(responseJSON.toString(), Documents.class);
            cfDocumentList = objectValue.getCFDocuments();
        }
        return cfDocumentList;
    }

    public List<CFDocument> getCFDocuments(int limit, int offset, String sort, String orderBy) throws Exception {
        HttpResponse saltyResponse;
        HttpEntity entity;
        List<CFDocument> cfDocumentList = new ArrayList<CFDocument>();
        sort = StringUtils.defaultIfEmpty((String)sort, (String)"title");
        orderBy = StringUtils.defaultIfEmpty((String)orderBy, (String)"asc");
        limit = limit > 100 ? 100 : limit;
        logger.debug((Object)("Getting CFDocuments:  Limit=" + limit + " Offset=" + offset + " Sort=" + sort + " Order By=" + orderBy));
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpHost target = new HttpHost(this.m_hostDomain, this.m_hostPort, this.m_hostScheme);
        HttpGet getRequest = new HttpGet("/ims/case/v1p0/CFDocuments?limit=" + limit + "&offset=" + offset + "&sort=" + sort + "&orderBy=" + orderBy);
        if (this.m_token != null) {
            getRequest.setHeader("Authorization", "Bearer " + this.m_token);
        }
        if ((entity = (saltyResponse = httpClient.execute(target, (HttpRequest)getRequest)).getEntity()) != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            JSONObject responseJSON = new JSONObject(responseString);
            ObjectMapper mapper = new ObjectMapper();
            Documents objectValue = (Documents)mapper.readValue(responseJSON.toString(), Documents.class);
            cfDocumentList = objectValue.getCFDocuments();
        }
        return cfDocumentList;
    }

    public CFDocument getCFDocument(String sourceId) throws Exception {
        HttpResponse saltyResponse;
        HttpEntity entity;
        CFDocument cfDocument = null;
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpHost target = new HttpHost(this.m_hostDomain, this.m_hostPort, this.m_hostScheme);
        logger.debug((Object)("Getting CFDocument " + sourceId));
        HttpGet getRequest = new HttpGet("/ims/case/v1p0/CFDocuments/" + sourceId);
        if (this.m_token != null) {
            getRequest.setHeader("Authorization", "Bearer " + this.m_token);
        }
        if ((entity = (saltyResponse = httpClient.execute(target, (HttpRequest)getRequest)).getEntity()) != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            JSONObject responseJSON = new JSONObject(responseString);
            ObjectMapper mapper = new ObjectMapper();
            cfDocument = (CFDocument)mapper.readValue(responseJSON.toString(), CFDocument.class);
        }
        return cfDocument;
    }

    public CFPackages getCFPackages(String sourceId) throws Exception {
        HttpResponse saltyResponse;
        HttpEntity entity;
        CFPackages cfPackages = null;
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpHost target = new HttpHost(this.m_hostDomain, this.m_hostPort, this.m_hostScheme);
        logger.debug((Object)("Getting CFPackages " + sourceId));
        HttpGet getRequest = new HttpGet("/ims/case/v1p0/CFPackages/" + sourceId);
        if (this.m_token != null) {
            getRequest.setHeader("Authorization", "Bearer " + this.m_token);
        }
        if ((entity = (saltyResponse = httpClient.execute(target, (HttpRequest)getRequest)).getEntity()) != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            JSONObject responseJSON = new JSONObject(responseString);
            ObjectMapper mapper = new ObjectMapper();
            cfPackages = (CFPackages)mapper.readValue(responseJSON.toString(), CFPackages.class);
        }
        return cfPackages;
    }

    public List<CFItem> getCFPackageItems(String sourceId) throws Exception {
        logger.debug((Object)("Getting getCFPackageItems " + sourceId));
        CFPackages cfPackages = this.getCFPackages(sourceId);
        List<CFItem> cfItems = cfPackages.getCFItems();
        return cfItems;
    }

    public List<CFItem> getTopLevelCFPackageItems(String sourceId) throws Exception {
        logger.debug((Object)("Getting getTopLevelCFPackageItems " + sourceId));
        HashSet<String> itemIds = new HashSet<String>();
        HashMap<Integer, CFItem> topLevelStandardsMap = new HashMap<Integer, CFItem>();
        CFPackages cfPackages = this.getCFPackages(sourceId);
        List<CFItem> cfItems = cfPackages.getCFItems();
        block0: for (CFItem tmpCFItem : cfItems) {
            if (itemIds.contains(tmpCFItem.getIdentifier())) continue;
            List<CFAssociation> tmpAssociations = cfPackages.getCFAssociations();
            for (CFAssociation tmpCFAssociation : tmpAssociations) {
                OriginNodeURI tmpOriginNodeURI = tmpCFAssociation.getOriginNodeURI();
                DestinationNodeURI tmpDestinationNodeURI = tmpCFAssociation.getDestinationNodeURI();
                if (tmpDestinationNodeURI == null || tmpOriginNodeURI == null || !tmpDestinationNodeURI.getIdentifier().equalsIgnoreCase(sourceId) || !tmpOriginNodeURI.getIdentifier().equalsIgnoreCase(tmpCFItem.getIdentifier())) continue;
                Integer sequenceNumber = tmpCFAssociation.getSequenceNumber();
                if (sequenceNumber == null) {
                    sequenceNumber = new Integer(topLevelStandardsMap.size());
                }
                topLevelStandardsMap.put(sequenceNumber, tmpCFItem);
                itemIds.add(tmpCFItem.getIdentifier());
                continue block0;
            }
        }
        TreeSet sortedTopLevelStandards = new TreeSet(topLevelStandardsMap.keySet());
        ArrayList<CFItem> topLevelCfItems = new ArrayList<CFItem>();
        for (Integer key : sortedTopLevelStandards) {
            topLevelCfItems.add((CFItem)topLevelStandardsMap.get(key));
        }
        return topLevelCfItems;
    }

    public List<CFAssociation> getCFPackageAssociations(String sourceId) throws Exception {
        logger.debug((Object)("Getting getCFPackageAssociations " + sourceId));
        CFPackages cfPackages = this.getCFPackages(sourceId);
        List<CFAssociation> cfAssociations = cfPackages.getCFAssociations();
        return cfAssociations;
    }

    public CFItem getCFItem(String sourceId) throws Exception {
        HttpResponse saltyResponse;
        HttpEntity entity;
        CFItem cfItem = null;
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpHost target = new HttpHost(this.m_hostDomain, this.m_hostPort, this.m_hostScheme);
        logger.debug((Object)("Getting getCFItem " + sourceId));
        HttpGet getRequest = new HttpGet("/ims/case/v1p0/CFItems/" + sourceId);
        if (this.m_token != null) {
            getRequest.setHeader("Authorization", "Bearer " + this.m_token);
        }
        if ((entity = (saltyResponse = httpClient.execute(target, (HttpRequest)getRequest)).getEntity()) != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            JSONObject responseJSON = new JSONObject(responseString);
            ObjectMapper mapper = new ObjectMapper();
            cfItem = (CFItem)mapper.readValue(responseJSON.toString(), CFItem.class);
        }
        return cfItem;
    }

    public CFItem getCFItemParent(String sourceId) throws Exception {
        List<CFAssociation> associations;
        CFItem cfItemParent = null;
        CFItem childItem = this.getCFItem(sourceId);
        if (childItem != null && (associations = this.getCFItemAssociations(sourceId)) != null) {
            for (CFAssociation tmpCFAssociation : associations) {
                String parentItemId;
                DestinationNodeURI destinationNodeURI;
                if (!tmpCFAssociation.getAssociationType().equalsIgnoreCase("isChildOf") || (destinationNodeURI = tmpCFAssociation.getDestinationNodeURI()) == null || (parentItemId = destinationNodeURI.getIdentifier()).equalsIgnoreCase(sourceId)) continue;
                cfItemParent = this.getCFItem(parentItemId);
                break;
            }
        }
        return cfItemParent;
    }

    public List<CFAssociation> getCFItemAssociations(String sourceId) throws Exception {
        HttpResponse saltyResponse;
        HttpEntity entity;
        List<CFAssociation> cfAssociations = null;
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpHost target = new HttpHost(this.m_hostDomain, this.m_hostPort, this.m_hostScheme);
        logger.debug((Object)("Getting CFDocument " + sourceId));
        HttpGet getRequest = new HttpGet("/ims/case/v1p0/CFItemAssociations/" + sourceId);
        if (this.m_token != null) {
            getRequest.setHeader("Authorization", "Bearer " + this.m_token);
        }
        if ((entity = (saltyResponse = httpClient.execute(target, (HttpRequest)getRequest)).getEntity()) != null) {
            String responseString = EntityUtils.toString((HttpEntity)entity);
            JSONObject responseJSON = new JSONObject(responseString);
            ObjectMapper mapper = new ObjectMapper();
            CFItem tmpCFItem = (CFItem)mapper.readValue(responseJSON.toString(), CFItem.class);
            cfAssociations = tmpCFItem.getCFAssociations();
        }
        return cfAssociations;
    }

    public Standard getFullHierarchicalStandard(String sourceId) throws Exception {
        Standard standardDocument = null;
        CFDocument tmpCFDocument = this.getCFDocument(sourceId);
        if (tmpCFDocument.getIdentifier() != null) {
            standardDocument = new Standard();
            standardDocument.setId(tmpCFDocument.getIdentifier());
            standardDocument.setDocumentId(tmpCFDocument.getIdentifier());
            standardDocument.setDocumentTitle(StringUtils.stripToEmpty((String)tmpCFDocument.getTitle()));
            standardDocument.setFullStatement(StringUtils.stripToEmpty((String)tmpCFDocument.getTitle()));
            standardDocument.setNotes(StringUtils.stripToEmpty((String)tmpCFDocument.getNotes()));
            standardDocument.setCreator(StringUtils.stripToEmpty((String)tmpCFDocument.getCreator()));
            standardDocument.setAdoptionStatus(StringUtils.stripToEmpty((String)tmpCFDocument.getAdoptionStatus()));
            standardDocument.setLanguage(StringUtils.stripToEmpty((String)tmpCFDocument.getLanguage()));
            HashMap<String, CFItem> cfItemsMap = new HashMap<String, CFItem>();
            CFPackages cfPackages = this.getCFPackages(sourceId);
            List<CFItem> cfItems = cfPackages.getCFItems();
            for (CFItem cFItem : cfItems) {
                cfItemsMap.put(cFItem.getIdentifier(), cFItem);
            }
            HashMap<Integer, Standard> topLevelStandardsMap = new HashMap<Integer, Standard>();
            for (CFItem tmpCFItem : cfItems) {
                Integer sequenceNumber = null;
                boolean isTopLevelItem = false;
                List<CFAssociation> tmpAssociations = cfPackages.getCFAssociations();
                for (CFAssociation tmpCFAssociation : tmpAssociations) {
                    OriginNodeURI tmpOriginNodeURI = tmpCFAssociation.getOriginNodeURI();
                    DestinationNodeURI tmpDestinationNodeURI = tmpCFAssociation.getDestinationNodeURI();
                    if (tmpDestinationNodeURI == null || tmpOriginNodeURI == null || !tmpDestinationNodeURI.getIdentifier().equalsIgnoreCase(sourceId) || !tmpOriginNodeURI.getIdentifier().equalsIgnoreCase(tmpCFItem.getIdentifier())) continue;
                    isTopLevelItem = true;
                    sequenceNumber = tmpCFAssociation.getSequenceNumber();
                    break;
                }
                if (!isTopLevelItem) continue;
                Standard topLevelStandard = new Standard();
                topLevelStandard.setId(tmpCFItem.getIdentifier());
                topLevelStandard.setFullStatement(StringUtils.stripToEmpty((String)tmpCFItem.getFullStatement()));
                topLevelStandard.setNotes(StringUtils.stripToEmpty((String)tmpCFItem.getNotes()));
                topLevelStandard.setHumanCodingScheme(StringUtils.stripToEmpty((String)tmpCFItem.getHumanCodingScheme()));
                topLevelStandard.setListEnumeration(StringUtils.stripToEmpty((String)tmpCFItem.getListEnumeration()));
                topLevelStandard.setType(StringUtils.stripToEmpty((String)tmpCFItem.getCFItemType()));
                CFItemTypeURI tmpCFItemTypeURI = tmpCFItem.getCFItemTypeURI();
                if (tmpCFItemTypeURI != null) {
                    topLevelStandard.setTypeId(StringUtils.stripToEmpty((String)tmpCFItemTypeURI.getIdentifier()));
                }
                topLevelStandard.setDocumentId(standardDocument.getId());
                topLevelStandard.setDocumentTitle(standardDocument.getDocumentTitle());
                topLevelStandard.setCreator(standardDocument.getCreator());
                topLevelStandard.setAdoptionStatus(standardDocument.getAdoptionStatus());
                topLevelStandard.setLanguage(standardDocument.getLanguage());
                this.getChildAssociations(standardDocument, cfItemsMap, topLevelStandard);
                if (sequenceNumber == null) {
                    sequenceNumber = new Integer(topLevelStandardsMap.size());
                }
                topLevelStandardsMap.put(sequenceNumber, topLevelStandard);
            }
            TreeSet treeSet = new TreeSet(topLevelStandardsMap.keySet());
            ArrayList<Standard> topLevelStandards = new ArrayList<Standard>();
            for (Integer key : treeSet) {
                topLevelStandards.add((Standard)topLevelStandardsMap.get(key));
            }
            standardDocument.setStandards(topLevelStandards);
        } else {
            CFItem tempCFItem = this.getCFItem(sourceId);
            if (tempCFItem != null) {
                tmpCFDocument = this.getCFDocument(tempCFItem.getCFDocumentURI().getIdentifier());
                HashMap<String, CFItem> cfItemsMap = new HashMap<String, CFItem>();
                CFPackages cfPackages = this.getCFPackages(tmpCFDocument.getIdentifier());
                List<CFItem> cfItems = cfPackages.getCFItems();
                for (CFItem tmpCFItem : cfItems) {
                    cfItemsMap.put(tmpCFItem.getIdentifier(), tmpCFItem);
                }
                standardDocument = new Standard();
                standardDocument.setId(tempCFItem.getIdentifier());
                standardDocument.setDocumentId(tmpCFDocument.getIdentifier());
                standardDocument.setDocumentTitle(StringUtils.stripToEmpty((String)tmpCFDocument.getTitle()));
                standardDocument.setFullStatement(StringUtils.stripToEmpty((String)tempCFItem.getFullStatement()));
                standardDocument.setNotes(StringUtils.stripToEmpty((String)tempCFItem.getNotes()));
                standardDocument.setCreator(StringUtils.stripToEmpty((String)tmpCFDocument.getCreator()));
                standardDocument.setAdoptionStatus(StringUtils.stripToEmpty((String)tmpCFDocument.getAdoptionStatus()));
                standardDocument.setLanguage(StringUtils.stripToEmpty((String)tmpCFDocument.getLanguage()));
                standardDocument.setHumanCodingScheme(StringUtils.stripToEmpty((String)tempCFItem.getHumanCodingScheme()));
                standardDocument.setListEnumeration(StringUtils.stripToEmpty((String)tempCFItem.getListEnumeration()));
                standardDocument.setType(StringUtils.stripToEmpty((String)tempCFItem.getCFItemType()));
                this.getChildAssociations(standardDocument, cfItemsMap, standardDocument);
            }
        }
        return standardDocument;
    }

    private void getChildAssociations(Standard standardDocument, Map<String, CFItem> cfItemsMap, Standard parentStandard) throws Exception {
        List<CFAssociation> tmpAssociations = this.getCFItemAssociations(parentStandard.getId());
        HashMap<Integer, Standard> topLevelStandardsMap = new HashMap<Integer, Standard>();
        for (CFAssociation tmpCFAssociation : tmpAssociations) {
            OriginNodeURI tmpOriginNodeURI;
            if (!tmpCFAssociation.getAssociationType().equalsIgnoreCase("isChildOf") || (tmpOriginNodeURI = tmpCFAssociation.getOriginNodeURI()) == null || tmpOriginNodeURI.getIdentifier().equalsIgnoreCase(parentStandard.getId())) continue;
            CFItem childCFItem = cfItemsMap.get(tmpOriginNodeURI.getIdentifier());
            Standard childStandard = new Standard();
            childStandard.setId(childCFItem.getIdentifier());
            childStandard.setParentId(parentStandard.getId());
            childStandard.setFullStatement(StringUtils.stripToEmpty((String)childCFItem.getFullStatement()));
            childStandard.setNotes(StringUtils.stripToEmpty((String)childCFItem.getNotes()));
            childStandard.setHumanCodingScheme(StringUtils.stripToEmpty((String)childCFItem.getHumanCodingScheme()));
            childStandard.setListEnumeration(StringUtils.stripToEmpty((String)childCFItem.getListEnumeration()));
            childStandard.setType(StringUtils.stripToEmpty((String)childCFItem.getCFItemType()));
            CFItemTypeURI childCFItemTypeURI = childCFItem.getCFItemTypeURI();
            if (childCFItemTypeURI != null) {
                childStandard.setTypeId(StringUtils.stripToEmpty((String)childCFItemTypeURI.getIdentifier()));
            }
            childStandard.setDocumentId(standardDocument.getId());
            childStandard.setDocumentTitle(standardDocument.getDocumentTitle());
            childStandard.setCreator(standardDocument.getCreator());
            childStandard.setAdoptionStatus(standardDocument.getAdoptionStatus());
            childStandard.setLanguage(standardDocument.getLanguage());
            this.getChildAssociations(standardDocument, cfItemsMap, childStandard);
            Integer sequenceNumber = tmpCFAssociation.getSequenceNumber();
            if (sequenceNumber == null) {
                sequenceNumber = new Integer(topLevelStandardsMap.size());
            }
            topLevelStandardsMap.put(sequenceNumber, childStandard);
        }
        TreeSet sortedTopLevelStandards = new TreeSet(topLevelStandardsMap.keySet());
        for (Integer key : sortedTopLevelStandards) {
            parentStandard.getStandards().add((Standard)topLevelStandardsMap.get(key));
        }
    }

    public Crosswalk getCFItemCrosswalkByDocumentTitle(String rosettaDocumentTitle, String fromCFItemId, String toCFItemId) throws Exception {
        String rosettaCFDocumentId = "";
        List<CFAssociation> fromCFAssociations = this.getCFItemAssociations(fromCFItemId);
        for (CFAssociation tmpCFAssociation : fromCFAssociations) {
            String associatedItemId = tmpCFAssociation.getDestinationNodeURI().getIdentifier();
            CFItem associatedItem = this.getCFItem(associatedItemId);
            if (!associatedItem.getCFDocumentURI().getTitle().contains(rosettaDocumentTitle)) continue;
            rosettaCFDocumentId = associatedItem.getCFDocumentURI().getIdentifier();
            break;
        }
        if (!StringUtils.isEmpty((String)rosettaCFDocumentId)) {
            return this.getCFItemCrosswalk(rosettaCFDocumentId, fromCFItemId, toCFItemId);
        }
        return null;
    }

    public Crosswalk getCFItemCrosswalk(String rosettaCFDocumentId, String fromCFItemId, String toCFItemId) throws Exception {
        Crosswalk tmpCrosswalk = new Crosswalk();
        CFDocument rosettaDocument = this.getCFDocument(rosettaCFDocumentId);
        tmpCrosswalk.setCfDocumentId(rosettaCFDocumentId);
        tmpCrosswalk.setCfDocument(rosettaDocument);
        CFItem fromCFItem = this.getCFItem(fromCFItemId);
        tmpCrosswalk.setFromCFItemId(fromCFItem.getIdentifier());
        tmpCrosswalk.setFromCFItem(fromCFItem);
        CFItem toCFItem = this.getCFItem(toCFItemId);
        tmpCrosswalk.setToCFItemId(toCFItem.getIdentifier());
        tmpCrosswalk.setToCFItem(toCFItem);
        ArrayList<CFItem> rosettaItemAssociations = new ArrayList<CFItem>();
        List<CFAssociation> fromCFAssociations = this.getCFItemAssociations(fromCFItem.getIdentifier());
        for (CFAssociation tmpCFAssociation : fromCFAssociations) {
            String associatedItemId;
            CFItem associatedItem;
            if (tmpCFAssociation.getAssociationType().equalsIgnoreCase("isChildOf") || !(associatedItem = this.getCFItem(associatedItemId = tmpCFAssociation.getDestinationNodeURI().getIdentifier())).getCFDocumentURI().getIdentifier().equalsIgnoreCase(rosettaDocument.getIdentifier())) continue;
            rosettaItemAssociations.add(associatedItem);
            tmpCrosswalk.getAssociationTypes().add(tmpCFAssociation.getAssociationType());
            tmpCrosswalk.setFromItemAssociationOfDocument(tmpCFAssociation.getAssociationType());
            break;
        }
        block1: for (CFItem tmpRosettaCFItem : rosettaItemAssociations) {
            List<CFAssociation> toCFAssociations = this.getCFItemAssociations(tmpRosettaCFItem.getIdentifier());
            for (CFAssociation tmpCFAssociation : toCFAssociations) {
                OriginNodeURI tmpOriginNodeURI;
                if (tmpCFAssociation.getAssociationType().equalsIgnoreCase("isChildOf") || (tmpOriginNodeURI = tmpCFAssociation.getOriginNodeURI()) == null || !tmpOriginNodeURI.getIdentifier().equalsIgnoreCase(toCFItem.getIdentifier())) continue;
                tmpCrosswalk.getAssociationTypes().add(tmpCFAssociation.getAssociationType());
                tmpCrosswalk.setDocumentAssociationOfToItem(tmpCFAssociation.getAssociationType());
                continue block1;
            }
        }
        String fromText = fromCFItem.getFullStatement();
        String toText = toCFItem.getFullStatement();
        String semanticComparison = this.generateSemanticComparison(fromText, toText);
        tmpCrosswalk.setSemanticComparison(semanticComparison);
        return tmpCrosswalk;
    }

    public List<Crosswalk> getCFItemCrosswalksByDocumentTitle(String rosettaDocumentTitle, String fromCFItemId, String toCFDocumentId) throws Exception {
        String rosettaCFDocumentId = "";
        List<CFAssociation> fromCFAssociations = this.getCFItemAssociations(fromCFItemId);
        for (CFAssociation tmpCFAssociation : fromCFAssociations) {
            String associatedItemId = tmpCFAssociation.getDestinationNodeURI().getIdentifier();
            CFItem associatedItem = this.getCFItem(associatedItemId);
            CFDocumentURI associatedCFDocumentURI = associatedItem.getCFDocumentURI();
            if (associatedCFDocumentURI == null || !associatedCFDocumentURI.getTitle().contains(rosettaDocumentTitle)) continue;
            rosettaCFDocumentId = associatedItem.getCFDocumentURI().getIdentifier();
            break;
        }
        if (!StringUtils.isEmpty((String)rosettaCFDocumentId)) {
            return this.getCFItemCrosswalks(rosettaCFDocumentId, fromCFItemId, toCFDocumentId);
        }
        return new ArrayList<Crosswalk>();
    }

    public List<Crosswalk> getCFItemCrosswalks(String rosettaCFDocumentId, String fromCFItemId, String toCFDocumentId) throws Exception {
        HashSet<String> toItemIds = new HashSet<String>();
        ArrayList<Crosswalk> tmpCrosswalkList = new ArrayList<Crosswalk>();
        CFDocument rosettaDocument = this.getCFDocument(rosettaCFDocumentId);
        CFItem fromCFItem = this.getCFItem(fromCFItemId);
        ArrayList<CFItem> rosettaItemAssociations = new ArrayList<CFItem>();
        List<CFAssociation> fromCFAssociations = this.getCFItemAssociations(fromCFItem.getIdentifier());
        for (CFAssociation tmpCFAssociation : fromCFAssociations) {
            String associatedItemId;
            CFItem associatedItem;
            if (tmpCFAssociation.getAssociationType().equalsIgnoreCase("isChildOf") || !(associatedItem = this.getCFItem(associatedItemId = tmpCFAssociation.getDestinationNodeURI().getIdentifier())).getCFDocumentURI().getIdentifier().equalsIgnoreCase(rosettaDocument.getIdentifier())) continue;
            rosettaItemAssociations.add(associatedItem);
            break;
        }
        for (CFItem tmpRosettaCFItem : rosettaItemAssociations) {
            List<CFAssociation> toCFAssociations = this.getCFItemAssociations(tmpRosettaCFItem.getIdentifier());
            for (CFAssociation tmpCFAssociation : toCFAssociations) {
                CFItem originItem;
                OriginNodeURI tmpOriginNodeURI;
                if (tmpCFAssociation.getAssociationType().equalsIgnoreCase("isChildOf") || (tmpOriginNodeURI = tmpCFAssociation.getOriginNodeURI()) == null || !tmpCFAssociation.getCFDocumentURI().getIdentifier().equalsIgnoreCase(toCFDocumentId) || toItemIds.contains((originItem = this.getCFItem(tmpOriginNodeURI.getIdentifier())).getIdentifier())) continue;
                Crosswalk tmpCrosswalk = new Crosswalk();
                tmpCrosswalk.setCfDocumentId(rosettaCFDocumentId);
                tmpCrosswalk.setCfDocument(rosettaDocument);
                tmpCrosswalk.setFromCFItemId(fromCFItem.getIdentifier());
                tmpCrosswalk.setFromCFItem(fromCFItem);
                tmpCrosswalk.setToCFItemId(originItem.getIdentifier());
                tmpCrosswalk.setToCFItem(originItem);
                tmpCrosswalk.getAssociationTypes().add(tmpCFAssociation.getAssociationType());
                tmpCrosswalk.setDocumentAssociationOfToItem(tmpCFAssociation.getAssociationType());
                String fromText = StringUtils.trimToEmpty((String)fromCFItem.getFullStatement());
                String toText = StringUtils.trimToEmpty((String)originItem.getFullStatement());
                String semanticComparison = this.generateSemanticComparison(fromText, toText);
                tmpCrosswalk.setSemanticComparison(semanticComparison);
                tmpCrosswalkList.add(tmpCrosswalk);
                toItemIds.add(originItem.getIdentifier());
            }
        }
        return tmpCrosswalkList;
    }

    public List<Crosswalk> getCFItemCrosswalks(CrosswalkClient crosswalkClient, String fromCFItemId, String targetCFDocumentId) throws Exception {
        CFItem fromCFItem = this.getCFItem(fromCFItemId);
        return this.getCFItemCrosswalks(crosswalkClient, fromCFItem, targetCFDocumentId);
    }

    public List<Crosswalk> getCFItemCrosswalks(CrosswalkClient crosswalkClient, CFItem fromCFItem, String targetCFDocumentId) throws Exception {
        ArrayList<Crosswalk> tmpCrosswalkList = new ArrayList<Crosswalk>();
        CFDocument targetDocument = this.getCFDocument(targetCFDocumentId);
        PCGCrosswalk tmpPCGCrosswalk = crosswalkClient.crosswalkByIdentifier(fromCFItem.getIdentifier(), targetCFDocumentId);
        if (tmpPCGCrosswalk != null) {
            String semanticComparison;
            String toText;
            String fromText;
            CFItem toCFItem;
            Crosswalk tmpCrosswalk;
            for (ExactMatchOf tmpExactMatchOf : tmpPCGCrosswalk.getExactMatchOf()) {
                tmpCrosswalk = new Crosswalk();
                tmpCrosswalk.setCfDocumentId(targetCFDocumentId);
                tmpCrosswalk.setCfDocument(targetDocument);
                tmpCrosswalk.setFromCFItemId(fromCFItem.getIdentifier());
                tmpCrosswalk.setFromCFItem(fromCFItem);
                toCFItem = this.getCFItem(tmpExactMatchOf.getIdentifier());
                tmpCrosswalk.setToCFItemId(toCFItem.getIdentifier());
                tmpCrosswalk.setToCFItem(toCFItem);
                fromText = fromCFItem.getFullStatement();
                toText = toCFItem.getFullStatement();
                tmpCrosswalk.getAssociationTypes().add("exactMatchOf");
                tmpCrosswalk.setDocumentAssociationOfToItem("exactMatchOf");
                semanticComparison = this.generateSemanticComparison(fromText, toText);
                tmpCrosswalk.setSemanticComparison(semanticComparison);
                tmpCrosswalkList.add(tmpCrosswalk);
            }
            for (IsRelatedTo tmpIsRelatedTo : tmpPCGCrosswalk.getIsRelatedTo()) {
                tmpCrosswalk = new Crosswalk();
                tmpCrosswalk.setCfDocumentId(targetCFDocumentId);
                tmpCrosswalk.setCfDocument(targetDocument);
                tmpCrosswalk.setFromCFItemId(fromCFItem.getIdentifier());
                tmpCrosswalk.setFromCFItem(fromCFItem);
                toCFItem = this.getCFItem(tmpIsRelatedTo.getIdentifier());
                tmpCrosswalk.setToCFItemId(toCFItem.getIdentifier());
                tmpCrosswalk.setToCFItem(toCFItem);
                fromText = fromCFItem.getFullStatement();
                toText = toCFItem.getFullStatement();
                tmpCrosswalk.getAssociationTypes().add("isRelatedTo");
                tmpCrosswalk.setDocumentAssociationOfToItem("isRelatedTo");
                semanticComparison = this.generateSemanticComparison(fromText, toText);
                tmpCrosswalk.setSemanticComparison(semanticComparison);
                tmpCrosswalkList.add(tmpCrosswalk);
            }
        } else {
            logger.error((Object)("No PCG crosswalk data found, null pointer, for target document: " + targetDocument.getTitle() + " (" + targetDocument.getIdentifier() + ")"));
        }
        return tmpCrosswalkList;
    }

    public Map<String, List<Crosswalk>> getCFItemCrosswalksByIds(CrosswalkClient crosswalkClient, List<String> fromCFItemIds, String targetCFDocumentId) throws Exception {
        ArrayList<CFItem> fromCFItems = new ArrayList<CFItem>();
        return this.getCFItemCrosswalks(crosswalkClient, fromCFItems, targetCFDocumentId);
    }

    public Map<String, List<Crosswalk>> getCFItemCrosswalks(CrosswalkClient crosswalkClient, List<CFItem> fromCFItems, String targetCFDocumentId) throws Exception {
        HashMap<String, List<Crosswalk>> tmpCrosswalkMap = new HashMap<String, List<Crosswalk>>();
        CFDocument targetDocument = this.getCFDocument(targetCFDocumentId);
        ArrayList<String> fromCFItemIds = new ArrayList<String>();
        HashMap<String, CFItem> fromItemMap = new HashMap<String, CFItem>();
        for (CFItem tmpCFItem : fromCFItems) {
            fromCFItemIds.add(tmpCFItem.getIdentifier());
            fromItemMap.put(tmpCFItem.getIdentifier(), tmpCFItem);
        }
        Map<String, PCGCrosswalk> tmpPCGCrosswalks = crosswalkClient.crosswalkByIdentifiers(fromCFItemIds, targetCFDocumentId);
        for (String fromIdKey : tmpPCGCrosswalks.keySet()) {
            ArrayList<Crosswalk> tmpCrosswalkList = new ArrayList<Crosswalk>();
            CFItem fromCFItem = (CFItem)fromItemMap.get(fromIdKey);
            PCGCrosswalk tmpPCGCrosswalk = tmpPCGCrosswalks.get(fromIdKey);
            if (tmpPCGCrosswalk != null) {
                String semanticComparison;
                String toText;
                String fromText;
                CFItem toCFItem;
                Crosswalk tmpCrosswalk;
                for (ExactMatchOf tmpExactMatchOf : tmpPCGCrosswalk.getExactMatchOf()) {
                    tmpCrosswalk = new Crosswalk();
                    tmpCrosswalk.setCfDocumentId(targetCFDocumentId);
                    tmpCrosswalk.setCfDocument(targetDocument);
                    tmpCrosswalk.setFromCFItemId(fromCFItem.getIdentifier());
                    tmpCrosswalk.setFromCFItem(fromCFItem);
                    toCFItem = this.getCFItem(tmpExactMatchOf.getIdentifier());
                    tmpCrosswalk.setToCFItemId(toCFItem.getIdentifier());
                    tmpCrosswalk.setToCFItem(toCFItem);
                    fromText = fromCFItem.getFullStatement();
                    toText = toCFItem.getFullStatement();
                    tmpCrosswalk.getAssociationTypes().add("exactMatchOf");
                    tmpCrosswalk.setDocumentAssociationOfToItem("exactMatchOf");
                    semanticComparison = this.generateSemanticComparison(fromText, toText);
                    tmpCrosswalk.setSemanticComparison(semanticComparison);
                    tmpCrosswalkList.add(tmpCrosswalk);
                }
                for (IsRelatedTo tmpIsRelatedTo : tmpPCGCrosswalk.getIsRelatedTo()) {
                    tmpCrosswalk = new Crosswalk();
                    tmpCrosswalk.setCfDocumentId(targetCFDocumentId);
                    tmpCrosswalk.setCfDocument(targetDocument);
                    tmpCrosswalk.setFromCFItemId(fromCFItem.getIdentifier());
                    tmpCrosswalk.setFromCFItem(fromCFItem);
                    toCFItem = this.getCFItem(tmpIsRelatedTo.getIdentifier());
                    tmpCrosswalk.setToCFItemId(toCFItem.getIdentifier());
                    tmpCrosswalk.setToCFItem(toCFItem);
                    fromText = fromCFItem.getFullStatement();
                    toText = toCFItem.getFullStatement();
                    tmpCrosswalk.getAssociationTypes().add("isRelatedTo");
                    tmpCrosswalk.setDocumentAssociationOfToItem("isRelatedTo");
                    semanticComparison = this.generateSemanticComparison(fromText, toText);
                    tmpCrosswalk.setSemanticComparison(semanticComparison);
                    tmpCrosswalkList.add(tmpCrosswalk);
                }
            } else {
                logger.error((Object)("No PCG crosswalk data found, null pointer, for target document: " + targetDocument.getTitle() + " (" + targetDocument.getIdentifier() + ")"));
            }
            tmpCrosswalkMap.put(fromIdKey, tmpCrosswalkList);
        }
        return tmpCrosswalkMap;
    }

    public String getItemBreadcrumbTrail(String cfItemId) throws Exception {
        StringBuffer breadcrumbTrail = new StringBuffer();
        ArrayList<String> breadcrumbItems = new ArrayList<String>();
        this.getParentBreadcrumbs(cfItemId, breadcrumbItems);
        for (int i = breadcrumbItems.size(); i > 0; --i) {
            String tempItem = (String)breadcrumbItems.get(i - 1);
            if (StringUtils.isEmpty((String)tempItem)) continue;
            breadcrumbTrail.append(tempItem);
            if (i == 1) continue;
            breadcrumbTrail.append(" > ");
        }
        return breadcrumbTrail.toString();
    }

    public CFItem getUltimateParentItem(String cfItemId) throws Exception {
        ArrayList<CFItem> parentItems = new ArrayList<CFItem>();
        this.getParentItems(cfItemId, parentItems);
        if (parentItems.size() > 0) {
            return (CFItem)parentItems.get(parentItems.size() - 1);
        }
        return null;
    }

    private void getParentItems(String cfItemId, List<CFItem> parentItems) throws Exception {
        CFItem parentItem = this.getCFItemParent(cfItemId);
        if (parentItem != null) {
            parentItems.add(parentItem);
            this.getParentItems(parentItem.getIdentifier(), parentItems);
        }
    }

    private void getParentBreadcrumbs(String cfItemId, List<String> breadcrumbItems) throws Exception {
        CFItem parentItem = this.getCFItemParent(cfItemId);
        if (parentItem != null) {
            String tmpHumanCodingScheme = StringUtils.stripToEmpty((String)parentItem.getHumanCodingScheme());
            String tmpFullStatement = StringUtils.stripToEmpty((String)parentItem.getFullStatement());
            if (!StringUtils.isEmpty((String)tmpHumanCodingScheme)) {
                tmpFullStatement = tmpHumanCodingScheme;
            }
            breadcrumbItems.add(StringUtils.stripToEmpty((String)tmpFullStatement));
            this.getParentBreadcrumbs(parentItem.getIdentifier(), breadcrumbItems);
        }
    }

    public String generateSemanticComparison(String fromText, String toText) throws DiffException {
        String semanticComparison = "";
        DiffRowGenerator generator = DiffRowGenerator.create().showInlineDiffs(true).mergeOriginalRevised(true).inlineDiffByWord(true).oldTag(f -> f != false ? "<span class=\"openSaltOldTag\">" : "</span>").newTag(f -> f != false ? "<span class=\"openSaltNewTag\">" : "</span>").build();
        List rows = generator.generateDiffRows(Arrays.asList(fromText), Arrays.asList(toText));
        semanticComparison = ((DiffRow)rows.get(0)).getOldLine();
        return semanticComparison;
    }
}

