/*
 * Decompiled with CFR 0.152.
 */
package com.ning.api.client.access.impl;

import com.ning.api.client.NingClientConfig;
import com.ning.api.client.NingClientException;
import com.ning.api.client.access.NingConnection;
import com.ning.api.client.action.Counter;
import com.ning.api.client.exception.NingTransformException;
import com.ning.api.client.http.NingHttpGet;
import org.joda.time.ReadableDateTime;

public abstract class DefaultCounter
implements Counter {
    protected final NingConnection connection;
    protected final NingClientConfig config;
    protected final String endpoint;
    protected final ReadableDateTime createdAfter;
    protected final String author;
    protected final Boolean isPrivate;
    protected final Boolean isApproved;

    public DefaultCounter(NingConnection connection, NingClientConfig config, String endpoint, ReadableDateTime createdAfter, String author, Boolean isPrivate, Boolean isApproved) {
        this.connection = connection;
        this.config = config;
        this.endpoint = endpoint;
        this.createdAfter = createdAfter;
        this.author = author;
        this.isPrivate = isPrivate;
        this.isApproved = isApproved;
    }

    @Override
    public int count() throws NingClientException {
        NingHttpGet getter = this.buildQuery();
        Integer count = getter.execute(this.config.getReadTimeoutMsecs()).asCount();
        if (count == null) {
            throw new NingTransformException("Response did not contain 'count' property");
        }
        return count;
    }

    protected NingHttpGet buildQuery() {
        NingHttpGet getter = this.connection.prepareHttpGet(this.endpoint);
        getter = (NingHttpGet)getter.addAccept("*/*");
        getter = (NingHttpGet)getter.addQueryParameter("createdAfter", this.createdAfter.toString());
        if (this.author != null && !this.author.isEmpty()) {
            getter = (NingHttpGet)getter.addQueryParameter("author", this.author);
        }
        if (this.isPrivate != null) {
            getter = (NingHttpGet)getter.addQueryParameter("private", this.isPrivate.toString());
        }
        if (this.isApproved != null) {
            getter = (NingHttpGet)getter.addQueryParameter("approved", this.isApproved.toString());
        }
        return getter;
    }
}

