/*
 * Decompiled with CFR 0.152.
 */
package com.ning.api.client.access.impl;

import com.ning.api.client.NingClientConfig;
import com.ning.api.client.NingClientException;
import com.ning.api.client.access.NingConnection;
import com.ning.api.client.action.Finder;
import com.ning.api.client.http.NingHttpGet;
import com.ning.api.client.item.ContentItem;
import com.ning.api.client.item.Fields;
import com.ning.api.client.item.Key;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class DefaultFinder<C extends ContentItem<F, C>, F extends Enum<F>>
implements Finder<C> {
    protected final NingConnection connection;
    protected NingClientConfig config;
    protected final String endpoint;
    protected final Fields<F> fields;
    protected final Class<C> itemType;

    public DefaultFinder(NingConnection connection, NingClientConfig config, String endpoint, Class<C> itemType, Fields<F> fields) {
        this.connection = connection;
        this.config = config;
        this.endpoint = endpoint;
        this.fields = fields;
        this.itemType = itemType;
    }

    @Override
    public final C find(String id) throws NingClientException {
        return (C)this.find(new Key(id));
    }

    @Override
    public final List<C> find(Collection<String> ids) throws NingClientException {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        Key[] keys = new Key[ids.size()];
        int i = 0;
        for (String id : ids) {
            keys[i++] = new Key(id);
        }
        return this.find(keys);
    }

    @Override
    public final List<C> find(String[] ids) throws NingClientException {
        Key[] keys = new Key[ids.length];
        int len = ids.length;
        for (int i = 0; i < len; ++i) {
            keys[i] = new Key(ids[i]);
        }
        return this.find(keys);
    }

    @Override
    public C find(Key<C> id) {
        NingHttpGet getter = this.buildQuery(id);
        return (C)((ContentItem)getter.execute(this.config.getReadTimeoutMsecs()).asSingleItem(this.itemType));
    }

    @Override
    public List<C> find(Key<C>[] ids) {
        return null;
    }

    protected NingHttpGet buildQuery(Key<C> id) {
        NingHttpGet getter = this.prepareQuery();
        getter = (NingHttpGet)getter.addQueryParameter("id", id.toString());
        return getter;
    }

    protected NingHttpGet prepareQuery() {
        NingHttpGet getter = this.connection.prepareHttpGet(this.endpoint);
        getter = (NingHttpGet)getter.addAccept("* /*");
        if (this.fields != null && !this.fields.isEmpty()) {
            getter = (NingHttpGet)getter.addQueryParameter("fields", this.fields.toString());
        }
        return getter;
    }
}

