/*
 * Decompiled with CFR 0.152.
 */
package com.ning.api.client.http;

import com.ning.api.client.NingClientException;
import com.ning.api.client.access.impl.AnchorHolder;
import com.ning.api.client.exception.NingTransferException;
import com.ning.api.client.http.NingHttpException;
import com.ning.api.client.item.ContentItem;
import com.ning.api.client.json.ItemCountResponse;
import com.ning.api.client.json.ItemResponse;
import com.ning.api.client.json.ItemSequenceResponse;
import java.io.IOException;
import java.util.List;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.type.JavaType;

public abstract class NingHttpResponse {
    private final int MAX_ERROR_RESP_TO_INCLUDE = 1000;
    protected final ObjectMapper objectMapper;

    public NingHttpResponse(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public abstract int getStatusCode();

    public abstract String getResponseBody() throws NingTransferException;

    public String safeGetResponseBody() throws IOException {
        try {
            return this.getResponseBody();
        }
        catch (NingTransferException e) {
            return "[ERROR fetching response]";
        }
    }

    protected String getTruncatedResponse() {
        String msg;
        try {
            msg = this.getResponseBody();
        }
        catch (Exception e) {
            return "[failed to access response body, problem: " + e + "]";
        }
        if (msg == null || msg.length() == 0) {
            return "[no response message]";
        }
        if (msg.length() > 1000) {
            return msg.substring(0, 500) + "'...[TRUNCATED]...'" + msg.substring(msg.length() - 1000);
        }
        return msg;
    }

    public <T> T asSingleItem(Class<T> itemClass) throws NingClientException {
        this.verifyResponse();
        ItemResponse response = (ItemResponse)this.readAndBind(TypeFactory.parametricType(ItemResponse.class, (Class[])new Class[]{itemClass}));
        return response.getEntry();
    }

    public <T extends ContentItem<?, ?>> List<T> asItemList(Class<T> itemClass, AnchorHolder anchor) throws NingClientException {
        this.verifyResponse();
        ItemSequenceResponse response = (ItemSequenceResponse)this.readAndBind(TypeFactory.parametricType(ItemSequenceResponse.class, (Class[])new Class[]{itemClass}));
        if (anchor != null) {
            anchor.setAnchor(response.getAnchor());
        }
        return response.getEntry();
    }

    public Integer asCount() throws NingClientException {
        this.verifyResponse();
        ItemCountResponse response = (ItemCountResponse)this.readAndBind(TypeFactory.type(ItemCountResponse.class));
        return response.getCount();
    }

    protected abstract <T> T readAndBind(JavaType var1);

    public void verifyResponse() throws NingClientException {
        int code = this.getStatusCode();
        if (code >= 200 && code < 300) {
            return;
        }
        String responseMessage = this.getTruncatedResponse();
        throw new NingHttpException(code, responseMessage);
    }
}

