/*
 * Decompiled with CFR 0.152.
 */
package com.ning.api.client.access;

import com.ning.api.client.NingClientConfig;
import com.ning.api.client.access.Activities;
import com.ning.api.client.access.BlogPosts;
import com.ning.api.client.access.BroadcastMessages;
import com.ning.api.client.access.Comments;
import com.ning.api.client.access.Networks;
import com.ning.api.client.access.Photos;
import com.ning.api.client.access.Users;
import com.ning.api.client.access.Videos;
import com.ning.api.client.auth.ConsumerKey;
import com.ning.api.client.auth.OAuthSignatureCalculator;
import com.ning.api.client.auth.RequestToken;
import com.ning.api.client.http.NingHttpClient;
import com.ning.api.client.http.NingHttpDelete;
import com.ning.api.client.http.NingHttpGet;
import com.ning.api.client.http.NingHttpPost;
import com.ning.api.client.http.NingHttpPut;
import org.codehaus.jackson.map.ObjectMapper;

public class NingConnection {
    protected final NingHttpClient httpClient;
    protected final OAuthSignatureCalculator signatureCalculator;
    protected final String xapiPrefixRegular;
    protected final String xapiPrefixSecure;
    protected NingClientConfig config;

    public NingConnection(NingClientConfig config, ObjectMapper objectMapper, ConsumerKey consumerAuth, RequestToken userAuth, NingHttpClient httpClient, String xapiPrefixRegular, String xapiPrefixSecure) {
        this.httpClient = httpClient;
        this.signatureCalculator = new OAuthSignatureCalculator(consumerAuth, userAuth);
        this.xapiPrefixRegular = xapiPrefixRegular;
        this.xapiPrefixSecure = xapiPrefixSecure;
        this.config = config;
    }

    public NingClientConfig getConfig() {
        return this.config;
    }

    public void overrideConfig(NingClientConfig configOverrides) {
        this.config = this.config.overrideWith(configOverrides);
    }

    public Activities activities() {
        return new Activities(this, this.config);
    }

    public BlogPosts blogPosts() {
        return new BlogPosts(this, this.config);
    }

    public BroadcastMessages broadcastMessages() {
        return new BroadcastMessages(this, this.config);
    }

    public Comments comments() {
        return new Comments(this, this.config);
    }

    public Networks networks() {
        return new Networks(this, this.config);
    }

    public Photos photos() {
        return new Photos(this, this.config);
    }

    public Users users() {
        return new Users(this, this.config);
    }

    public Videos videos() {
        return new Videos(this, this.config);
    }

    public NingHttpDelete prepareHttpDelete(String endpoint) {
        String url = this.regularPrefixFor(endpoint);
        return this.httpClient.prepareDelete(url, this.signatureCalculator);
    }

    public NingHttpGet prepareHttpGet(String endpoint) {
        String url = this.regularPrefixFor(endpoint);
        return this.httpClient.prepareGet(url, this.signatureCalculator);
    }

    public NingHttpPost prepareHttpPost(String endpoint) {
        String url = this.regularPrefixFor(endpoint);
        return this.httpClient.preparePost(url, this.signatureCalculator);
    }

    public NingHttpPut prepareHttpPut(String endpoint) {
        String url = this.regularPrefixFor(endpoint);
        return this.httpClient.preparePut(url, this.signatureCalculator);
    }

    protected String regularPrefixFor(String endpoint) {
        return this.xapiPrefixRegular + endpoint;
    }

    protected String securePrefixFor(String endpoint) {
        return this.xapiPrefixSecure + endpoint;
    }
}

