/*
 * Decompiled with CFR 0.152.
 */
package com.ning.api.client.item;

import com.ning.api.client.item.Author;
import com.ning.api.client.item.ContentItem;
import com.ning.api.client.item.Image;
import com.ning.api.client.item.Key;
import com.ning.api.client.item.SubResources;
import org.codehaus.jackson.annotate.JsonProperty;
import org.joda.time.DateTime;

public class ContentItemBase<F extends Enum<F>, T extends ContentItem<F, T>>
implements ContentItem<F, T> {
    @JsonProperty
    protected Key<T> id;
    @JsonProperty
    protected DateTime createdDate;
    @JsonProperty
    protected String author;
    protected transient SubResources subResources;

    protected ContentItemBase() {
    }

    @Override
    public void injectSubResources(SubResources sr) {
        this.subResources = sr;
    }

    @Override
    @JsonProperty(value="id")
    public final Key<T> id() {
        return this.id;
    }

    @Override
    public DateTime getCreatedDate() {
        return this.createdDate;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    public String toString() {
        return "[Content type item of type " + this.getClass().getSimpleName() + "; id " + this.id + "]";
    }

    public Author getAuthorResource() {
        return this.stdGetAuthorResource(this.author);
    }

    protected Author stdGetAuthorResource(String authorId) {
        Author result = new Author(authorId);
        return this.subResources.findOrLoadResource(Author.class, authorId, result);
    }

    protected Image stdGetImageResource(String imageId) {
        return this.subResources.findOrLoadResource(Image.class, imageId);
    }
}

