/*
 * Decompiled with CFR 0.152.
 */
package com.nitayjoffe.util.iterators;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Queue;

public class IteratorUtils {
    public static <E> Iterator<E> interleave(Iterator<E> ... iterators) {
        return IteratorUtils.interleave(Arrays.asList(iterators));
    }

    public static <E> Iterator<E> interleave(final Iterable<Iterator<E>> iterators) {
        return new AbstractIterator<E>(){
            private Queue<Iterator<E>> queue;
            {
                this.queue = Lists.newLinkedList((Iterable)iterators);
            }

            protected E computeNext() {
                while (!this.queue.isEmpty()) {
                    Iterator topIter = this.queue.poll();
                    if (!topIter.hasNext()) continue;
                    Object result = topIter.next();
                    this.queue.offer(topIter);
                    return result;
                }
                return this.endOfData();
            }
        };
    }
}

