/*
 * Decompiled with CFR 0.152.
 */
package com.nitayjoffe.util.metrics;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricPredicate;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.reporting.ConsoleReporter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class MetricsUtil {
    protected MetricsUtil() {
    }

    public static void dumpToStdout() {
        MetricsUtil.dumpToStdout(Metrics.defaultRegistry());
    }

    public static void dumpToStdout(MetricsRegistry metrics) {
        MetricsUtil.dumpToStream(Metrics.defaultRegistry(), System.out);
    }

    public static void dumpToStderr() {
        MetricsUtil.dumpToStderr(Metrics.defaultRegistry());
    }

    public static void dumpToStderr(MetricsRegistry metrics) {
        MetricsUtil.dumpToStream(metrics, System.err);
    }

    public static void dumpToStream(MetricsRegistry metrics, PrintStream out) {
        MetricsUtil.consoleReporter(metrics, out).run();
    }

    public static ConsoleReporter consoleReporter() {
        return MetricsUtil.consoleReporter(Metrics.defaultRegistry(), System.err);
    }

    public static ConsoleReporter consoleReporter(PrintStream out) {
        return MetricsUtil.consoleReporter(Metrics.defaultRegistry(), out);
    }

    public static ConsoleReporter consoleReporter(MetricsRegistry metrics, PrintStream out) {
        return new ConsoleReporter(metrics, out, MetricPredicate.ALL);
    }

    public static void dumpToFile(String path) throws FileNotFoundException {
        MetricsUtil.dumpToFile(Metrics.defaultRegistry(), path);
    }

    public static void dumpToFile(MetricsRegistry metrics, String path) throws FileNotFoundException {
        MetricsUtil.dumpToStream(metrics, new PrintStream(new FileOutputStream(path)));
    }
}

