/*
 * Decompiled with CFR 0.152.
 */
package com.nitayjoffe.util.ranges;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import com.google.common.collect.UnmodifiableIterator;
import com.nitayjoffe.util.ranges.Int2D;
import java.util.Iterator;
import java.util.Set;

public class Range2D
implements Iterable<Int2D> {
    private final Set<Integer> set1;
    private final Set<Integer> set2;

    private Range2D(Range<Integer> range1, Range<Integer> range2) {
        this.set1 = ContiguousSet.create(range1, (DiscreteDomain)DiscreteDomain.integers());
        this.set2 = ContiguousSet.create(range2, (DiscreteDomain)DiscreteDomain.integers());
    }

    public static Range2D range2D(Range<Integer> range1, Range<Integer> range2) {
        return new Range2D(range1, range2);
    }

    @Override
    public Iterator<Int2D> iterator() {
        return new ComboIter(this.set1, this.set2);
    }

    private class ComboIter
    extends UnmodifiableIterator<Int2D> {
        private final Iterator<Integer> iter1;
        private final Set<Integer> set2;
        private Iterator<Integer> iter2;
        private Int2D value;

        public ComboIter(Set<Integer> set1, Set<Integer> set2) {
            this.iter1 = set1.iterator();
            this.set2 = set2;
            this.iter2 = set2.iterator();
        }

        public boolean hasNext() {
            return this.iter2.hasNext() || this.iter1.hasNext();
        }

        public Int2D next() {
            if (this.value == null) {
                this.value = new Int2D();
                this.value.a = this.iter1.next();
            }
            if (!this.iter2.hasNext()) {
                this.value.a = this.iter1.next();
                this.iter2 = this.set2.iterator();
            }
            this.value.b = this.iter2.next();
            return this.value;
        }
    }
}

