/*
 * Decompiled with CFR 0.152.
 */
package com.nitayjoffe.util.ranges;

import com.google.common.collect.DiscreteDomains;
import com.google.common.collect.Range;
import com.google.common.collect.UnmodifiableIterator;
import com.nitayjoffe.util.ranges.Int3D;
import java.util.Iterator;
import java.util.Set;

public class Range3D
implements Iterable<Int3D> {
    private final Set<Integer> set1;
    private final Set<Integer> set2;
    private final Set<Integer> set3;

    private Range3D(Range<Integer> range1, Range<Integer> range2, Range<Integer> range3) {
        this.set1 = range1.asSet(DiscreteDomains.integers());
        this.set2 = range2.asSet(DiscreteDomains.integers());
        this.set3 = range3.asSet(DiscreteDomains.integers());
    }

    public static Range3D range3D(Range<Integer> range1, Range<Integer> range2, Range<Integer> range3) {
        return new Range3D(range1, range2, range3);
    }

    @Override
    public Iterator<Int3D> iterator() {
        return new ComboIter(this.set1, this.set2, this.set3);
    }

    private class ComboIter
    extends UnmodifiableIterator<Int3D> {
        private final Iterator<Integer> iter1;
        private final Set<Integer> set2;
        private Iterator<Integer> iter2;
        private final Set<Integer> set3;
        private Iterator<Integer> iter3;
        private Int3D value;

        public ComboIter(Set<Integer> set1, Set<Integer> set2, Set<Integer> set3) {
            this.iter1 = set1.iterator();
            this.set2 = set2;
            this.iter2 = set2.iterator();
            this.set3 = set3;
            this.iter3 = set3.iterator();
        }

        public boolean hasNext() {
            return this.iter3.hasNext() || this.iter2.hasNext() || this.iter1.hasNext();
        }

        public Int3D next() {
            if (this.value == null) {
                this.value = new Int3D();
                this.value.a = this.iter1.next();
                this.value.b = this.iter2.next();
            }
            if (!this.iter3.hasNext()) {
                if (!this.iter2.hasNext()) {
                    this.iter2 = this.set2.iterator();
                    this.value.a = this.iter1.next();
                }
                this.iter3 = this.set3.iterator();
                this.value.b = this.iter2.next();
            }
            this.value.c = this.iter3.next();
            return this.value;
        }
    }
}

