/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dat.java.client.api;

import com.nutanix.dat.java.client.ApiClient;
import com.nutanix.dp1.dat.common.v1.config.Flag;
import com.nutanix.dp1.dat.common.v1.response.ApiResponseMetadata;
import com.nutanix.dp1.dat.dataprotection.v4.config.ClusterInfoApiResponse;
import com.nutanix.dp1.dat.dataprotection.v4.config.CreateRecoveryPointApiResponse;
import com.nutanix.dp1.dat.dataprotection.v4.config.DeleteRecoveryPointApiResponse;
import com.nutanix.dp1.dat.dataprotection.v4.config.ExpirationTimeSpec;
import com.nutanix.dp1.dat.dataprotection.v4.config.GetRecoveryPointApiResponse;
import com.nutanix.dp1.dat.dataprotection.v4.config.GetVmRecoveryPointApiResponse;
import com.nutanix.dp1.dat.dataprotection.v4.config.ListRecoveryPointsApiResponse;
import com.nutanix.dp1.dat.dataprotection.v4.config.RecoveryPoint;
import com.nutanix.dp1.dat.dataprotection.v4.config.RecoveryPointReplicateApiResponse;
import com.nutanix.dp1.dat.dataprotection.v4.config.RecoveryPointReplicationSpec;
import com.nutanix.dp1.dat.dataprotection.v4.config.RecoveryPointRestorationSpec;
import com.nutanix.dp1.dat.dataprotection.v4.config.RecoveryPointRestoreApiResponse;
import com.nutanix.dp1.dat.dataprotection.v4.config.UpdateRecoveryPointExpirationTimeApiResponse;
import com.nutanix.dp1.dat.dataprotection.v4.content.ChangedVmRegionsApiResponse;
import com.nutanix.dp1.dat.dataprotection.v4.content.ChangedVolumeGroupRegionsApiResponse;
import com.nutanix.dp1.dat.dataprotection.v4.content.ClusterDiscoverSpec;
import com.nutanix.dp1.dat.dataprotection.v4.content.GetVssMetadataApiResponse;
import com.nutanix.dp1.dat.dataprotection.v4.content.VmRecoveryPointChangedRegionsComputeSpec;
import com.nutanix.dp1.dat.dataprotection.v4.content.VolumeGroupRecoveryPointChangedRegionsComputeSpec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.util.UriComponentsBuilder;

@Component(value="com.nutanix.dat.java.client.api.RecoveryPointsApi")
public class RecoveryPointsApi {
    private static final Logger log = LoggerFactory.getLogger(RecoveryPointsApi.class);
    private ApiClient apiClient;
    private final Set<String> headersToSkip;

    public RecoveryPointsApi() {
        this(new ApiClient());
    }

    @Autowired
    public RecoveryPointsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.headersToSkip = new HashSet<String>(Arrays.asList("authorization", "cookie", "host", "user-agent"));
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CreateRecoveryPointApiResponse createRecoveryPoint(RecoveryPoint body, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        RecoveryPoint postBody = body;
        if (body == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling createRecoveryPoint");
        }
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/dataprotection/v4.0/config/recovery-points").build().toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<CreateRecoveryPointApiResponse> returnType = new ParameterizedTypeReference<CreateRecoveryPointApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public DeleteRecoveryPointApiResponse deleteRecoveryPointById(String extId, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        Object postBody = null;
        if (extId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extId' when calling deleteRecoveryPointById");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("extId", extId);
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/dataprotection/v4.0/config/recovery-points/{extId}").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<DeleteRecoveryPointApiResponse> returnType = new ParameterizedTypeReference<DeleteRecoveryPointApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.DELETE, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public ClusterInfoApiResponse discoverClusterForRecoveryPointId(String extId, ClusterDiscoverSpec body, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        ClusterDiscoverSpec postBody = body;
        if (extId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extId' when calling discoverClusterForRecoveryPointId");
        }
        if (body == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling discoverClusterForRecoveryPointId");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("extId", extId);
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/dataprotection/v4.0/config/recovery-points/{extId}/$actions/discover-cluster").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<ClusterInfoApiResponse> returnType = new ParameterizedTypeReference<ClusterInfoApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public GetRecoveryPointApiResponse getRecoveryPointById(String extId, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        Object postBody = null;
        if (extId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extId' when calling getRecoveryPointById");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("extId", extId);
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/dataprotection/v4.0/config/recovery-points/{extId}").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<GetRecoveryPointApiResponse> returnType = new ParameterizedTypeReference<GetRecoveryPointApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.GET, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public GetVmRecoveryPointApiResponse getVmRecoveryPointById(String recoveryPointExtId, String extId, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        Object postBody = null;
        if (recoveryPointExtId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'recoveryPointExtId' when calling getVmRecoveryPointById");
        }
        if (extId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extId' when calling getVmRecoveryPointById");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("recoveryPointExtId", recoveryPointExtId);
        uriVariables.put("extId", extId);
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/dataprotection/v4.0/config/recovery-points/{recoveryPointExtId}/vm-recovery-points/{extId}").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<GetVmRecoveryPointApiResponse> returnType = new ParameterizedTypeReference<GetVmRecoveryPointApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.GET, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public GetVssMetadataApiResponse getVssMetadataByVmRecoveryPointId(String recoveryPointExtId, String vmRecoveryPointExtId, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        Object postBody = null;
        if (recoveryPointExtId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'recoveryPointExtId' when calling getVssMetadataByVmRecoveryPointId");
        }
        if (vmRecoveryPointExtId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'vmRecoveryPointExtId' when calling getVssMetadataByVmRecoveryPointId");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("recoveryPointExtId", recoveryPointExtId);
        uriVariables.put("vmRecoveryPointExtId", vmRecoveryPointExtId);
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/dataprotection/v4.0/content/recovery-points/{recoveryPointExtId}/vm-recovery-points/{vmRecoveryPointExtId}/vss-metadata").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/octet-stream", "application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<ApiClient.OneOfBinaryResponseWrapper> returnType = new ParameterizedTypeReference<ApiClient.OneOfBinaryResponseWrapper>(){};
        ApiClient.OneOfBinaryResponseWrapper responseWrapper = this.apiClient.invokeAPI(uriPath, HttpMethod.GET, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
        try {
            if (responseWrapper.isBinary()) {
                Map<String, Object> pathObject = this.apiClient.getFileDownloadResponse(responseWrapper.getResourceObject(), responseWrapper.getResponseEntity().getHeaders());
                return GetVssMetadataApiResponse.GetVssMetadataApiResponseBuilder().data(pathObject).metadata(ApiResponseMetadata.ApiResponseMetadataBuilder().flags(Arrays.asList(new Flag("hasError", false))).build()).build();
            }
            GetVssMetadataApiResponse apiResponse = (GetVssMetadataApiResponse)ApiClient.OBJECT_MAPPER.readValue(responseWrapper.getJsonObject(), GetVssMetadataApiResponse.class);
            ResponseEntity responseEntity = new ResponseEntity((Object)apiResponse, (MultiValueMap)responseWrapper.getResponseEntity().getHeaders(), responseWrapper.getResponseEntity().getStatusCode().value());
            ParameterizedTypeReference<GetVssMetadataApiResponse> dtoTypeReference = new ParameterizedTypeReference<GetVssMetadataApiResponse>(){};
            return this.apiClient.getResponseBody(responseEntity, dtoTypeReference);
        }
        catch (Exception ex) {
            String message = "Unable to process wrapper response";
            log.error(message, (Throwable)ex);
            throw new RestClientException(String.format("%s: %s", message, ex.getMessage()));
        }
    }

    public ListRecoveryPointsApiResponse listRecoveryPoints(String xClusterId, Integer $page, Integer $limit, String $filter, String $orderby, String $select, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        Object postBody = null;
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/dataprotection/v4.0/config/recovery-points").build().toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$page", $page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$limit", $limit));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$filter", $filter));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$orderby", $orderby));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$select", $select));
        if (xClusterId != null) {
            headerParams.add("X-Cluster-Id", this.apiClient.parameterToString(xClusterId));
        }
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<ListRecoveryPointsApiResponse> returnType = new ParameterizedTypeReference<ListRecoveryPointsApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.GET, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public RecoveryPointReplicateApiResponse replicateRecoveryPoint(String extId, RecoveryPointReplicationSpec body, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        RecoveryPointReplicationSpec postBody = body;
        if (extId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extId' when calling replicateRecoveryPoint");
        }
        if (body == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling replicateRecoveryPoint");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("extId", extId);
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/dataprotection/v4.0/config/recovery-points/{extId}/$actions/replicate").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<RecoveryPointReplicateApiResponse> returnType = new ParameterizedTypeReference<RecoveryPointReplicateApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public RecoveryPointRestoreApiResponse restoreRecoveryPoint(String extId, RecoveryPointRestorationSpec body, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        RecoveryPointRestorationSpec postBody = body;
        if (extId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extId' when calling restoreRecoveryPoint");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("extId", extId);
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/dataprotection/v4.0/config/recovery-points/{extId}/$actions/restore").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<RecoveryPointRestoreApiResponse> returnType = new ParameterizedTypeReference<RecoveryPointRestoreApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public UpdateRecoveryPointExpirationTimeApiResponse setRecoveryPointExpirationTime(String extId, ExpirationTimeSpec body, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        ExpirationTimeSpec postBody = body;
        if (extId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extId' when calling setRecoveryPointExpirationTime");
        }
        if (body == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling setRecoveryPointExpirationTime");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("extId", extId);
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/dataprotection/v4.0/config/recovery-points/{extId}/$actions/set-expiration-time").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<UpdateRecoveryPointExpirationTimeApiResponse> returnType = new ParameterizedTypeReference<UpdateRecoveryPointExpirationTimeApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public ChangedVmRegionsApiResponse vmRecoveryPointComputeChangedRegions(String recoveryPointExtId, String vmRecoveryPointExtId, String extId, VmRecoveryPointChangedRegionsComputeSpec body, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        VmRecoveryPointChangedRegionsComputeSpec postBody = body;
        if (recoveryPointExtId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'recoveryPointExtId' when calling vmRecoveryPointComputeChangedRegions");
        }
        if (vmRecoveryPointExtId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'vmRecoveryPointExtId' when calling vmRecoveryPointComputeChangedRegions");
        }
        if (extId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extId' when calling vmRecoveryPointComputeChangedRegions");
        }
        if (body == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling vmRecoveryPointComputeChangedRegions");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("recoveryPointExtId", recoveryPointExtId);
        uriVariables.put("vmRecoveryPointExtId", vmRecoveryPointExtId);
        uriVariables.put("extId", extId);
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/dataprotection/v4.0/content/recovery-points/{recoveryPointExtId}/vm-recovery-points/{vmRecoveryPointExtId}/disk-recovery-points/{extId}/$actions/compute-changed-regions").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<ChangedVmRegionsApiResponse> returnType = new ParameterizedTypeReference<ChangedVmRegionsApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public ChangedVolumeGroupRegionsApiResponse volumeGroupRecoveryPointComputeChangedRegions(String recoveryPointExtId, String volumeGroupRecoveryPointExtId, String extId, VolumeGroupRecoveryPointChangedRegionsComputeSpec body, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        VolumeGroupRecoveryPointChangedRegionsComputeSpec postBody = body;
        if (recoveryPointExtId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'recoveryPointExtId' when calling volumeGroupRecoveryPointComputeChangedRegions");
        }
        if (volumeGroupRecoveryPointExtId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'volumeGroupRecoveryPointExtId' when calling volumeGroupRecoveryPointComputeChangedRegions");
        }
        if (extId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extId' when calling volumeGroupRecoveryPointComputeChangedRegions");
        }
        if (body == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling volumeGroupRecoveryPointComputeChangedRegions");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("recoveryPointExtId", recoveryPointExtId);
        uriVariables.put("volumeGroupRecoveryPointExtId", volumeGroupRecoveryPointExtId);
        uriVariables.put("extId", extId);
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/dataprotection/v4.0/content/recovery-points/{recoveryPointExtId}/volume-group-recovery-points/{volumeGroupRecoveryPointExtId}/disk-recovery-points/{extId}/$actions/compute-changed-regions").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<ChangedVolumeGroupRegionsApiResponse> returnType = new ParameterizedTypeReference<ChangedVolumeGroupRegionsApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }
}

