/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.dat.common.v1.config;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.nutanix.devplatform.models.PrettyModeViews;
import com.nutanix.dp1.dat.deserializers.DatObjectTypeTypedObject;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPv4Address
implements Serializable,
DatObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(IPv4Address.class);
    @Pattern(regexp="^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$")
    @JsonProperty(value="value")
    public @Pattern(regexp="^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$") String value = null;
    @Max(value=32L)
    @Min(value=0L)
    @JsonProperty(value="prefixLength")
    public @Max(value=32L) @Min(value=0L) Integer prefixLength = 32;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $reserved;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final String $objectType = this.initialize$objectType();
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $unknownFields;

    public IPv4Address() {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
    }

    public IPv4Address(String value, Integer prefixLength) {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
        this.setValue(value);
        this.setPrefixLength(prefixLength);
    }

    protected String initialize$objectType() {
        return "common.v1.config.IPv4Address";
    }

    protected String initialize$fv() {
        return "v1.r0";
    }

    @JsonAnySetter
    private void setUndeserializedFields(String name, Object value) {
        this.$unknownFields.put(name, value);
    }

    public static IPv4AddressBuilder IPv4AddressBuilder() {
        return new IPv4AddressBuilder();
    }

    public String getValue() {
        return this.value;
    }

    public Integer getPrefixLength() {
        return this.prefixLength;
    }

    @JsonProperty(value="value")
    public void setValue(String value) {
        this.value = value;
    }

    @JsonProperty(value="prefixLength")
    public void setPrefixLength(Integer prefixLength) {
        this.prefixLength = prefixLength;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IPv4Address)) {
            return false;
        }
        IPv4Address other = (IPv4Address)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        Integer this$prefixLength = this.getPrefixLength();
        Integer other$prefixLength = other.getPrefixLength();
        return !(this$prefixLength == null ? other$prefixLength != null : !((Object)this$prefixLength).equals(other$prefixLength));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IPv4Address;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        Integer $prefixLength = this.getPrefixLength();
        result = result * 59 + ($prefixLength == null ? 43 : ((Object)$prefixLength).hashCode());
        return result;
    }

    public String toString() {
        return "IPv4Address(value=" + this.getValue() + ", prefixLength=" + this.getPrefixLength() + ")";
    }

    @Override
    public Map<String, Object> get$reserved() {
        return this.$reserved;
    }

    @Override
    public String get$objectType() {
        return this.$objectType;
    }

    public Map<String, Object> get$unknownFields() {
        return this.$unknownFields;
    }

    public static class IPv4AddressBuilder {
        private String value;
        private Integer prefixLength;

        IPv4AddressBuilder() {
        }

        public IPv4AddressBuilder value(String value) {
            this.value = value;
            return this;
        }

        public IPv4AddressBuilder prefixLength(Integer prefixLength) {
            this.prefixLength = prefixLength;
            return this;
        }

        public IPv4Address build() {
            return new IPv4Address(this.value, this.prefixLength);
        }

        public String toString() {
            return "IPv4Address.IPv4AddressBuilder(value=" + this.value + ", prefixLength=" + this.prefixLength + ")";
        }
    }
}

