/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.dat.dataprotection.v4.common;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.dat.common.v1.response.ApiLink;
import com.nutanix.dp1.dat.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.dat.dataprotection.v4.common.RecoveryPointStatus;
import com.nutanix.dp1.dat.dataprotection.v4.common.RecoveryPointType;
import com.nutanix.dp1.dat.deserializers.DatObjectTypeTypedObject;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseRecoveryPoint
extends ExternalizableAbstractModel
implements Serializable,
DatObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(BaseRecoveryPoint.class);
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    private @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String locationAgnosticId = null;
    private OffsetDateTime creationTime = null;
    @Size(max=256)
    @JsonProperty(value="name")
    public @Size(max=256) String name = null;
    @JsonProperty(value="expirationTime")
    public OffsetDateTime expirationTime = null;
    @JsonProperty(value="status")
    public RecoveryPointStatus status = null;
    @JsonProperty(value="recoveryPointType")
    public RecoveryPointType recoveryPointType = null;

    public BaseRecoveryPoint() {
    }

    public BaseRecoveryPoint(String tenantId, String extId, List<ApiLink> links, String locationAgnosticId, String name, OffsetDateTime creationTime, OffsetDateTime expirationTime, RecoveryPointStatus status, RecoveryPointType recoveryPointType) {
        super(tenantId, extId, links);
        this.setLocationAgnosticId(locationAgnosticId);
        this.setName(name);
        this.setCreationTime(creationTime);
        this.setExpirationTime(expirationTime);
        this.setStatus(status);
        this.setRecoveryPointType(recoveryPointType);
    }

    @Override
    protected String initialize$objectType() {
        return "dataprotection.v4.common.BaseRecoveryPoint";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setLocationAgnosticId(String locationAgnosticId) {
        if (this.locationAgnosticId == null) {
            this.locationAgnosticId = locationAgnosticId;
        } else {
            log.warn("Read-only property locationAgnosticId already contains a non-null value and cannot be set again");
        }
    }

    public void setCreationTime(OffsetDateTime creationTime) {
        if (this.creationTime == null) {
            this.creationTime = creationTime;
        } else {
            log.warn("Read-only property creationTime already contains a non-null value and cannot be set again");
        }
    }

    public static BaseRecoveryPointBuilder BaseRecoveryPointBuilder() {
        return new BaseRecoveryPointBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseRecoveryPoint)) {
            return false;
        }
        BaseRecoveryPoint other = (BaseRecoveryPoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$locationAgnosticId = this.getLocationAgnosticId();
        String other$locationAgnosticId = other.getLocationAgnosticId();
        if (this$locationAgnosticId == null ? other$locationAgnosticId != null : !this$locationAgnosticId.equals(other$locationAgnosticId)) {
            return false;
        }
        OffsetDateTime this$creationTime = this.getCreationTime();
        OffsetDateTime other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        OffsetDateTime this$expirationTime = this.getExpirationTime();
        OffsetDateTime other$expirationTime = other.getExpirationTime();
        if (this$expirationTime == null ? other$expirationTime != null : !((Object)this$expirationTime).equals(other$expirationTime)) {
            return false;
        }
        RecoveryPointStatus this$status = this.getStatus();
        RecoveryPointStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        RecoveryPointType this$recoveryPointType = this.getRecoveryPointType();
        RecoveryPointType other$recoveryPointType = other.getRecoveryPointType();
        return !(this$recoveryPointType == null ? other$recoveryPointType != null : !((Object)((Object)this$recoveryPointType)).equals((Object)other$recoveryPointType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BaseRecoveryPoint;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $locationAgnosticId = this.getLocationAgnosticId();
        result = result * 59 + ($locationAgnosticId == null ? 43 : $locationAgnosticId.hashCode());
        OffsetDateTime $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        OffsetDateTime $expirationTime = this.getExpirationTime();
        result = result * 59 + ($expirationTime == null ? 43 : ((Object)$expirationTime).hashCode());
        RecoveryPointStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        RecoveryPointType $recoveryPointType = this.getRecoveryPointType();
        result = result * 59 + ($recoveryPointType == null ? 43 : ((Object)((Object)$recoveryPointType)).hashCode());
        return result;
    }

    public String getLocationAgnosticId() {
        return this.locationAgnosticId;
    }

    public OffsetDateTime getCreationTime() {
        return this.creationTime;
    }

    public String getName() {
        return this.name;
    }

    public OffsetDateTime getExpirationTime() {
        return this.expirationTime;
    }

    public RecoveryPointStatus getStatus() {
        return this.status;
    }

    public RecoveryPointType getRecoveryPointType() {
        return this.recoveryPointType;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="expirationTime")
    public void setExpirationTime(OffsetDateTime expirationTime) {
        this.expirationTime = expirationTime;
    }

    @JsonProperty(value="status")
    public void setStatus(RecoveryPointStatus status) {
        this.status = status;
    }

    @JsonProperty(value="recoveryPointType")
    public void setRecoveryPointType(RecoveryPointType recoveryPointType) {
        this.recoveryPointType = recoveryPointType;
    }

    @Override
    public String toString() {
        return "BaseRecoveryPoint(locationAgnosticId=" + this.getLocationAgnosticId() + ", creationTime=" + this.getCreationTime() + ", name=" + this.getName() + ", expirationTime=" + this.getExpirationTime() + ", status=" + (Object)((Object)this.getStatus()) + ", recoveryPointType=" + (Object)((Object)this.getRecoveryPointType()) + ")";
    }

    public static class BaseRecoveryPointBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String locationAgnosticId;
        private String name;
        private OffsetDateTime creationTime;
        private OffsetDateTime expirationTime;
        private RecoveryPointStatus status;
        private RecoveryPointType recoveryPointType;

        BaseRecoveryPointBuilder() {
        }

        public BaseRecoveryPointBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public BaseRecoveryPointBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public BaseRecoveryPointBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public BaseRecoveryPointBuilder locationAgnosticId(String locationAgnosticId) {
            this.locationAgnosticId = locationAgnosticId;
            return this;
        }

        public BaseRecoveryPointBuilder name(String name) {
            this.name = name;
            return this;
        }

        public BaseRecoveryPointBuilder creationTime(OffsetDateTime creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public BaseRecoveryPointBuilder expirationTime(OffsetDateTime expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public BaseRecoveryPointBuilder status(RecoveryPointStatus status) {
            this.status = status;
            return this;
        }

        public BaseRecoveryPointBuilder recoveryPointType(RecoveryPointType recoveryPointType) {
            this.recoveryPointType = recoveryPointType;
            return this;
        }

        public BaseRecoveryPoint build() {
            return new BaseRecoveryPoint(this.tenantId, this.extId, this.links, this.locationAgnosticId, this.name, this.creationTime, this.expirationTime, this.status, this.recoveryPointType);
        }

        public String toString() {
            return "BaseRecoveryPoint.BaseRecoveryPointBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", locationAgnosticId=" + this.locationAgnosticId + ", name=" + this.name + ", creationTime=" + this.creationTime + ", expirationTime=" + this.expirationTime + ", status=" + (Object)((Object)this.status) + ", recoveryPointType=" + (Object)((Object)this.recoveryPointType) + ")";
        }
    }
}

