/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.dat.dataprotection.v4.common;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.nutanix.dp1.dat.annotations.DatJsonDeserializer;
import com.nutanix.dp1.dat.common.v1.response.ApiLink;
import com.nutanix.dp1.dat.dataprotection.v4.common.BaseRecoveryPoint;
import com.nutanix.dp1.dat.dataprotection.v4.common.DiskRecoveryPoint;
import com.nutanix.dp1.dat.dataprotection.v4.common.RecoveryPointStatus;
import com.nutanix.dp1.dat.dataprotection.v4.common.RecoveryPointType;
import com.nutanix.dp1.dat.dataprotection.v4.common.VssProperties;
import com.nutanix.dp1.dat.deserializers.DatObjectTypeTypedObject;
import com.nutanix.dp1.dat.deserializers.DatOneOfDeserializer;
import com.nutanix.dp1.dat.serializers.DatOneOfSerializer;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseVmRecoveryPoint
extends BaseRecoveryPoint
implements Serializable,
DatObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(BaseVmRecoveryPoint.class);
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    private @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String consistencyGroupExtId = null;
    @Size(min=1, max=1024)
    private @Size(min=1, max=1024) List<DiskRecoveryPoint> diskRecoveryPoints = null;
    @Size(min=1, max=256)
    private @Size(min=1, max=256) List<String> vmCategories = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="vmExtId")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String vmExtId = null;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String $applicationConsistentPropertiesItemDiscriminator = null;
    private OneOfApplicationConsistentPropertiesWrapper applicationConsistentProperties = null;

    public BaseVmRecoveryPoint() {
    }

    public BaseVmRecoveryPoint(String tenantId, String extId, List<ApiLink> links, String locationAgnosticId, String name, OffsetDateTime creationTime, OffsetDateTime expirationTime, RecoveryPointStatus status, RecoveryPointType recoveryPointType, String consistencyGroupExtId, List<DiskRecoveryPoint> diskRecoveryPoints, String vmExtId, List<String> vmCategories, Object applicationConsistentProperties) {
        super(tenantId, extId, links, locationAgnosticId, name, creationTime, expirationTime, status, recoveryPointType);
        this.setConsistencyGroupExtId(consistencyGroupExtId);
        this.setDiskRecoveryPoints(diskRecoveryPoints);
        this.setVmExtId(vmExtId);
        this.setVmCategories(vmCategories);
        this.setApplicationConsistentPropertiesInWrapper(applicationConsistentProperties);
    }

    @Override
    protected String initialize$objectType() {
        return "dataprotection.v4.common.BaseVmRecoveryPoint";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setConsistencyGroupExtId(String consistencyGroupExtId) {
        if (this.consistencyGroupExtId == null) {
            this.consistencyGroupExtId = consistencyGroupExtId;
        } else {
            log.warn("Read-only property consistencyGroupExtId already contains a non-null value and cannot be set again");
        }
    }

    public void setDiskRecoveryPoints(List<DiskRecoveryPoint> diskRecoveryPoints) {
        if (this.diskRecoveryPoints == null) {
            this.diskRecoveryPoints = diskRecoveryPoints;
        } else {
            log.warn("Read-only property diskRecoveryPoints already contains a non-null value and cannot be set again");
        }
    }

    public void setVmCategories(List<String> vmCategories) {
        if (this.vmCategories == null) {
            this.vmCategories = vmCategories;
        } else {
            log.warn("Read-only property vmCategories already contains a non-null value and cannot be set again");
        }
    }

    public String get$applicationConsistentPropertiesItemDiscriminator() {
        if (this.applicationConsistentProperties != null && this.$applicationConsistentPropertiesItemDiscriminator == null) {
            this.$applicationConsistentPropertiesItemDiscriminator = this.applicationConsistentProperties.getDiscriminator();
        }
        return this.$applicationConsistentPropertiesItemDiscriminator;
    }

    @JsonIgnore
    public void setApplicationConsistentPropertiesInWrapper(Object value) {
        if (value == null) {
            return;
        }
        if (this.applicationConsistentProperties == null) {
            this.applicationConsistentProperties = new OneOfApplicationConsistentPropertiesWrapper();
        }
        this.applicationConsistentProperties.setValue(value);
        this.$applicationConsistentPropertiesItemDiscriminator = this.applicationConsistentProperties.getDiscriminator();
    }

    @JsonSerialize(using=DatOneOfSerializer.class)
    public Object getApplicationConsistentProperties() {
        if (this.applicationConsistentProperties == null) {
            log.debug("OneOf property applicationConsistentProperties was never set. Returning null...");
            return null;
        }
        return this.applicationConsistentProperties.getValue();
    }

    public static BaseVmRecoveryPointBuilder BaseVmRecoveryPointBuilder() {
        return new BaseVmRecoveryPointBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseVmRecoveryPoint)) {
            return false;
        }
        BaseVmRecoveryPoint other = (BaseVmRecoveryPoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$consistencyGroupExtId = this.getConsistencyGroupExtId();
        String other$consistencyGroupExtId = other.getConsistencyGroupExtId();
        if (this$consistencyGroupExtId == null ? other$consistencyGroupExtId != null : !this$consistencyGroupExtId.equals(other$consistencyGroupExtId)) {
            return false;
        }
        List<DiskRecoveryPoint> this$diskRecoveryPoints = this.getDiskRecoveryPoints();
        List<DiskRecoveryPoint> other$diskRecoveryPoints = other.getDiskRecoveryPoints();
        if (this$diskRecoveryPoints == null ? other$diskRecoveryPoints != null : !((Object)this$diskRecoveryPoints).equals(other$diskRecoveryPoints)) {
            return false;
        }
        List<String> this$vmCategories = this.getVmCategories();
        List<String> other$vmCategories = other.getVmCategories();
        if (this$vmCategories == null ? other$vmCategories != null : !((Object)this$vmCategories).equals(other$vmCategories)) {
            return false;
        }
        String this$vmExtId = this.getVmExtId();
        String other$vmExtId = other.getVmExtId();
        if (this$vmExtId == null ? other$vmExtId != null : !this$vmExtId.equals(other$vmExtId)) {
            return false;
        }
        Object this$applicationConsistentProperties = this.getApplicationConsistentProperties();
        Object other$applicationConsistentProperties = other.getApplicationConsistentProperties();
        return !(this$applicationConsistentProperties == null ? other$applicationConsistentProperties != null : !this$applicationConsistentProperties.equals(other$applicationConsistentProperties));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BaseVmRecoveryPoint;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $consistencyGroupExtId = this.getConsistencyGroupExtId();
        result = result * 59 + ($consistencyGroupExtId == null ? 43 : $consistencyGroupExtId.hashCode());
        List<DiskRecoveryPoint> $diskRecoveryPoints = this.getDiskRecoveryPoints();
        result = result * 59 + ($diskRecoveryPoints == null ? 43 : ((Object)$diskRecoveryPoints).hashCode());
        List<String> $vmCategories = this.getVmCategories();
        result = result * 59 + ($vmCategories == null ? 43 : ((Object)$vmCategories).hashCode());
        String $vmExtId = this.getVmExtId();
        result = result * 59 + ($vmExtId == null ? 43 : $vmExtId.hashCode());
        Object $applicationConsistentProperties = this.getApplicationConsistentProperties();
        result = result * 59 + ($applicationConsistentProperties == null ? 43 : $applicationConsistentProperties.hashCode());
        return result;
    }

    public String getConsistencyGroupExtId() {
        return this.consistencyGroupExtId;
    }

    public List<DiskRecoveryPoint> getDiskRecoveryPoints() {
        return this.diskRecoveryPoints;
    }

    public List<String> getVmCategories() {
        return this.vmCategories;
    }

    public String getVmExtId() {
        return this.vmExtId;
    }

    @JsonProperty(value="vmExtId")
    public void setVmExtId(String vmExtId) {
        this.vmExtId = vmExtId;
    }

    public void setApplicationConsistentProperties(OneOfApplicationConsistentPropertiesWrapper applicationConsistentProperties) {
        this.applicationConsistentProperties = applicationConsistentProperties;
    }

    @Override
    public String toString() {
        return "BaseVmRecoveryPoint(consistencyGroupExtId=" + this.getConsistencyGroupExtId() + ", diskRecoveryPoints=" + this.getDiskRecoveryPoints() + ", vmCategories=" + this.getVmCategories() + ", vmExtId=" + this.getVmExtId() + ", applicationConsistentProperties=" + this.getApplicationConsistentProperties() + ")";
    }

    public static class BaseVmRecoveryPointBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String locationAgnosticId;
        private String name;
        private OffsetDateTime creationTime;
        private OffsetDateTime expirationTime;
        private RecoveryPointStatus status;
        private RecoveryPointType recoveryPointType;
        private String consistencyGroupExtId;
        private List<DiskRecoveryPoint> diskRecoveryPoints;
        private String vmExtId;
        private List<String> vmCategories;
        private Object applicationConsistentProperties;

        BaseVmRecoveryPointBuilder() {
        }

        public BaseVmRecoveryPointBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public BaseVmRecoveryPointBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public BaseVmRecoveryPointBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public BaseVmRecoveryPointBuilder locationAgnosticId(String locationAgnosticId) {
            this.locationAgnosticId = locationAgnosticId;
            return this;
        }

        public BaseVmRecoveryPointBuilder name(String name) {
            this.name = name;
            return this;
        }

        public BaseVmRecoveryPointBuilder creationTime(OffsetDateTime creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public BaseVmRecoveryPointBuilder expirationTime(OffsetDateTime expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public BaseVmRecoveryPointBuilder status(RecoveryPointStatus status) {
            this.status = status;
            return this;
        }

        public BaseVmRecoveryPointBuilder recoveryPointType(RecoveryPointType recoveryPointType) {
            this.recoveryPointType = recoveryPointType;
            return this;
        }

        public BaseVmRecoveryPointBuilder consistencyGroupExtId(String consistencyGroupExtId) {
            this.consistencyGroupExtId = consistencyGroupExtId;
            return this;
        }

        public BaseVmRecoveryPointBuilder diskRecoveryPoints(List<DiskRecoveryPoint> diskRecoveryPoints) {
            this.diskRecoveryPoints = diskRecoveryPoints;
            return this;
        }

        public BaseVmRecoveryPointBuilder vmExtId(String vmExtId) {
            this.vmExtId = vmExtId;
            return this;
        }

        public BaseVmRecoveryPointBuilder vmCategories(List<String> vmCategories) {
            this.vmCategories = vmCategories;
            return this;
        }

        public BaseVmRecoveryPointBuilder applicationConsistentProperties(Object applicationConsistentProperties) {
            this.applicationConsistentProperties = applicationConsistentProperties;
            return this;
        }

        public BaseVmRecoveryPoint build() {
            return new BaseVmRecoveryPoint(this.tenantId, this.extId, this.links, this.locationAgnosticId, this.name, this.creationTime, this.expirationTime, this.status, this.recoveryPointType, this.consistencyGroupExtId, this.diskRecoveryPoints, this.vmExtId, this.vmCategories, this.applicationConsistentProperties);
        }

        public String toString() {
            return "BaseVmRecoveryPoint.BaseVmRecoveryPointBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", locationAgnosticId=" + this.locationAgnosticId + ", name=" + this.name + ", creationTime=" + this.creationTime + ", expirationTime=" + this.expirationTime + ", status=" + (Object)((Object)this.status) + ", recoveryPointType=" + (Object)((Object)this.recoveryPointType) + ", consistencyGroupExtId=" + this.consistencyGroupExtId + ", diskRecoveryPoints=" + this.diskRecoveryPoints + ", vmExtId=" + this.vmExtId + ", vmCategories=" + this.vmCategories + ", applicationConsistentProperties=" + this.applicationConsistentProperties + ")";
        }
    }

    @JsonDeserialize(using=OneOfApplicationConsistentPropertiesWrapperJsonDeserializer.class)
    public static class OneOfApplicationConsistentPropertiesWrapper {
        @JsonIgnore
        private VssProperties oneOfType2001;
        private String discriminator;
        @JsonIgnore
        private String $objectType;

        public OneOfApplicationConsistentPropertiesWrapper() {
        }

        public OneOfApplicationConsistentPropertiesWrapper(VssProperties data) {
            this.oneOfType2001 = data;
            this.discriminator = data.get$objectType();
            this.$objectType = data.get$objectType();
        }

        @JsonGetter
        public Object getValue() {
            if (this.oneOfType2001 != null && this.oneOfType2001.get$objectType().equals(this.discriminator)) {
                return this.oneOfType2001;
            }
            throw new IllegalArgumentException("Unrecognized discriminator:" + this.discriminator);
        }

        public void setValue(Object value) {
            if (value == null) {
                log.warn("null passed to setValue function. OneOf's value will not be set.");
                return;
            }
            if (value instanceof VssProperties) {
                this.oneOfType2001 = (VssProperties)value;
                this.discriminator = this.oneOfType2001.get$objectType();
                this.$objectType = this.oneOfType2001.get$objectType();
                return;
            }
            throw new IllegalArgumentException("Attempting to set unsupported object type in OneOfApplicationConsistentPropertiesWrapper:" + value.getClass().getName());
        }

        public String getDiscriminator() {
            return this.discriminator;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OneOfApplicationConsistentPropertiesWrapper)) {
                return false;
            }
            OneOfApplicationConsistentPropertiesWrapper other = (OneOfApplicationConsistentPropertiesWrapper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            VssProperties this$oneOfType2001 = this.oneOfType2001;
            VssProperties other$oneOfType2001 = other.oneOfType2001;
            if (this$oneOfType2001 == null ? other$oneOfType2001 != null : !((Object)this$oneOfType2001).equals(other$oneOfType2001)) {
                return false;
            }
            String this$discriminator = this.getDiscriminator();
            String other$discriminator = other.getDiscriminator();
            return !(this$discriminator == null ? other$discriminator != null : !this$discriminator.equals(other$discriminator));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OneOfApplicationConsistentPropertiesWrapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            VssProperties $oneOfType2001 = this.oneOfType2001;
            result = result * 59 + ($oneOfType2001 == null ? 43 : ((Object)$oneOfType2001).hashCode());
            String $discriminator = this.getDiscriminator();
            result = result * 59 + ($discriminator == null ? 43 : $discriminator.hashCode());
            return result;
        }

        public String toString() {
            return "BaseVmRecoveryPoint.OneOfApplicationConsistentPropertiesWrapper(oneOfType2001=" + this.oneOfType2001 + ", discriminator=" + this.getDiscriminator() + ")";
        }

        @DatJsonDeserializer
        private static class OneOfApplicationConsistentPropertiesWrapperJsonDeserializer
        extends DatOneOfDeserializer<OneOfApplicationConsistentPropertiesWrapper> {
            private static final TypeFactory TYPE_FACTORY = TypeFactory.defaultInstance();
            private static final JavaType ONE_OF_TYPE2001 = TYPE_FACTORY.constructType(VssProperties.class);

            public OneOfApplicationConsistentPropertiesWrapperJsonDeserializer() {
                super(TYPE_FACTORY.constructType(OneOfApplicationConsistentPropertiesWrapper.class));
            }

            @Override
            protected void setDataObject(OneOfApplicationConsistentPropertiesWrapper oneOfObject, Object nestedObject) {
                if (oneOfObject == null) {
                    throw new IllegalArgumentException("Instance of OneOfApplicationConsistentPropertiesWrapper provided is null");
                }
                if (ONE_OF_TYPE2001.getRawClass().isAssignableFrom(nestedObject.getClass())) {
                    oneOfObject.setValue(nestedObject);
                    if (oneOfObject.getValue() != null) {
                        return;
                    }
                }
                throw new IllegalArgumentException("Attempting to set unsupported object type in OneOfApplicationConsistentPropertiesWrapper:" + nestedObject.getClass().getName());
            }

            @Override
            public String getPackagePrefix() {
                return "com.nutanix.dp1.dat";
            }
        }
    }
}

