/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.dat.dataprotection.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.dat.common.v1.response.ApiLink;
import com.nutanix.dp1.dat.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.dat.dataprotection.v4.config.ConsistencyGroupMember;
import com.nutanix.dp1.dat.deserializers.DatObjectTypeTypedObject;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistencyGroup
extends ExternalizableAbstractModel
implements Serializable,
DatObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(ConsistencyGroup.class);
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    private @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String ownerExtId = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    private @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String clusterExtId = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    private @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String protectionPolicyExtId = null;
    @Size(max=256)
    @JsonProperty(value="name")
    public @Size(max=256) String name = null;
    @Size(min=1, max=30)
    @JsonProperty(value="members")
    public @Size(min=1, max=30) List<ConsistencyGroupMember> members = null;

    public ConsistencyGroup() {
    }

    public ConsistencyGroup(String tenantId, String extId, List<ApiLink> links, String name, String ownerExtId, List<ConsistencyGroupMember> members, String clusterExtId, String protectionPolicyExtId) {
        super(tenantId, extId, links);
        this.setName(name);
        this.setOwnerExtId(ownerExtId);
        this.setMembers(members);
        this.setClusterExtId(clusterExtId);
        this.setProtectionPolicyExtId(protectionPolicyExtId);
    }

    @Override
    protected String initialize$objectType() {
        return "dataprotection.v4.config.ConsistencyGroup";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setOwnerExtId(String ownerExtId) {
        if (this.ownerExtId == null) {
            this.ownerExtId = ownerExtId;
        } else {
            log.warn("Read-only property ownerExtId already contains a non-null value and cannot be set again");
        }
    }

    public void setClusterExtId(String clusterExtId) {
        if (this.clusterExtId == null) {
            this.clusterExtId = clusterExtId;
        } else {
            log.warn("Read-only property clusterExtId already contains a non-null value and cannot be set again");
        }
    }

    public void setProtectionPolicyExtId(String protectionPolicyExtId) {
        if (this.protectionPolicyExtId == null) {
            this.protectionPolicyExtId = protectionPolicyExtId;
        } else {
            log.warn("Read-only property protectionPolicyExtId already contains a non-null value and cannot be set again");
        }
    }

    public static ConsistencyGroupBuilder ConsistencyGroupBuilder() {
        return new ConsistencyGroupBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConsistencyGroup)) {
            return false;
        }
        ConsistencyGroup other = (ConsistencyGroup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$ownerExtId = this.getOwnerExtId();
        String other$ownerExtId = other.getOwnerExtId();
        if (this$ownerExtId == null ? other$ownerExtId != null : !this$ownerExtId.equals(other$ownerExtId)) {
            return false;
        }
        String this$clusterExtId = this.getClusterExtId();
        String other$clusterExtId = other.getClusterExtId();
        if (this$clusterExtId == null ? other$clusterExtId != null : !this$clusterExtId.equals(other$clusterExtId)) {
            return false;
        }
        String this$protectionPolicyExtId = this.getProtectionPolicyExtId();
        String other$protectionPolicyExtId = other.getProtectionPolicyExtId();
        if (this$protectionPolicyExtId == null ? other$protectionPolicyExtId != null : !this$protectionPolicyExtId.equals(other$protectionPolicyExtId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<ConsistencyGroupMember> this$members = this.getMembers();
        List<ConsistencyGroupMember> other$members = other.getMembers();
        return !(this$members == null ? other$members != null : !((Object)this$members).equals(other$members));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ConsistencyGroup;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $ownerExtId = this.getOwnerExtId();
        result = result * 59 + ($ownerExtId == null ? 43 : $ownerExtId.hashCode());
        String $clusterExtId = this.getClusterExtId();
        result = result * 59 + ($clusterExtId == null ? 43 : $clusterExtId.hashCode());
        String $protectionPolicyExtId = this.getProtectionPolicyExtId();
        result = result * 59 + ($protectionPolicyExtId == null ? 43 : $protectionPolicyExtId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<ConsistencyGroupMember> $members = this.getMembers();
        result = result * 59 + ($members == null ? 43 : ((Object)$members).hashCode());
        return result;
    }

    public String getOwnerExtId() {
        return this.ownerExtId;
    }

    public String getClusterExtId() {
        return this.clusterExtId;
    }

    public String getProtectionPolicyExtId() {
        return this.protectionPolicyExtId;
    }

    public String getName() {
        return this.name;
    }

    public List<ConsistencyGroupMember> getMembers() {
        return this.members;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="members")
    public void setMembers(List<ConsistencyGroupMember> members) {
        this.members = members;
    }

    @Override
    public String toString() {
        return "ConsistencyGroup(ownerExtId=" + this.getOwnerExtId() + ", clusterExtId=" + this.getClusterExtId() + ", protectionPolicyExtId=" + this.getProtectionPolicyExtId() + ", name=" + this.getName() + ", members=" + this.getMembers() + ")";
    }

    public static class ConsistencyGroupBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String name;
        private String ownerExtId;
        private List<ConsistencyGroupMember> members;
        private String clusterExtId;
        private String protectionPolicyExtId;

        ConsistencyGroupBuilder() {
        }

        public ConsistencyGroupBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public ConsistencyGroupBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public ConsistencyGroupBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public ConsistencyGroupBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ConsistencyGroupBuilder ownerExtId(String ownerExtId) {
            this.ownerExtId = ownerExtId;
            return this;
        }

        public ConsistencyGroupBuilder members(List<ConsistencyGroupMember> members) {
            this.members = members;
            return this;
        }

        public ConsistencyGroupBuilder clusterExtId(String clusterExtId) {
            this.clusterExtId = clusterExtId;
            return this;
        }

        public ConsistencyGroupBuilder protectionPolicyExtId(String protectionPolicyExtId) {
            this.protectionPolicyExtId = protectionPolicyExtId;
            return this;
        }

        public ConsistencyGroup build() {
            return new ConsistencyGroup(this.tenantId, this.extId, this.links, this.name, this.ownerExtId, this.members, this.clusterExtId, this.protectionPolicyExtId);
        }

        public String toString() {
            return "ConsistencyGroup.ConsistencyGroupBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", name=" + this.name + ", ownerExtId=" + this.ownerExtId + ", members=" + this.members + ", clusterExtId=" + this.clusterExtId + ", protectionPolicyExtId=" + this.protectionPolicyExtId + ")";
        }
    }
}

