/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.dat.dataprotection.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.dat.common.v1.response.ApiLink;
import com.nutanix.dp1.dat.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.dat.dataprotection.v4.config.DataProtectionSiteReference;
import com.nutanix.dp1.dat.dataprotection.v4.config.ProtectedEntityType;
import com.nutanix.dp1.dat.dataprotection.v4.config.ReplicationState;
import com.nutanix.dp1.dat.dataprotection.v4.config.SiteProtectionInfo;
import com.nutanix.dp1.dat.deserializers.DatObjectTypeTypedObject;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtectedResource
extends ExternalizableAbstractModel
implements Serializable,
DatObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(ProtectedResource.class);
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="entityExtId")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String entityExtId = null;
    @JsonProperty(value="entityType")
    public ProtectedEntityType entityType = null;
    @JsonProperty(value="sourceSiteReference")
    public DataProtectionSiteReference sourceSiteReference = null;
    @Size(min=0, max=20)
    @JsonProperty(value="siteProtectionInfo")
    public @Size(min=0, max=20) List<SiteProtectionInfo> siteProtectionInfo = null;
    @Size(min=0, max=20)
    @JsonProperty(value="replicationStates")
    public @Size(min=0, max=20) List<ReplicationState> replicationStates = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="consistencyGroupExtId")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String consistencyGroupExtId = null;
    @Size(min=0, max=1200)
    @JsonProperty(value="categoryFqNames")
    public @Size(min=0, max=1200) List<String> categoryFqNames = null;

    public ProtectedResource() {
    }

    public ProtectedResource(String tenantId, String extId, List<ApiLink> links, String entityExtId, ProtectedEntityType entityType, DataProtectionSiteReference sourceSiteReference, List<SiteProtectionInfo> siteProtectionInfo, List<ReplicationState> replicationStates, String consistencyGroupExtId, List<String> categoryFqNames) {
        super(tenantId, extId, links);
        this.setEntityExtId(entityExtId);
        this.setEntityType(entityType);
        this.setSourceSiteReference(sourceSiteReference);
        this.setSiteProtectionInfo(siteProtectionInfo);
        this.setReplicationStates(replicationStates);
        this.setConsistencyGroupExtId(consistencyGroupExtId);
        this.setCategoryFqNames(categoryFqNames);
    }

    @Override
    protected String initialize$objectType() {
        return "dataprotection.v4.config.ProtectedResource";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public static ProtectedResourceBuilder ProtectedResourceBuilder() {
        return new ProtectedResourceBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProtectedResource)) {
            return false;
        }
        ProtectedResource other = (ProtectedResource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$entityExtId = this.getEntityExtId();
        String other$entityExtId = other.getEntityExtId();
        if (this$entityExtId == null ? other$entityExtId != null : !this$entityExtId.equals(other$entityExtId)) {
            return false;
        }
        ProtectedEntityType this$entityType = this.getEntityType();
        ProtectedEntityType other$entityType = other.getEntityType();
        if (this$entityType == null ? other$entityType != null : !((Object)((Object)this$entityType)).equals((Object)other$entityType)) {
            return false;
        }
        DataProtectionSiteReference this$sourceSiteReference = this.getSourceSiteReference();
        DataProtectionSiteReference other$sourceSiteReference = other.getSourceSiteReference();
        if (this$sourceSiteReference == null ? other$sourceSiteReference != null : !((Object)this$sourceSiteReference).equals(other$sourceSiteReference)) {
            return false;
        }
        List<SiteProtectionInfo> this$siteProtectionInfo = this.getSiteProtectionInfo();
        List<SiteProtectionInfo> other$siteProtectionInfo = other.getSiteProtectionInfo();
        if (this$siteProtectionInfo == null ? other$siteProtectionInfo != null : !((Object)this$siteProtectionInfo).equals(other$siteProtectionInfo)) {
            return false;
        }
        List<ReplicationState> this$replicationStates = this.getReplicationStates();
        List<ReplicationState> other$replicationStates = other.getReplicationStates();
        if (this$replicationStates == null ? other$replicationStates != null : !((Object)this$replicationStates).equals(other$replicationStates)) {
            return false;
        }
        String this$consistencyGroupExtId = this.getConsistencyGroupExtId();
        String other$consistencyGroupExtId = other.getConsistencyGroupExtId();
        if (this$consistencyGroupExtId == null ? other$consistencyGroupExtId != null : !this$consistencyGroupExtId.equals(other$consistencyGroupExtId)) {
            return false;
        }
        List<String> this$categoryFqNames = this.getCategoryFqNames();
        List<String> other$categoryFqNames = other.getCategoryFqNames();
        return !(this$categoryFqNames == null ? other$categoryFqNames != null : !((Object)this$categoryFqNames).equals(other$categoryFqNames));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ProtectedResource;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $entityExtId = this.getEntityExtId();
        result = result * 59 + ($entityExtId == null ? 43 : $entityExtId.hashCode());
        ProtectedEntityType $entityType = this.getEntityType();
        result = result * 59 + ($entityType == null ? 43 : ((Object)((Object)$entityType)).hashCode());
        DataProtectionSiteReference $sourceSiteReference = this.getSourceSiteReference();
        result = result * 59 + ($sourceSiteReference == null ? 43 : ((Object)$sourceSiteReference).hashCode());
        List<SiteProtectionInfo> $siteProtectionInfo = this.getSiteProtectionInfo();
        result = result * 59 + ($siteProtectionInfo == null ? 43 : ((Object)$siteProtectionInfo).hashCode());
        List<ReplicationState> $replicationStates = this.getReplicationStates();
        result = result * 59 + ($replicationStates == null ? 43 : ((Object)$replicationStates).hashCode());
        String $consistencyGroupExtId = this.getConsistencyGroupExtId();
        result = result * 59 + ($consistencyGroupExtId == null ? 43 : $consistencyGroupExtId.hashCode());
        List<String> $categoryFqNames = this.getCategoryFqNames();
        result = result * 59 + ($categoryFqNames == null ? 43 : ((Object)$categoryFqNames).hashCode());
        return result;
    }

    public String getEntityExtId() {
        return this.entityExtId;
    }

    public ProtectedEntityType getEntityType() {
        return this.entityType;
    }

    public DataProtectionSiteReference getSourceSiteReference() {
        return this.sourceSiteReference;
    }

    public List<SiteProtectionInfo> getSiteProtectionInfo() {
        return this.siteProtectionInfo;
    }

    public List<ReplicationState> getReplicationStates() {
        return this.replicationStates;
    }

    public String getConsistencyGroupExtId() {
        return this.consistencyGroupExtId;
    }

    public List<String> getCategoryFqNames() {
        return this.categoryFqNames;
    }

    @JsonProperty(value="entityExtId")
    public void setEntityExtId(String entityExtId) {
        this.entityExtId = entityExtId;
    }

    @JsonProperty(value="entityType")
    public void setEntityType(ProtectedEntityType entityType) {
        this.entityType = entityType;
    }

    @JsonProperty(value="sourceSiteReference")
    public void setSourceSiteReference(DataProtectionSiteReference sourceSiteReference) {
        this.sourceSiteReference = sourceSiteReference;
    }

    @JsonProperty(value="siteProtectionInfo")
    public void setSiteProtectionInfo(List<SiteProtectionInfo> siteProtectionInfo) {
        this.siteProtectionInfo = siteProtectionInfo;
    }

    @JsonProperty(value="replicationStates")
    public void setReplicationStates(List<ReplicationState> replicationStates) {
        this.replicationStates = replicationStates;
    }

    @JsonProperty(value="consistencyGroupExtId")
    public void setConsistencyGroupExtId(String consistencyGroupExtId) {
        this.consistencyGroupExtId = consistencyGroupExtId;
    }

    @JsonProperty(value="categoryFqNames")
    public void setCategoryFqNames(List<String> categoryFqNames) {
        this.categoryFqNames = categoryFqNames;
    }

    @Override
    public String toString() {
        return "ProtectedResource(entityExtId=" + this.getEntityExtId() + ", entityType=" + (Object)((Object)this.getEntityType()) + ", sourceSiteReference=" + this.getSourceSiteReference() + ", siteProtectionInfo=" + this.getSiteProtectionInfo() + ", replicationStates=" + this.getReplicationStates() + ", consistencyGroupExtId=" + this.getConsistencyGroupExtId() + ", categoryFqNames=" + this.getCategoryFqNames() + ")";
    }

    public static class ProtectedResourceBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String entityExtId;
        private ProtectedEntityType entityType;
        private DataProtectionSiteReference sourceSiteReference;
        private List<SiteProtectionInfo> siteProtectionInfo;
        private List<ReplicationState> replicationStates;
        private String consistencyGroupExtId;
        private List<String> categoryFqNames;

        ProtectedResourceBuilder() {
        }

        public ProtectedResourceBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public ProtectedResourceBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public ProtectedResourceBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public ProtectedResourceBuilder entityExtId(String entityExtId) {
            this.entityExtId = entityExtId;
            return this;
        }

        public ProtectedResourceBuilder entityType(ProtectedEntityType entityType) {
            this.entityType = entityType;
            return this;
        }

        public ProtectedResourceBuilder sourceSiteReference(DataProtectionSiteReference sourceSiteReference) {
            this.sourceSiteReference = sourceSiteReference;
            return this;
        }

        public ProtectedResourceBuilder siteProtectionInfo(List<SiteProtectionInfo> siteProtectionInfo) {
            this.siteProtectionInfo = siteProtectionInfo;
            return this;
        }

        public ProtectedResourceBuilder replicationStates(List<ReplicationState> replicationStates) {
            this.replicationStates = replicationStates;
            return this;
        }

        public ProtectedResourceBuilder consistencyGroupExtId(String consistencyGroupExtId) {
            this.consistencyGroupExtId = consistencyGroupExtId;
            return this;
        }

        public ProtectedResourceBuilder categoryFqNames(List<String> categoryFqNames) {
            this.categoryFqNames = categoryFqNames;
            return this;
        }

        public ProtectedResource build() {
            return new ProtectedResource(this.tenantId, this.extId, this.links, this.entityExtId, this.entityType, this.sourceSiteReference, this.siteProtectionInfo, this.replicationStates, this.consistencyGroupExtId, this.categoryFqNames);
        }

        public String toString() {
            return "ProtectedResource.ProtectedResourceBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", entityExtId=" + this.entityExtId + ", entityType=" + (Object)((Object)this.entityType) + ", sourceSiteReference=" + this.sourceSiteReference + ", siteProtectionInfo=" + this.siteProtectionInfo + ", replicationStates=" + this.replicationStates + ", consistencyGroupExtId=" + this.consistencyGroupExtId + ", categoryFqNames=" + this.categoryFqNames + ")";
        }
    }
}

