/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.dat.dataprotection.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.dat.common.v1.response.ApiLink;
import com.nutanix.dp1.dat.dataprotection.v4.common.BaseRecoveryPoint;
import com.nutanix.dp1.dat.dataprotection.v4.common.RecoveryPointStatus;
import com.nutanix.dp1.dat.dataprotection.v4.common.RecoveryPointType;
import com.nutanix.dp1.dat.dataprotection.v4.config.LocationReference;
import com.nutanix.dp1.dat.dataprotection.v4.config.VmRecoveryPoint;
import com.nutanix.dp1.dat.dataprotection.v4.config.VolumeGroupRecoveryPoint;
import com.nutanix.dp1.dat.deserializers.DatObjectTypeTypedObject;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveryPoint
extends BaseRecoveryPoint
implements Serializable,
DatObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(RecoveryPoint.class);
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    private @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String ownerExtId = null;
    @Size(min=1, max=1)
    private @Size(min=1, max=1) List<LocationReference> locationReferences = null;
    @Size(min=1, max=30)
    @JsonProperty(value="vmRecoveryPoints")
    public @Size(min=1, max=30) List<VmRecoveryPoint> vmRecoveryPoints = null;
    @Size(min=1, max=30)
    @JsonProperty(value="volumeGroupRecoveryPoints")
    public @Size(min=1, max=30) List<VolumeGroupRecoveryPoint> volumeGroupRecoveryPoints = null;

    public RecoveryPoint() {
    }

    public RecoveryPoint(String tenantId, String extId, List<ApiLink> links, String locationAgnosticId, String name, OffsetDateTime creationTime, OffsetDateTime expirationTime, RecoveryPointStatus status, RecoveryPointType recoveryPointType, String ownerExtId, List<LocationReference> locationReferences, List<VmRecoveryPoint> vmRecoveryPoints, List<VolumeGroupRecoveryPoint> volumeGroupRecoveryPoints) {
        super(tenantId, extId, links, locationAgnosticId, name, creationTime, expirationTime, status, recoveryPointType);
        this.setOwnerExtId(ownerExtId);
        this.setLocationReferences(locationReferences);
        this.setVmRecoveryPoints(vmRecoveryPoints);
        this.setVolumeGroupRecoveryPoints(volumeGroupRecoveryPoints);
    }

    @Override
    protected String initialize$objectType() {
        return "dataprotection.v4.config.RecoveryPoint";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setOwnerExtId(String ownerExtId) {
        if (this.ownerExtId == null) {
            this.ownerExtId = ownerExtId;
        } else {
            log.warn("Read-only property ownerExtId already contains a non-null value and cannot be set again");
        }
    }

    public void setLocationReferences(List<LocationReference> locationReferences) {
        if (this.locationReferences == null) {
            this.locationReferences = locationReferences;
        } else {
            log.warn("Read-only property locationReferences already contains a non-null value and cannot be set again");
        }
    }

    public static RecoveryPointBuilder RecoveryPointBuilder() {
        return new RecoveryPointBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecoveryPoint)) {
            return false;
        }
        RecoveryPoint other = (RecoveryPoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$ownerExtId = this.getOwnerExtId();
        String other$ownerExtId = other.getOwnerExtId();
        if (this$ownerExtId == null ? other$ownerExtId != null : !this$ownerExtId.equals(other$ownerExtId)) {
            return false;
        }
        List<LocationReference> this$locationReferences = this.getLocationReferences();
        List<LocationReference> other$locationReferences = other.getLocationReferences();
        if (this$locationReferences == null ? other$locationReferences != null : !((Object)this$locationReferences).equals(other$locationReferences)) {
            return false;
        }
        List<VmRecoveryPoint> this$vmRecoveryPoints = this.getVmRecoveryPoints();
        List<VmRecoveryPoint> other$vmRecoveryPoints = other.getVmRecoveryPoints();
        if (this$vmRecoveryPoints == null ? other$vmRecoveryPoints != null : !((Object)this$vmRecoveryPoints).equals(other$vmRecoveryPoints)) {
            return false;
        }
        List<VolumeGroupRecoveryPoint> this$volumeGroupRecoveryPoints = this.getVolumeGroupRecoveryPoints();
        List<VolumeGroupRecoveryPoint> other$volumeGroupRecoveryPoints = other.getVolumeGroupRecoveryPoints();
        return !(this$volumeGroupRecoveryPoints == null ? other$volumeGroupRecoveryPoints != null : !((Object)this$volumeGroupRecoveryPoints).equals(other$volumeGroupRecoveryPoints));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RecoveryPoint;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $ownerExtId = this.getOwnerExtId();
        result = result * 59 + ($ownerExtId == null ? 43 : $ownerExtId.hashCode());
        List<LocationReference> $locationReferences = this.getLocationReferences();
        result = result * 59 + ($locationReferences == null ? 43 : ((Object)$locationReferences).hashCode());
        List<VmRecoveryPoint> $vmRecoveryPoints = this.getVmRecoveryPoints();
        result = result * 59 + ($vmRecoveryPoints == null ? 43 : ((Object)$vmRecoveryPoints).hashCode());
        List<VolumeGroupRecoveryPoint> $volumeGroupRecoveryPoints = this.getVolumeGroupRecoveryPoints();
        result = result * 59 + ($volumeGroupRecoveryPoints == null ? 43 : ((Object)$volumeGroupRecoveryPoints).hashCode());
        return result;
    }

    public String getOwnerExtId() {
        return this.ownerExtId;
    }

    public List<LocationReference> getLocationReferences() {
        return this.locationReferences;
    }

    public List<VmRecoveryPoint> getVmRecoveryPoints() {
        return this.vmRecoveryPoints;
    }

    public List<VolumeGroupRecoveryPoint> getVolumeGroupRecoveryPoints() {
        return this.volumeGroupRecoveryPoints;
    }

    @JsonProperty(value="vmRecoveryPoints")
    public void setVmRecoveryPoints(List<VmRecoveryPoint> vmRecoveryPoints) {
        this.vmRecoveryPoints = vmRecoveryPoints;
    }

    @JsonProperty(value="volumeGroupRecoveryPoints")
    public void setVolumeGroupRecoveryPoints(List<VolumeGroupRecoveryPoint> volumeGroupRecoveryPoints) {
        this.volumeGroupRecoveryPoints = volumeGroupRecoveryPoints;
    }

    @Override
    public String toString() {
        return "RecoveryPoint(ownerExtId=" + this.getOwnerExtId() + ", locationReferences=" + this.getLocationReferences() + ", vmRecoveryPoints=" + this.getVmRecoveryPoints() + ", volumeGroupRecoveryPoints=" + this.getVolumeGroupRecoveryPoints() + ")";
    }

    public static class RecoveryPointBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String locationAgnosticId;
        private String name;
        private OffsetDateTime creationTime;
        private OffsetDateTime expirationTime;
        private RecoveryPointStatus status;
        private RecoveryPointType recoveryPointType;
        private String ownerExtId;
        private List<LocationReference> locationReferences;
        private List<VmRecoveryPoint> vmRecoveryPoints;
        private List<VolumeGroupRecoveryPoint> volumeGroupRecoveryPoints;

        RecoveryPointBuilder() {
        }

        public RecoveryPointBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public RecoveryPointBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public RecoveryPointBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public RecoveryPointBuilder locationAgnosticId(String locationAgnosticId) {
            this.locationAgnosticId = locationAgnosticId;
            return this;
        }

        public RecoveryPointBuilder name(String name) {
            this.name = name;
            return this;
        }

        public RecoveryPointBuilder creationTime(OffsetDateTime creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public RecoveryPointBuilder expirationTime(OffsetDateTime expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public RecoveryPointBuilder status(RecoveryPointStatus status) {
            this.status = status;
            return this;
        }

        public RecoveryPointBuilder recoveryPointType(RecoveryPointType recoveryPointType) {
            this.recoveryPointType = recoveryPointType;
            return this;
        }

        public RecoveryPointBuilder ownerExtId(String ownerExtId) {
            this.ownerExtId = ownerExtId;
            return this;
        }

        public RecoveryPointBuilder locationReferences(List<LocationReference> locationReferences) {
            this.locationReferences = locationReferences;
            return this;
        }

        public RecoveryPointBuilder vmRecoveryPoints(List<VmRecoveryPoint> vmRecoveryPoints) {
            this.vmRecoveryPoints = vmRecoveryPoints;
            return this;
        }

        public RecoveryPointBuilder volumeGroupRecoveryPoints(List<VolumeGroupRecoveryPoint> volumeGroupRecoveryPoints) {
            this.volumeGroupRecoveryPoints = volumeGroupRecoveryPoints;
            return this;
        }

        public RecoveryPoint build() {
            return new RecoveryPoint(this.tenantId, this.extId, this.links, this.locationAgnosticId, this.name, this.creationTime, this.expirationTime, this.status, this.recoveryPointType, this.ownerExtId, this.locationReferences, this.vmRecoveryPoints, this.volumeGroupRecoveryPoints);
        }

        public String toString() {
            return "RecoveryPoint.RecoveryPointBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", locationAgnosticId=" + this.locationAgnosticId + ", name=" + this.name + ", creationTime=" + this.creationTime + ", expirationTime=" + this.expirationTime + ", status=" + (Object)((Object)this.status) + ", recoveryPointType=" + (Object)((Object)this.recoveryPointType) + ", ownerExtId=" + this.ownerExtId + ", locationReferences=" + this.locationReferences + ", vmRecoveryPoints=" + this.vmRecoveryPoints + ", volumeGroupRecoveryPoints=" + this.volumeGroupRecoveryPoints + ")";
        }
    }
}

