/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.dat.dataprotection.v4.config;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.nutanix.dp1.dat.annotations.DatJsonDeserializer;
import com.nutanix.dp1.dat.common.v1.response.ApiLink;
import com.nutanix.dp1.dat.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.dat.dataprotection.v4.config.AmazonS3Bucket;
import com.nutanix.dp1.dat.dataprotection.v4.config.AzureBlobStorageContainer;
import com.nutanix.dp1.dat.dataprotection.v4.config.NutanixObjectsBucket;
import com.nutanix.dp1.dat.dataprotection.v4.config.ObjectStorageType;
import com.nutanix.dp1.dat.deserializers.DatObjectTypeTypedObject;
import com.nutanix.dp1.dat.deserializers.DatOneOfDeserializer;
import com.nutanix.dp1.dat.serializers.DatOneOfSerializer;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveryPointRepository
extends ExternalizableAbstractModel
implements Serializable,
DatObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(RecoveryPointRepository.class);
    @Size(max=256)
    @JsonProperty(value="name")
    public @Size(max=256) String name = null;
    @JsonProperty(value="objectStorageType")
    public ObjectStorageType objectStorageType = null;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String $objectStorageReferenceItemDiscriminator = null;
    private OneOfObjectStorageReferenceWrapper objectStorageReference = null;

    public RecoveryPointRepository() {
    }

    public RecoveryPointRepository(String tenantId, String extId, List<ApiLink> links, String name, ObjectStorageType objectStorageType, Object objectStorageReference) {
        super(tenantId, extId, links);
        this.setName(name);
        this.setObjectStorageType(objectStorageType);
        this.setObjectStorageReferenceInWrapper(objectStorageReference);
    }

    @Override
    protected String initialize$objectType() {
        return "dataprotection.v4.config.RecoveryPointRepository";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public String get$objectStorageReferenceItemDiscriminator() {
        if (this.objectStorageReference != null && this.$objectStorageReferenceItemDiscriminator == null) {
            this.$objectStorageReferenceItemDiscriminator = this.objectStorageReference.getDiscriminator();
        }
        return this.$objectStorageReferenceItemDiscriminator;
    }

    @JsonIgnore
    public void setObjectStorageReferenceInWrapper(Object value) {
        if (value == null) {
            return;
        }
        if (this.objectStorageReference == null) {
            this.objectStorageReference = new OneOfObjectStorageReferenceWrapper();
        }
        this.objectStorageReference.setValue(value);
        this.$objectStorageReferenceItemDiscriminator = this.objectStorageReference.getDiscriminator();
    }

    @JsonSerialize(using=DatOneOfSerializer.class)
    public Object getObjectStorageReference() {
        if (this.objectStorageReference == null) {
            log.debug("OneOf property objectStorageReference was never set. Returning null...");
            return null;
        }
        return this.objectStorageReference.getValue();
    }

    public static RecoveryPointRepositoryBuilder RecoveryPointRepositoryBuilder() {
        return new RecoveryPointRepositoryBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecoveryPointRepository)) {
            return false;
        }
        RecoveryPointRepository other = (RecoveryPointRepository)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ObjectStorageType this$objectStorageType = this.getObjectStorageType();
        ObjectStorageType other$objectStorageType = other.getObjectStorageType();
        if (this$objectStorageType == null ? other$objectStorageType != null : !((Object)((Object)this$objectStorageType)).equals((Object)other$objectStorageType)) {
            return false;
        }
        Object this$objectStorageReference = this.getObjectStorageReference();
        Object other$objectStorageReference = other.getObjectStorageReference();
        return !(this$objectStorageReference == null ? other$objectStorageReference != null : !this$objectStorageReference.equals(other$objectStorageReference));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RecoveryPointRepository;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ObjectStorageType $objectStorageType = this.getObjectStorageType();
        result = result * 59 + ($objectStorageType == null ? 43 : ((Object)((Object)$objectStorageType)).hashCode());
        Object $objectStorageReference = this.getObjectStorageReference();
        result = result * 59 + ($objectStorageReference == null ? 43 : $objectStorageReference.hashCode());
        return result;
    }

    public String getName() {
        return this.name;
    }

    public ObjectStorageType getObjectStorageType() {
        return this.objectStorageType;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="objectStorageType")
    public void setObjectStorageType(ObjectStorageType objectStorageType) {
        this.objectStorageType = objectStorageType;
    }

    public void setObjectStorageReference(OneOfObjectStorageReferenceWrapper objectStorageReference) {
        this.objectStorageReference = objectStorageReference;
    }

    @Override
    public String toString() {
        return "RecoveryPointRepository(name=" + this.getName() + ", objectStorageType=" + (Object)((Object)this.getObjectStorageType()) + ", objectStorageReference=" + this.getObjectStorageReference() + ")";
    }

    public static class RecoveryPointRepositoryBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String name;
        private ObjectStorageType objectStorageType;
        private Object objectStorageReference;

        RecoveryPointRepositoryBuilder() {
        }

        public RecoveryPointRepositoryBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public RecoveryPointRepositoryBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public RecoveryPointRepositoryBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public RecoveryPointRepositoryBuilder name(String name) {
            this.name = name;
            return this;
        }

        public RecoveryPointRepositoryBuilder objectStorageType(ObjectStorageType objectStorageType) {
            this.objectStorageType = objectStorageType;
            return this;
        }

        public RecoveryPointRepositoryBuilder objectStorageReference(Object objectStorageReference) {
            this.objectStorageReference = objectStorageReference;
            return this;
        }

        public RecoveryPointRepository build() {
            return new RecoveryPointRepository(this.tenantId, this.extId, this.links, this.name, this.objectStorageType, this.objectStorageReference);
        }

        public String toString() {
            return "RecoveryPointRepository.RecoveryPointRepositoryBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", name=" + this.name + ", objectStorageType=" + (Object)((Object)this.objectStorageType) + ", objectStorageReference=" + this.objectStorageReference + ")";
        }
    }

    @JsonDeserialize(using=OneOfObjectStorageReferenceWrapperJsonDeserializer.class)
    public static class OneOfObjectStorageReferenceWrapper {
        @JsonIgnore
        private AzureBlobStorageContainer oneOfType0;
        @JsonIgnore
        private AmazonS3Bucket oneOfType1;
        @JsonIgnore
        private NutanixObjectsBucket oneOfType2;
        private String discriminator;
        @JsonIgnore
        private String $objectType;

        public OneOfObjectStorageReferenceWrapper() {
        }

        public OneOfObjectStorageReferenceWrapper(AzureBlobStorageContainer data) {
            this.oneOfType0 = data;
            this.discriminator = data.get$objectType();
            this.$objectType = data.get$objectType();
        }

        public OneOfObjectStorageReferenceWrapper(AmazonS3Bucket data) {
            this.oneOfType1 = data;
            this.discriminator = data.get$objectType();
            this.$objectType = data.get$objectType();
        }

        public OneOfObjectStorageReferenceWrapper(NutanixObjectsBucket data) {
            this.oneOfType2 = data;
            this.discriminator = data.get$objectType();
            this.$objectType = data.get$objectType();
        }

        @JsonGetter
        public Object getValue() {
            if (this.oneOfType0 != null && this.oneOfType0.get$objectType().equals(this.discriminator)) {
                return this.oneOfType0;
            }
            if (this.oneOfType1 != null && this.oneOfType1.get$objectType().equals(this.discriminator)) {
                return this.oneOfType1;
            }
            if (this.oneOfType2 != null && this.oneOfType2.get$objectType().equals(this.discriminator)) {
                return this.oneOfType2;
            }
            throw new IllegalArgumentException("Unrecognized discriminator:" + this.discriminator);
        }

        public void setValue(Object value) {
            if (value == null) {
                log.warn("null passed to setValue function. OneOf's value will not be set.");
                return;
            }
            if (value instanceof AzureBlobStorageContainer) {
                this.oneOfType0 = (AzureBlobStorageContainer)value;
                this.discriminator = this.oneOfType0.get$objectType();
                this.$objectType = this.oneOfType0.get$objectType();
                return;
            }
            if (value instanceof AmazonS3Bucket) {
                this.oneOfType1 = (AmazonS3Bucket)value;
                this.discriminator = this.oneOfType1.get$objectType();
                this.$objectType = this.oneOfType1.get$objectType();
                return;
            }
            if (value instanceof NutanixObjectsBucket) {
                this.oneOfType2 = (NutanixObjectsBucket)value;
                this.discriminator = this.oneOfType2.get$objectType();
                this.$objectType = this.oneOfType2.get$objectType();
                return;
            }
            throw new IllegalArgumentException("Attempting to set unsupported object type in OneOfObjectStorageReferenceWrapper:" + value.getClass().getName());
        }

        public String getDiscriminator() {
            return this.discriminator;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OneOfObjectStorageReferenceWrapper)) {
                return false;
            }
            OneOfObjectStorageReferenceWrapper other = (OneOfObjectStorageReferenceWrapper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AzureBlobStorageContainer this$oneOfType0 = this.oneOfType0;
            AzureBlobStorageContainer other$oneOfType0 = other.oneOfType0;
            if (this$oneOfType0 == null ? other$oneOfType0 != null : !((Object)this$oneOfType0).equals(other$oneOfType0)) {
                return false;
            }
            AmazonS3Bucket this$oneOfType1 = this.oneOfType1;
            AmazonS3Bucket other$oneOfType1 = other.oneOfType1;
            if (this$oneOfType1 == null ? other$oneOfType1 != null : !((Object)this$oneOfType1).equals(other$oneOfType1)) {
                return false;
            }
            NutanixObjectsBucket this$oneOfType2 = this.oneOfType2;
            NutanixObjectsBucket other$oneOfType2 = other.oneOfType2;
            if (this$oneOfType2 == null ? other$oneOfType2 != null : !((Object)this$oneOfType2).equals(other$oneOfType2)) {
                return false;
            }
            String this$discriminator = this.getDiscriminator();
            String other$discriminator = other.getDiscriminator();
            return !(this$discriminator == null ? other$discriminator != null : !this$discriminator.equals(other$discriminator));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OneOfObjectStorageReferenceWrapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AzureBlobStorageContainer $oneOfType0 = this.oneOfType0;
            result = result * 59 + ($oneOfType0 == null ? 43 : ((Object)$oneOfType0).hashCode());
            AmazonS3Bucket $oneOfType1 = this.oneOfType1;
            result = result * 59 + ($oneOfType1 == null ? 43 : ((Object)$oneOfType1).hashCode());
            NutanixObjectsBucket $oneOfType2 = this.oneOfType2;
            result = result * 59 + ($oneOfType2 == null ? 43 : ((Object)$oneOfType2).hashCode());
            String $discriminator = this.getDiscriminator();
            result = result * 59 + ($discriminator == null ? 43 : $discriminator.hashCode());
            return result;
        }

        public String toString() {
            return "RecoveryPointRepository.OneOfObjectStorageReferenceWrapper(oneOfType0=" + this.oneOfType0 + ", oneOfType1=" + this.oneOfType1 + ", oneOfType2=" + this.oneOfType2 + ", discriminator=" + this.getDiscriminator() + ")";
        }

        @DatJsonDeserializer
        private static class OneOfObjectStorageReferenceWrapperJsonDeserializer
        extends DatOneOfDeserializer<OneOfObjectStorageReferenceWrapper> {
            private static final TypeFactory TYPE_FACTORY = TypeFactory.defaultInstance();
            private static final JavaType ONE_OF_TYPE0 = TYPE_FACTORY.constructType(AzureBlobStorageContainer.class);
            private static final JavaType ONE_OF_TYPE1 = TYPE_FACTORY.constructType(AmazonS3Bucket.class);
            private static final JavaType ONE_OF_TYPE2 = TYPE_FACTORY.constructType(NutanixObjectsBucket.class);

            public OneOfObjectStorageReferenceWrapperJsonDeserializer() {
                super(TYPE_FACTORY.constructType(OneOfObjectStorageReferenceWrapper.class));
            }

            @Override
            protected void setDataObject(OneOfObjectStorageReferenceWrapper oneOfObject, Object nestedObject) {
                if (oneOfObject == null) {
                    throw new IllegalArgumentException("Instance of OneOfObjectStorageReferenceWrapper provided is null");
                }
                if (ONE_OF_TYPE0.getRawClass().isAssignableFrom(nestedObject.getClass())) {
                    oneOfObject.setValue(nestedObject);
                    if (oneOfObject.getValue() != null) {
                        return;
                    }
                }
                if (ONE_OF_TYPE1.getRawClass().isAssignableFrom(nestedObject.getClass())) {
                    oneOfObject.setValue(nestedObject);
                    if (oneOfObject.getValue() != null) {
                        return;
                    }
                }
                if (ONE_OF_TYPE2.getRawClass().isAssignableFrom(nestedObject.getClass())) {
                    oneOfObject.setValue(nestedObject);
                    if (oneOfObject.getValue() != null) {
                        return;
                    }
                }
                throw new IllegalArgumentException("Attempting to set unsupported object type in OneOfObjectStorageReferenceWrapper:" + nestedObject.getClass().getName());
            }

            @Override
            public String getPackagePrefix() {
                return "com.nutanix.dp1.dat";
            }
        }
    }
}

