/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.dat.dataprotection.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.dat.common.v1.response.ApiLink;
import com.nutanix.dp1.dat.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.dat.dataprotection.v4.common.DiskRecoveryPoint;
import com.nutanix.dp1.dat.deserializers.DatObjectTypeTypedObject;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VolumeGroupRecoveryPoint
extends ExternalizableAbstractModel
implements Serializable,
DatObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(VolumeGroupRecoveryPoint.class);
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    private @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String consistencyGroupExtId = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    private @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String locationAgnosticId = null;
    @Size(min=1, max=20)
    private @Size(min=1, max=20) List<String> volumeGroupCategories = null;
    @Size(min=1, max=1024)
    private @Size(min=1, max=1024) List<DiskRecoveryPoint> diskRecoveryPoints = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="volumeGroupExtId")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String volumeGroupExtId = null;

    public VolumeGroupRecoveryPoint() {
    }

    public VolumeGroupRecoveryPoint(String tenantId, String extId, List<ApiLink> links, String consistencyGroupExtId, String locationAgnosticId, String volumeGroupExtId, List<String> volumeGroupCategories, List<DiskRecoveryPoint> diskRecoveryPoints) {
        super(tenantId, extId, links);
        this.setConsistencyGroupExtId(consistencyGroupExtId);
        this.setLocationAgnosticId(locationAgnosticId);
        this.setVolumeGroupExtId(volumeGroupExtId);
        this.setVolumeGroupCategories(volumeGroupCategories);
        this.setDiskRecoveryPoints(diskRecoveryPoints);
    }

    @Override
    protected String initialize$objectType() {
        return "dataprotection.v4.config.VolumeGroupRecoveryPoint";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setConsistencyGroupExtId(String consistencyGroupExtId) {
        if (this.consistencyGroupExtId == null) {
            this.consistencyGroupExtId = consistencyGroupExtId;
        } else {
            log.warn("Read-only property consistencyGroupExtId already contains a non-null value and cannot be set again");
        }
    }

    public void setLocationAgnosticId(String locationAgnosticId) {
        if (this.locationAgnosticId == null) {
            this.locationAgnosticId = locationAgnosticId;
        } else {
            log.warn("Read-only property locationAgnosticId already contains a non-null value and cannot be set again");
        }
    }

    public void setVolumeGroupCategories(List<String> volumeGroupCategories) {
        if (this.volumeGroupCategories == null) {
            this.volumeGroupCategories = volumeGroupCategories;
        } else {
            log.warn("Read-only property volumeGroupCategories already contains a non-null value and cannot be set again");
        }
    }

    public void setDiskRecoveryPoints(List<DiskRecoveryPoint> diskRecoveryPoints) {
        if (this.diskRecoveryPoints == null) {
            this.diskRecoveryPoints = diskRecoveryPoints;
        } else {
            log.warn("Read-only property diskRecoveryPoints already contains a non-null value and cannot be set again");
        }
    }

    public static VolumeGroupRecoveryPointBuilder VolumeGroupRecoveryPointBuilder() {
        return new VolumeGroupRecoveryPointBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VolumeGroupRecoveryPoint)) {
            return false;
        }
        VolumeGroupRecoveryPoint other = (VolumeGroupRecoveryPoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$consistencyGroupExtId = this.getConsistencyGroupExtId();
        String other$consistencyGroupExtId = other.getConsistencyGroupExtId();
        if (this$consistencyGroupExtId == null ? other$consistencyGroupExtId != null : !this$consistencyGroupExtId.equals(other$consistencyGroupExtId)) {
            return false;
        }
        String this$locationAgnosticId = this.getLocationAgnosticId();
        String other$locationAgnosticId = other.getLocationAgnosticId();
        if (this$locationAgnosticId == null ? other$locationAgnosticId != null : !this$locationAgnosticId.equals(other$locationAgnosticId)) {
            return false;
        }
        List<String> this$volumeGroupCategories = this.getVolumeGroupCategories();
        List<String> other$volumeGroupCategories = other.getVolumeGroupCategories();
        if (this$volumeGroupCategories == null ? other$volumeGroupCategories != null : !((Object)this$volumeGroupCategories).equals(other$volumeGroupCategories)) {
            return false;
        }
        List<DiskRecoveryPoint> this$diskRecoveryPoints = this.getDiskRecoveryPoints();
        List<DiskRecoveryPoint> other$diskRecoveryPoints = other.getDiskRecoveryPoints();
        if (this$diskRecoveryPoints == null ? other$diskRecoveryPoints != null : !((Object)this$diskRecoveryPoints).equals(other$diskRecoveryPoints)) {
            return false;
        }
        String this$volumeGroupExtId = this.getVolumeGroupExtId();
        String other$volumeGroupExtId = other.getVolumeGroupExtId();
        return !(this$volumeGroupExtId == null ? other$volumeGroupExtId != null : !this$volumeGroupExtId.equals(other$volumeGroupExtId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof VolumeGroupRecoveryPoint;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $consistencyGroupExtId = this.getConsistencyGroupExtId();
        result = result * 59 + ($consistencyGroupExtId == null ? 43 : $consistencyGroupExtId.hashCode());
        String $locationAgnosticId = this.getLocationAgnosticId();
        result = result * 59 + ($locationAgnosticId == null ? 43 : $locationAgnosticId.hashCode());
        List<String> $volumeGroupCategories = this.getVolumeGroupCategories();
        result = result * 59 + ($volumeGroupCategories == null ? 43 : ((Object)$volumeGroupCategories).hashCode());
        List<DiskRecoveryPoint> $diskRecoveryPoints = this.getDiskRecoveryPoints();
        result = result * 59 + ($diskRecoveryPoints == null ? 43 : ((Object)$diskRecoveryPoints).hashCode());
        String $volumeGroupExtId = this.getVolumeGroupExtId();
        result = result * 59 + ($volumeGroupExtId == null ? 43 : $volumeGroupExtId.hashCode());
        return result;
    }

    public String getConsistencyGroupExtId() {
        return this.consistencyGroupExtId;
    }

    public String getLocationAgnosticId() {
        return this.locationAgnosticId;
    }

    public List<String> getVolumeGroupCategories() {
        return this.volumeGroupCategories;
    }

    public List<DiskRecoveryPoint> getDiskRecoveryPoints() {
        return this.diskRecoveryPoints;
    }

    public String getVolumeGroupExtId() {
        return this.volumeGroupExtId;
    }

    @JsonProperty(value="volumeGroupExtId")
    public void setVolumeGroupExtId(String volumeGroupExtId) {
        this.volumeGroupExtId = volumeGroupExtId;
    }

    @Override
    public String toString() {
        return "VolumeGroupRecoveryPoint(consistencyGroupExtId=" + this.getConsistencyGroupExtId() + ", locationAgnosticId=" + this.getLocationAgnosticId() + ", volumeGroupCategories=" + this.getVolumeGroupCategories() + ", diskRecoveryPoints=" + this.getDiskRecoveryPoints() + ", volumeGroupExtId=" + this.getVolumeGroupExtId() + ")";
    }

    public static class VolumeGroupRecoveryPointBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String consistencyGroupExtId;
        private String locationAgnosticId;
        private String volumeGroupExtId;
        private List<String> volumeGroupCategories;
        private List<DiskRecoveryPoint> diskRecoveryPoints;

        VolumeGroupRecoveryPointBuilder() {
        }

        public VolumeGroupRecoveryPointBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public VolumeGroupRecoveryPointBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public VolumeGroupRecoveryPointBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public VolumeGroupRecoveryPointBuilder consistencyGroupExtId(String consistencyGroupExtId) {
            this.consistencyGroupExtId = consistencyGroupExtId;
            return this;
        }

        public VolumeGroupRecoveryPointBuilder locationAgnosticId(String locationAgnosticId) {
            this.locationAgnosticId = locationAgnosticId;
            return this;
        }

        public VolumeGroupRecoveryPointBuilder volumeGroupExtId(String volumeGroupExtId) {
            this.volumeGroupExtId = volumeGroupExtId;
            return this;
        }

        public VolumeGroupRecoveryPointBuilder volumeGroupCategories(List<String> volumeGroupCategories) {
            this.volumeGroupCategories = volumeGroupCategories;
            return this;
        }

        public VolumeGroupRecoveryPointBuilder diskRecoveryPoints(List<DiskRecoveryPoint> diskRecoveryPoints) {
            this.diskRecoveryPoints = diskRecoveryPoints;
            return this;
        }

        public VolumeGroupRecoveryPoint build() {
            return new VolumeGroupRecoveryPoint(this.tenantId, this.extId, this.links, this.consistencyGroupExtId, this.locationAgnosticId, this.volumeGroupExtId, this.volumeGroupCategories, this.diskRecoveryPoints);
        }

        public String toString() {
            return "VolumeGroupRecoveryPoint.VolumeGroupRecoveryPointBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", consistencyGroupExtId=" + this.consistencyGroupExtId + ", locationAgnosticId=" + this.locationAgnosticId + ", volumeGroupExtId=" + this.volumeGroupExtId + ", volumeGroupCategories=" + this.volumeGroupCategories + ", diskRecoveryPoints=" + this.diskRecoveryPoints + ")";
        }
    }
}

