/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.dat.dataprotection.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.dat.common.v1.response.ApiLink;
import com.nutanix.dp1.dat.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.dat.dataprotection.v4.config.HostReference;
import com.nutanix.dp1.dat.dataprotection.v4.config.WitnessAvailabilityStatus;
import com.nutanix.dp1.dat.deserializers.DatObjectTypeTypedObject;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Witness
extends ExternalizableAbstractModel
implements Serializable,
DatObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(Witness.class);
    @Size(max=256)
    @JsonProperty(value="name")
    public @Size(max=256) String name = null;
    @Size(min=1, max=100)
    @JsonProperty(value="hostReferences")
    public @Size(min=1, max=100) List<HostReference> hostReferences = null;
    @Size(min=1, max=100)
    @JsonProperty(value="ipAddresses")
    public @Size(min=1, max=100) List<String> ipAddresses = null;
    @JsonProperty(value="status")
    public WitnessAvailabilityStatus status = null;

    public Witness() {
    }

    public Witness(String tenantId, String extId, List<ApiLink> links, String name, List<HostReference> hostReferences, List<String> ipAddresses, WitnessAvailabilityStatus status) {
        super(tenantId, extId, links);
        this.setName(name);
        this.setHostReferences(hostReferences);
        this.setIpAddresses(ipAddresses);
        this.setStatus(status);
    }

    @Override
    protected String initialize$objectType() {
        return "dataprotection.v4.config.Witness";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public static WitnessBuilder WitnessBuilder() {
        return new WitnessBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Witness)) {
            return false;
        }
        Witness other = (Witness)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<HostReference> this$hostReferences = this.getHostReferences();
        List<HostReference> other$hostReferences = other.getHostReferences();
        if (this$hostReferences == null ? other$hostReferences != null : !((Object)this$hostReferences).equals(other$hostReferences)) {
            return false;
        }
        List<String> this$ipAddresses = this.getIpAddresses();
        List<String> other$ipAddresses = other.getIpAddresses();
        if (this$ipAddresses == null ? other$ipAddresses != null : !((Object)this$ipAddresses).equals(other$ipAddresses)) {
            return false;
        }
        WitnessAvailabilityStatus this$status = this.getStatus();
        WitnessAvailabilityStatus other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Witness;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<HostReference> $hostReferences = this.getHostReferences();
        result = result * 59 + ($hostReferences == null ? 43 : ((Object)$hostReferences).hashCode());
        List<String> $ipAddresses = this.getIpAddresses();
        result = result * 59 + ($ipAddresses == null ? 43 : ((Object)$ipAddresses).hashCode());
        WitnessAvailabilityStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        return result;
    }

    public String getName() {
        return this.name;
    }

    public List<HostReference> getHostReferences() {
        return this.hostReferences;
    }

    public List<String> getIpAddresses() {
        return this.ipAddresses;
    }

    public WitnessAvailabilityStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="hostReferences")
    public void setHostReferences(List<HostReference> hostReferences) {
        this.hostReferences = hostReferences;
    }

    @JsonProperty(value="ipAddresses")
    public void setIpAddresses(List<String> ipAddresses) {
        this.ipAddresses = ipAddresses;
    }

    @JsonProperty(value="status")
    public void setStatus(WitnessAvailabilityStatus status) {
        this.status = status;
    }

    @Override
    public String toString() {
        return "Witness(name=" + this.getName() + ", hostReferences=" + this.getHostReferences() + ", ipAddresses=" + this.getIpAddresses() + ", status=" + (Object)((Object)this.getStatus()) + ")";
    }

    public static class WitnessBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String name;
        private List<HostReference> hostReferences;
        private List<String> ipAddresses;
        private WitnessAvailabilityStatus status;

        WitnessBuilder() {
        }

        public WitnessBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public WitnessBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public WitnessBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public WitnessBuilder name(String name) {
            this.name = name;
            return this;
        }

        public WitnessBuilder hostReferences(List<HostReference> hostReferences) {
            this.hostReferences = hostReferences;
            return this;
        }

        public WitnessBuilder ipAddresses(List<String> ipAddresses) {
            this.ipAddresses = ipAddresses;
            return this;
        }

        public WitnessBuilder status(WitnessAvailabilityStatus status) {
            this.status = status;
            return this;
        }

        public Witness build() {
            return new Witness(this.tenantId, this.extId, this.links, this.name, this.hostReferences, this.ipAddresses, this.status);
        }

        public String toString() {
            return "Witness.WitnessBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", name=" + this.name + ", hostReferences=" + this.hostReferences + ", ipAddresses=" + this.ipAddresses + ", status=" + (Object)((Object)this.status) + ")";
        }
    }
}

