/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.dat.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.nutanix.dp1.dat.deserializers.DatDeserializerUtils;
import com.nutanix.dp1.dat.deserializers.DatObjectTypeTypedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatObjectTypeTypedObjectDeserializer
extends StdDeserializer<DatObjectTypeTypedObject> {
    private static final Logger log = LoggerFactory.getLogger(DatObjectTypeTypedObjectDeserializer.class);
    private final String packagePrefix = "com.nutanix.dp1.dat";

    public DatObjectTypeTypedObjectDeserializer() {
        super(DatObjectTypeTypedObject.class);
    }

    public DatObjectTypeTypedObject deserialize(JsonParser p, DeserializationContext ctxt) {
        ObjectCodec codec = p.getCodec();
        JsonNode targetNode = (JsonNode)codec.readTree(p);
        Class<?> clazz = DatDeserializerUtils.getObjectTypedType(targetNode, this.packagePrefix);
        log.debug("Deserializing json node into instance of {}", clazz);
        return (DatObjectTypeTypedObject)DatDeserializerUtils.readValue(codec, targetNode, clazz);
    }
}

