/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dat.java.client.api;

import com.nutanix.dat.java.client.ApiClient;
import com.nutanix.dp1.dat.dataprotection.v4.config.GetProtectedResourceApiResponse;
import com.nutanix.dp1.dat.dataprotection.v4.config.ProtectedResourcePromoteApiResponse;
import com.nutanix.dp1.dat.dataprotection.v4.config.ProtectedResourceRestoreApiResponse;
import com.nutanix.dp1.dat.dataprotection.v4.config.ProtectedResourceRestoreSpec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.util.UriComponentsBuilder;

@Component(value="com.nutanix.dat.java.client.api.ProtectedResourcesApi")
public class ProtectedResourcesApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProtectedResourcesApi.class);
    private ApiClient apiClient;
    private final Set<String> headersToSkip;

    public ProtectedResourcesApi() {
        this(new ApiClient());
    }

    @Autowired
    public ProtectedResourcesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.headersToSkip = new HashSet<String>(Arrays.asList("authorization", "cookie", "host", "user-agent"));
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public GetProtectedResourceApiResponse getProtectedResourceById(String extId, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        Object postBody = null;
        if (extId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extId' when calling getProtectedResourceById");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("extId", extId);
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/dataprotection/v4.2/config/protected-resources/{extId}").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<GetProtectedResourceApiResponse> returnType = new ParameterizedTypeReference<GetProtectedResourceApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.GET, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public ProtectedResourcePromoteApiResponse promoteProtectedResource(String extId, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        Object postBody = null;
        if (extId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extId' when calling promoteProtectedResource");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("extId", extId);
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/dataprotection/v4.2/config/protected-resources/{extId}/$actions/promote").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<ProtectedResourcePromoteApiResponse> returnType = new ParameterizedTypeReference<ProtectedResourcePromoteApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public ProtectedResourceRestoreApiResponse restoreProtectedResource(String extId, ProtectedResourceRestoreSpec body, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        ProtectedResourceRestoreSpec postBody = body;
        if (extId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extId' when calling restoreProtectedResource");
        }
        if (body == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling restoreProtectedResource");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("extId", extId);
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/dataprotection/v4.2/config/protected-resources/{extId}/$actions/restore").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<ProtectedResourceRestoreApiResponse> returnType = new ParameterizedTypeReference<ProtectedResourceRestoreApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }
}

