/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.dat.dataprotection.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.dat.common.v1.response.ApiLink;
import com.nutanix.dp1.dat.dataprotection.v4.common.BaseRecoveryPoint;
import com.nutanix.dp1.dat.dataprotection.v4.common.RecoveryPointStatus;
import com.nutanix.dp1.dat.dataprotection.v4.common.RecoveryPointType;
import com.nutanix.dp1.dat.dataprotection.v4.config.DisasterRecoveryLocation;
import com.nutanix.dp1.dat.dataprotection.v4.config.LocationReference;
import com.nutanix.dp1.dat.dataprotection.v4.config.VmRecoveryPoint;
import com.nutanix.dp1.dat.dataprotection.v4.config.VolumeGroupRecoveryPoint;
import com.nutanix.dp1.dat.deserializers.DatObjectTypeTypedObject;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveryPoint
extends BaseRecoveryPoint
implements Serializable,
DatObjectTypeTypedObject {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RecoveryPoint.class);
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    private @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String ownerExtId = null;
    @Size(min=1, max=1)
    private @Size(min=1, max=1) List<LocationReference> locationReferences = null;
    private Boolean isSecure = null;
    @Size(min=1, max=32)
    @JsonProperty(value="vmRecoveryPoints")
    public @Size(min=1, max=32) List<VmRecoveryPoint> vmRecoveryPoints = null;
    @Size(min=1, max=32)
    @JsonProperty(value="volumeGroupRecoveryPoints")
    public @Size(min=1, max=32) List<VolumeGroupRecoveryPoint> volumeGroupRecoveryPoints = null;
    @JsonProperty(value="sourceLocation")
    public DisasterRecoveryLocation sourceLocation = null;

    public RecoveryPoint() {
    }

    public RecoveryPoint(String tenantId, String extId, List<ApiLink> links, String locationAgnosticId, String name, OffsetDateTime creationTime, OffsetDateTime expirationTime, RecoveryPointStatus status, RecoveryPointType recoveryPointType, Long totalExclusiveUsageBytes, String ownerExtId, List<LocationReference> locationReferences, List<VmRecoveryPoint> vmRecoveryPoints, List<VolumeGroupRecoveryPoint> volumeGroupRecoveryPoints, Boolean isSecure, DisasterRecoveryLocation sourceLocation) {
        super(tenantId, extId, links, locationAgnosticId, name, creationTime, expirationTime, status, recoveryPointType, totalExclusiveUsageBytes);
        this.setOwnerExtId(ownerExtId);
        this.setLocationReferences(locationReferences);
        this.setVmRecoveryPoints(vmRecoveryPoints);
        this.setVolumeGroupRecoveryPoints(volumeGroupRecoveryPoints);
        this.setIsSecure(isSecure);
        this.setSourceLocation(sourceLocation);
    }

    @Override
    protected String initialize$objectType() {
        return "dataprotection.v4.config.RecoveryPoint";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r2";
    }

    public void setOwnerExtId(String ownerExtId) {
        if (this.ownerExtId == null) {
            this.ownerExtId = ownerExtId;
        } else {
            log.warn("Read-only property ownerExtId already contains a non-null value and cannot be set again");
        }
    }

    public void setLocationReferences(List<LocationReference> locationReferences) {
        if (this.locationReferences == null) {
            this.locationReferences = locationReferences;
        } else {
            log.warn("Read-only property locationReferences already contains a non-null value and cannot be set again");
        }
    }

    public void setIsSecure(Boolean isSecure) {
        if (this.isSecure == null) {
            this.isSecure = isSecure;
        } else {
            log.warn("Read-only property isSecure already contains a non-null value and cannot be set again");
        }
    }

    @Generated
    public static RecoveryPointBuilder RecoveryPointBuilder() {
        return new RecoveryPointBuilder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecoveryPoint)) {
            return false;
        }
        RecoveryPoint other = (RecoveryPoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isSecure = this.getIsSecure();
        Boolean other$isSecure = other.getIsSecure();
        if (this$isSecure == null ? other$isSecure != null : !((Object)this$isSecure).equals(other$isSecure)) {
            return false;
        }
        String this$ownerExtId = this.getOwnerExtId();
        String other$ownerExtId = other.getOwnerExtId();
        if (this$ownerExtId == null ? other$ownerExtId != null : !this$ownerExtId.equals(other$ownerExtId)) {
            return false;
        }
        List<LocationReference> this$locationReferences = this.getLocationReferences();
        List<LocationReference> other$locationReferences = other.getLocationReferences();
        if (this$locationReferences == null ? other$locationReferences != null : !((Object)this$locationReferences).equals(other$locationReferences)) {
            return false;
        }
        List<VmRecoveryPoint> this$vmRecoveryPoints = this.getVmRecoveryPoints();
        List<VmRecoveryPoint> other$vmRecoveryPoints = other.getVmRecoveryPoints();
        if (this$vmRecoveryPoints == null ? other$vmRecoveryPoints != null : !((Object)this$vmRecoveryPoints).equals(other$vmRecoveryPoints)) {
            return false;
        }
        List<VolumeGroupRecoveryPoint> this$volumeGroupRecoveryPoints = this.getVolumeGroupRecoveryPoints();
        List<VolumeGroupRecoveryPoint> other$volumeGroupRecoveryPoints = other.getVolumeGroupRecoveryPoints();
        if (this$volumeGroupRecoveryPoints == null ? other$volumeGroupRecoveryPoints != null : !((Object)this$volumeGroupRecoveryPoints).equals(other$volumeGroupRecoveryPoints)) {
            return false;
        }
        DisasterRecoveryLocation this$sourceLocation = this.getSourceLocation();
        DisasterRecoveryLocation other$sourceLocation = other.getSourceLocation();
        return !(this$sourceLocation == null ? other$sourceLocation != null : !((Object)this$sourceLocation).equals(other$sourceLocation));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RecoveryPoint;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isSecure = this.getIsSecure();
        result = result * 59 + ($isSecure == null ? 43 : ((Object)$isSecure).hashCode());
        String $ownerExtId = this.getOwnerExtId();
        result = result * 59 + ($ownerExtId == null ? 43 : $ownerExtId.hashCode());
        List<LocationReference> $locationReferences = this.getLocationReferences();
        result = result * 59 + ($locationReferences == null ? 43 : ((Object)$locationReferences).hashCode());
        List<VmRecoveryPoint> $vmRecoveryPoints = this.getVmRecoveryPoints();
        result = result * 59 + ($vmRecoveryPoints == null ? 43 : ((Object)$vmRecoveryPoints).hashCode());
        List<VolumeGroupRecoveryPoint> $volumeGroupRecoveryPoints = this.getVolumeGroupRecoveryPoints();
        result = result * 59 + ($volumeGroupRecoveryPoints == null ? 43 : ((Object)$volumeGroupRecoveryPoints).hashCode());
        DisasterRecoveryLocation $sourceLocation = this.getSourceLocation();
        result = result * 59 + ($sourceLocation == null ? 43 : ((Object)$sourceLocation).hashCode());
        return result;
    }

    @Generated
    public String getOwnerExtId() {
        return this.ownerExtId;
    }

    @Generated
    public List<LocationReference> getLocationReferences() {
        return this.locationReferences;
    }

    @Generated
    public Boolean getIsSecure() {
        return this.isSecure;
    }

    @Generated
    public List<VmRecoveryPoint> getVmRecoveryPoints() {
        return this.vmRecoveryPoints;
    }

    @Generated
    public List<VolumeGroupRecoveryPoint> getVolumeGroupRecoveryPoints() {
        return this.volumeGroupRecoveryPoints;
    }

    @Generated
    public DisasterRecoveryLocation getSourceLocation() {
        return this.sourceLocation;
    }

    @JsonProperty(value="vmRecoveryPoints")
    @Generated
    public void setVmRecoveryPoints(List<VmRecoveryPoint> vmRecoveryPoints) {
        this.vmRecoveryPoints = vmRecoveryPoints;
    }

    @JsonProperty(value="volumeGroupRecoveryPoints")
    @Generated
    public void setVolumeGroupRecoveryPoints(List<VolumeGroupRecoveryPoint> volumeGroupRecoveryPoints) {
        this.volumeGroupRecoveryPoints = volumeGroupRecoveryPoints;
    }

    @JsonProperty(value="sourceLocation")
    @Generated
    public void setSourceLocation(DisasterRecoveryLocation sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    @Override
    @Generated
    public String toString() {
        return "RecoveryPoint(ownerExtId=" + this.getOwnerExtId() + ", locationReferences=" + this.getLocationReferences() + ", isSecure=" + this.getIsSecure() + ", vmRecoveryPoints=" + this.getVmRecoveryPoints() + ", volumeGroupRecoveryPoints=" + this.getVolumeGroupRecoveryPoints() + ", sourceLocation=" + this.getSourceLocation() + ")";
    }

    public static class RecoveryPointBuilder {
        @Generated
        private String tenantId;
        @Generated
        private String extId;
        @Generated
        private List<ApiLink> links;
        @Generated
        private String locationAgnosticId;
        @Generated
        private String name;
        @Generated
        private OffsetDateTime creationTime;
        @Generated
        private OffsetDateTime expirationTime;
        @Generated
        private RecoveryPointStatus status;
        @Generated
        private RecoveryPointType recoveryPointType;
        @Generated
        private Long totalExclusiveUsageBytes;
        @Generated
        private String ownerExtId;
        @Generated
        private List<LocationReference> locationReferences;
        @Generated
        private List<VmRecoveryPoint> vmRecoveryPoints;
        @Generated
        private List<VolumeGroupRecoveryPoint> volumeGroupRecoveryPoints;
        @Generated
        private Boolean isSecure;
        @Generated
        private DisasterRecoveryLocation sourceLocation;
        protected final Map<String, Object> $reserved = new LinkedHashMap<String, Object>();

        public RecoveryPointBuilder addToReservedMap(String key, Object value) {
            this.$reserved.put(key, value);
            return this;
        }

        public RecoveryPoint build() {
            RecoveryPoint obj = new RecoveryPoint(this.tenantId, this.extId, this.links, this.locationAgnosticId, this.name, this.creationTime, this.expirationTime, this.status, this.recoveryPointType, this.totalExclusiveUsageBytes, this.ownerExtId, this.locationReferences, this.vmRecoveryPoints, this.volumeGroupRecoveryPoints, this.isSecure, this.sourceLocation);
            obj.$reserved.putAll(this.$reserved);
            return obj;
        }

        @Generated
        RecoveryPointBuilder() {
        }

        @Generated
        public RecoveryPointBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public RecoveryPointBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        @Generated
        public RecoveryPointBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        @Generated
        public RecoveryPointBuilder locationAgnosticId(String locationAgnosticId) {
            this.locationAgnosticId = locationAgnosticId;
            return this;
        }

        @Generated
        public RecoveryPointBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public RecoveryPointBuilder creationTime(OffsetDateTime creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Generated
        public RecoveryPointBuilder expirationTime(OffsetDateTime expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        @Generated
        public RecoveryPointBuilder status(RecoveryPointStatus status) {
            this.status = status;
            return this;
        }

        @Generated
        public RecoveryPointBuilder recoveryPointType(RecoveryPointType recoveryPointType) {
            this.recoveryPointType = recoveryPointType;
            return this;
        }

        @Generated
        public RecoveryPointBuilder totalExclusiveUsageBytes(Long totalExclusiveUsageBytes) {
            this.totalExclusiveUsageBytes = totalExclusiveUsageBytes;
            return this;
        }

        @Generated
        public RecoveryPointBuilder ownerExtId(String ownerExtId) {
            this.ownerExtId = ownerExtId;
            return this;
        }

        @Generated
        public RecoveryPointBuilder locationReferences(List<LocationReference> locationReferences) {
            this.locationReferences = locationReferences;
            return this;
        }

        @Generated
        public RecoveryPointBuilder vmRecoveryPoints(List<VmRecoveryPoint> vmRecoveryPoints) {
            this.vmRecoveryPoints = vmRecoveryPoints;
            return this;
        }

        @Generated
        public RecoveryPointBuilder volumeGroupRecoveryPoints(List<VolumeGroupRecoveryPoint> volumeGroupRecoveryPoints) {
            this.volumeGroupRecoveryPoints = volumeGroupRecoveryPoints;
            return this;
        }

        @Generated
        public RecoveryPointBuilder isSecure(Boolean isSecure) {
            this.isSecure = isSecure;
            return this;
        }

        @Generated
        public RecoveryPointBuilder sourceLocation(DisasterRecoveryLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        @Generated
        public String toString() {
            return "RecoveryPoint.RecoveryPointBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", locationAgnosticId=" + this.locationAgnosticId + ", name=" + this.name + ", creationTime=" + this.creationTime + ", expirationTime=" + this.expirationTime + ", status=" + (Object)((Object)this.status) + ", recoveryPointType=" + (Object)((Object)this.recoveryPointType) + ", totalExclusiveUsageBytes=" + this.totalExclusiveUsageBytes + ", ownerExtId=" + this.ownerExtId + ", locationReferences=" + this.locationReferences + ", vmRecoveryPoints=" + this.vmRecoveryPoints + ", volumeGroupRecoveryPoints=" + this.volumeGroupRecoveryPoints + ", isSecure=" + this.isSecure + ", sourceLocation=" + this.sourceLocation + ")";
        }
    }
}

