/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.dat.dataprotection.v4.config;

import com.nutanix.dp1.dat.common.v1.response.ApiLink;
import com.nutanix.dp1.dat.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.dat.deserializers.DatObjectTypeTypedObject;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecycleBinEntry
extends ExternalizableAbstractModel
implements Serializable,
DatObjectTypeTypedObject {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RecycleBinEntry.class);
    private OffsetDateTime expirationTime = null;
    private OffsetDateTime deletionTime = null;
    private Long spaceConsumedBytes = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    private @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String deletedByUserExtId = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    private @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String clusterExtId = null;
    private List<String> categoryIds = null;

    public RecycleBinEntry() {
    }

    public RecycleBinEntry(String tenantId, String extId, List<ApiLink> links, OffsetDateTime expirationTime, OffsetDateTime deletionTime, Long spaceConsumedBytes, String deletedByUserExtId, String clusterExtId, List<String> categoryIds) {
        super(tenantId, extId, links);
        this.setExpirationTime(expirationTime);
        this.setDeletionTime(deletionTime);
        this.setSpaceConsumedBytes(spaceConsumedBytes);
        this.setDeletedByUserExtId(deletedByUserExtId);
        this.setClusterExtId(clusterExtId);
        this.setCategoryIds(categoryIds);
    }

    @Override
    protected String initialize$objectType() {
        return "dataprotection.v4.config.RecycleBinEntry";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r2";
    }

    public void setExpirationTime(OffsetDateTime expirationTime) {
        if (this.expirationTime == null) {
            this.expirationTime = expirationTime;
        } else {
            log.warn("Read-only property expirationTime already contains a non-null value and cannot be set again");
        }
    }

    public void setDeletionTime(OffsetDateTime deletionTime) {
        if (this.deletionTime == null) {
            this.deletionTime = deletionTime;
        } else {
            log.warn("Read-only property deletionTime already contains a non-null value and cannot be set again");
        }
    }

    public void setSpaceConsumedBytes(Long spaceConsumedBytes) {
        if (this.spaceConsumedBytes == null) {
            this.spaceConsumedBytes = spaceConsumedBytes;
        } else {
            log.warn("Read-only property spaceConsumedBytes already contains a non-null value and cannot be set again");
        }
    }

    public void setDeletedByUserExtId(String deletedByUserExtId) {
        if (this.deletedByUserExtId == null) {
            this.deletedByUserExtId = deletedByUserExtId;
        } else {
            log.warn("Read-only property deletedByUserExtId already contains a non-null value and cannot be set again");
        }
    }

    public void setClusterExtId(String clusterExtId) {
        if (this.clusterExtId == null) {
            this.clusterExtId = clusterExtId;
        } else {
            log.warn("Read-only property clusterExtId already contains a non-null value and cannot be set again");
        }
    }

    public void setCategoryIds(List<String> categoryIds) {
        if (this.categoryIds == null) {
            this.categoryIds = categoryIds;
        } else {
            log.warn("Read-only property categoryIds already contains a non-null value and cannot be set again");
        }
    }

    @Generated
    public static RecycleBinEntryBuilder RecycleBinEntryBuilder() {
        return new RecycleBinEntryBuilder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecycleBinEntry)) {
            return false;
        }
        RecycleBinEntry other = (RecycleBinEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$spaceConsumedBytes = this.getSpaceConsumedBytes();
        Long other$spaceConsumedBytes = other.getSpaceConsumedBytes();
        if (this$spaceConsumedBytes == null ? other$spaceConsumedBytes != null : !((Object)this$spaceConsumedBytes).equals(other$spaceConsumedBytes)) {
            return false;
        }
        OffsetDateTime this$expirationTime = this.getExpirationTime();
        OffsetDateTime other$expirationTime = other.getExpirationTime();
        if (this$expirationTime == null ? other$expirationTime != null : !((Object)this$expirationTime).equals(other$expirationTime)) {
            return false;
        }
        OffsetDateTime this$deletionTime = this.getDeletionTime();
        OffsetDateTime other$deletionTime = other.getDeletionTime();
        if (this$deletionTime == null ? other$deletionTime != null : !((Object)this$deletionTime).equals(other$deletionTime)) {
            return false;
        }
        String this$deletedByUserExtId = this.getDeletedByUserExtId();
        String other$deletedByUserExtId = other.getDeletedByUserExtId();
        if (this$deletedByUserExtId == null ? other$deletedByUserExtId != null : !this$deletedByUserExtId.equals(other$deletedByUserExtId)) {
            return false;
        }
        String this$clusterExtId = this.getClusterExtId();
        String other$clusterExtId = other.getClusterExtId();
        if (this$clusterExtId == null ? other$clusterExtId != null : !this$clusterExtId.equals(other$clusterExtId)) {
            return false;
        }
        List<String> this$categoryIds = this.getCategoryIds();
        List<String> other$categoryIds = other.getCategoryIds();
        return !(this$categoryIds == null ? other$categoryIds != null : !((Object)this$categoryIds).equals(other$categoryIds));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RecycleBinEntry;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $spaceConsumedBytes = this.getSpaceConsumedBytes();
        result = result * 59 + ($spaceConsumedBytes == null ? 43 : ((Object)$spaceConsumedBytes).hashCode());
        OffsetDateTime $expirationTime = this.getExpirationTime();
        result = result * 59 + ($expirationTime == null ? 43 : ((Object)$expirationTime).hashCode());
        OffsetDateTime $deletionTime = this.getDeletionTime();
        result = result * 59 + ($deletionTime == null ? 43 : ((Object)$deletionTime).hashCode());
        String $deletedByUserExtId = this.getDeletedByUserExtId();
        result = result * 59 + ($deletedByUserExtId == null ? 43 : $deletedByUserExtId.hashCode());
        String $clusterExtId = this.getClusterExtId();
        result = result * 59 + ($clusterExtId == null ? 43 : $clusterExtId.hashCode());
        List<String> $categoryIds = this.getCategoryIds();
        result = result * 59 + ($categoryIds == null ? 43 : ((Object)$categoryIds).hashCode());
        return result;
    }

    @Generated
    public OffsetDateTime getExpirationTime() {
        return this.expirationTime;
    }

    @Generated
    public OffsetDateTime getDeletionTime() {
        return this.deletionTime;
    }

    @Generated
    public Long getSpaceConsumedBytes() {
        return this.spaceConsumedBytes;
    }

    @Generated
    public String getDeletedByUserExtId() {
        return this.deletedByUserExtId;
    }

    @Generated
    public String getClusterExtId() {
        return this.clusterExtId;
    }

    @Generated
    public List<String> getCategoryIds() {
        return this.categoryIds;
    }

    @Override
    @Generated
    public String toString() {
        return "RecycleBinEntry(expirationTime=" + this.getExpirationTime() + ", deletionTime=" + this.getDeletionTime() + ", spaceConsumedBytes=" + this.getSpaceConsumedBytes() + ", deletedByUserExtId=" + this.getDeletedByUserExtId() + ", clusterExtId=" + this.getClusterExtId() + ", categoryIds=" + this.getCategoryIds() + ")";
    }

    public static class RecycleBinEntryBuilder {
        @Generated
        private String tenantId;
        @Generated
        private String extId;
        @Generated
        private List<ApiLink> links;
        @Generated
        private OffsetDateTime expirationTime;
        @Generated
        private OffsetDateTime deletionTime;
        @Generated
        private Long spaceConsumedBytes;
        @Generated
        private String deletedByUserExtId;
        @Generated
        private String clusterExtId;
        @Generated
        private List<String> categoryIds;
        protected final Map<String, Object> $reserved = new LinkedHashMap<String, Object>();

        public RecycleBinEntryBuilder addToReservedMap(String key, Object value) {
            this.$reserved.put(key, value);
            return this;
        }

        public RecycleBinEntry build() {
            RecycleBinEntry obj = new RecycleBinEntry(this.tenantId, this.extId, this.links, this.expirationTime, this.deletionTime, this.spaceConsumedBytes, this.deletedByUserExtId, this.clusterExtId, this.categoryIds);
            obj.$reserved.putAll(this.$reserved);
            return obj;
        }

        @Generated
        RecycleBinEntryBuilder() {
        }

        @Generated
        public RecycleBinEntryBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public RecycleBinEntryBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        @Generated
        public RecycleBinEntryBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        @Generated
        public RecycleBinEntryBuilder expirationTime(OffsetDateTime expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        @Generated
        public RecycleBinEntryBuilder deletionTime(OffsetDateTime deletionTime) {
            this.deletionTime = deletionTime;
            return this;
        }

        @Generated
        public RecycleBinEntryBuilder spaceConsumedBytes(Long spaceConsumedBytes) {
            this.spaceConsumedBytes = spaceConsumedBytes;
            return this;
        }

        @Generated
        public RecycleBinEntryBuilder deletedByUserExtId(String deletedByUserExtId) {
            this.deletedByUserExtId = deletedByUserExtId;
            return this;
        }

        @Generated
        public RecycleBinEntryBuilder clusterExtId(String clusterExtId) {
            this.clusterExtId = clusterExtId;
            return this;
        }

        @Generated
        public RecycleBinEntryBuilder categoryIds(List<String> categoryIds) {
            this.categoryIds = categoryIds;
            return this;
        }

        @Generated
        public String toString() {
            return "RecycleBinEntry.RecycleBinEntryBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", expirationTime=" + this.expirationTime + ", deletionTime=" + this.deletionTime + ", spaceConsumedBytes=" + this.spaceConsumedBytes + ", deletedByUserExtId=" + this.deletedByUserExtId + ", clusterExtId=" + this.clusterExtId + ", categoryIds=" + this.categoryIds + ")";
        }
    }
}

