/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.lic.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.nutanix.dp1.lic.deserializers.LicDeserializerUtils;
import com.nutanix.dp1.lic.deserializers.LicObjectTypeTypedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicObjectTypeTypedObjectDeserializer
extends StdDeserializer<LicObjectTypeTypedObject> {
    private static final Logger log = LoggerFactory.getLogger(LicObjectTypeTypedObjectDeserializer.class);
    private final String packagePrefix = "com.nutanix.dp1.lic";

    public LicObjectTypeTypedObjectDeserializer() {
        super(LicObjectTypeTypedObject.class);
    }

    public LicObjectTypeTypedObject deserialize(JsonParser p, DeserializationContext ctxt) {
        ObjectCodec codec = p.getCodec();
        JsonNode targetNode = (JsonNode)codec.readTree(p);
        Class<?> clazz = LicDeserializerUtils.getObjectTypedType(targetNode, this.packagePrefix);
        log.debug("Deserializing json node into instance of {}", clazz);
        return (LicObjectTypeTypedObject)LicDeserializerUtils.readValue(codec, targetNode, clazz);
    }
}

