/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.lic.licensing.v4.agreements;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.lic.common.v1.response.ApiLink;
import com.nutanix.dp1.lic.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.lic.deserializers.LicObjectTypeTypedObject;
import com.nutanix.dp1.lic.licensing.v4.agreements.Acceptance;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.List;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Eula
extends ExternalizableAbstractModel
implements Serializable,
LicObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(Eula.class);
    private String content = null;
    private OffsetDateTime updatedTime = null;
    private String version = null;
    @Size(min=0, max=100)
    private @Size(min=0, max=100) List<Acceptance> acceptances = null;
    @JsonProperty(value="isEnabled")
    public Boolean isEnabled = null;

    public Eula() {
    }

    public Eula(String tenantId, String extId, List<ApiLink> links, String content, OffsetDateTime updatedTime, String version, Boolean isEnabled, List<Acceptance> acceptances) {
        super(tenantId, extId, links);
        this.setContent(content);
        this.setUpdatedTime(updatedTime);
        this.setVersion(version);
        this.setIsEnabled(isEnabled);
        this.setAcceptances(acceptances);
    }

    @Override
    protected String initialize$objectType() {
        return "licensing.v4.agreements.Eula";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r1";
    }

    public void setContent(String content) {
        if (this.content == null) {
            this.content = content;
        } else {
            log.warn("Read-only property content already contains a non-null value and cannot be set again");
        }
    }

    public void setUpdatedTime(OffsetDateTime updatedTime) {
        if (this.updatedTime == null) {
            this.updatedTime = updatedTime;
        } else {
            log.warn("Read-only property updatedTime already contains a non-null value and cannot be set again");
        }
    }

    public void setVersion(String version) {
        if (this.version == null) {
            this.version = version;
        } else {
            log.warn("Read-only property version already contains a non-null value and cannot be set again");
        }
    }

    public void setAcceptances(List<Acceptance> acceptances) {
        if (this.acceptances == null) {
            this.acceptances = acceptances;
        } else {
            log.warn("Read-only property acceptances already contains a non-null value and cannot be set again");
        }
    }

    public static EulaBuilder EulaBuilder() {
        return new EulaBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Eula)) {
            return false;
        }
        Eula other = (Eula)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        OffsetDateTime this$updatedTime = this.getUpdatedTime();
        OffsetDateTime other$updatedTime = other.getUpdatedTime();
        if (this$updatedTime == null ? other$updatedTime != null : !((Object)this$updatedTime).equals(other$updatedTime)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        List<Acceptance> this$acceptances = this.getAcceptances();
        List<Acceptance> other$acceptances = other.getAcceptances();
        if (this$acceptances == null ? other$acceptances != null : !((Object)this$acceptances).equals(other$acceptances)) {
            return false;
        }
        Boolean this$isEnabled = this.getIsEnabled();
        Boolean other$isEnabled = other.getIsEnabled();
        return !(this$isEnabled == null ? other$isEnabled != null : !((Object)this$isEnabled).equals(other$isEnabled));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Eula;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        OffsetDateTime $updatedTime = this.getUpdatedTime();
        result = result * 59 + ($updatedTime == null ? 43 : ((Object)$updatedTime).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        List<Acceptance> $acceptances = this.getAcceptances();
        result = result * 59 + ($acceptances == null ? 43 : ((Object)$acceptances).hashCode());
        Boolean $isEnabled = this.getIsEnabled();
        result = result * 59 + ($isEnabled == null ? 43 : ((Object)$isEnabled).hashCode());
        return result;
    }

    public String getContent() {
        return this.content;
    }

    public OffsetDateTime getUpdatedTime() {
        return this.updatedTime;
    }

    public String getVersion() {
        return this.version;
    }

    public List<Acceptance> getAcceptances() {
        return this.acceptances;
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    @JsonProperty(value="isEnabled")
    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    @Override
    public String toString() {
        return "Eula(content=" + this.getContent() + ", updatedTime=" + this.getUpdatedTime() + ", version=" + this.getVersion() + ", acceptances=" + this.getAcceptances() + ", isEnabled=" + this.getIsEnabled() + ")";
    }

    public static class EulaBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String content;
        private OffsetDateTime updatedTime;
        private String version;
        private Boolean isEnabled;
        private List<Acceptance> acceptances;

        EulaBuilder() {
        }

        public EulaBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public EulaBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public EulaBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public EulaBuilder content(String content) {
            this.content = content;
            return this;
        }

        public EulaBuilder updatedTime(OffsetDateTime updatedTime) {
            this.updatedTime = updatedTime;
            return this;
        }

        public EulaBuilder version(String version) {
            this.version = version;
            return this;
        }

        public EulaBuilder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            return this;
        }

        public EulaBuilder acceptances(List<Acceptance> acceptances) {
            this.acceptances = acceptances;
            return this;
        }

        public Eula build() {
            return new Eula(this.tenantId, this.extId, this.links, this.content, this.updatedTime, this.version, this.isEnabled, this.acceptances);
        }

        public String toString() {
            return "Eula.EulaBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", content=" + this.content + ", updatedTime=" + this.updatedTime + ", version=" + this.version + ", isEnabled=" + this.isEnabled + ", acceptances=" + this.acceptances + ")";
        }
    }
}

