/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.lic.licensing.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.lic.common.v1.response.ApiLink;
import com.nutanix.dp1.lic.deserializers.LicObjectTypeTypedObject;
import com.nutanix.dp1.lic.licensing.v4.config.AllowanceDetail;
import com.nutanix.dp1.lic.licensing.v4.config.BaseClusterInfo;
import com.nutanix.dp1.lic.licensing.v4.config.ClusterType;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Allowance
extends BaseClusterInfo
implements Serializable,
LicObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(Allowance.class);
    @Size(max=100)
    @JsonProperty(value="name")
    public @Size(max=100) String name = null;
    @JsonProperty(value="type")
    public ClusterType type = null;
    @Size(min=0, max=120)
    @JsonProperty(value="details")
    public @Size(min=0, max=120) List<AllowanceDetail> details = null;

    public Allowance() {
    }

    public Allowance(String tenantId, String extId, List<ApiLink> links, Boolean isMulticluster, String name, ClusterType type, List<AllowanceDetail> details) {
        super(tenantId, extId, links, isMulticluster);
        this.setName(name);
        this.setType(type);
        this.setDetails(details);
    }

    @Override
    protected String initialize$objectType() {
        return "licensing.v4.config.Allowance";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r1";
    }

    public static AllowanceBuilder AllowanceBuilder() {
        return new AllowanceBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Allowance)) {
            return false;
        }
        Allowance other = (Allowance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ClusterType this$type = this.getType();
        ClusterType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        List<AllowanceDetail> this$details = this.getDetails();
        List<AllowanceDetail> other$details = other.getDetails();
        return !(this$details == null ? other$details != null : !((Object)this$details).equals(other$details));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Allowance;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ClusterType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        List<AllowanceDetail> $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : ((Object)$details).hashCode());
        return result;
    }

    public String getName() {
        return this.name;
    }

    public ClusterType getType() {
        return this.type;
    }

    public List<AllowanceDetail> getDetails() {
        return this.details;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="type")
    public void setType(ClusterType type) {
        this.type = type;
    }

    @JsonProperty(value="details")
    public void setDetails(List<AllowanceDetail> details) {
        this.details = details;
    }

    @Override
    public String toString() {
        return "Allowance(name=" + this.getName() + ", type=" + (Object)((Object)this.getType()) + ", details=" + this.getDetails() + ")";
    }

    public static class AllowanceBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private Boolean isMulticluster;
        private String name;
        private ClusterType type;
        private List<AllowanceDetail> details;

        AllowanceBuilder() {
        }

        public AllowanceBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public AllowanceBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public AllowanceBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public AllowanceBuilder isMulticluster(Boolean isMulticluster) {
            this.isMulticluster = isMulticluster;
            return this;
        }

        public AllowanceBuilder name(String name) {
            this.name = name;
            return this;
        }

        public AllowanceBuilder type(ClusterType type) {
            this.type = type;
            return this;
        }

        public AllowanceBuilder details(List<AllowanceDetail> details) {
            this.details = details;
            return this;
        }

        public Allowance build() {
            return new Allowance(this.tenantId, this.extId, this.links, this.isMulticluster, this.name, this.type, this.details);
        }

        public String toString() {
            return "Allowance.AllowanceBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", isMulticluster=" + this.isMulticluster + ", name=" + this.name + ", type=" + (Object)((Object)this.type) + ", details=" + this.details + ")";
        }
    }
}

