/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.lic.licensing.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.lic.common.v1.response.ApiLink;
import com.nutanix.dp1.lic.deserializers.LicObjectTypeTypedObject;
import com.nutanix.dp1.lic.licensing.v4.config.BaseClusterInfo;
import com.nutanix.dp1.lic.licensing.v4.config.ClusterType;
import com.nutanix.dp1.lic.licensing.v4.config.Service;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Compliance
extends BaseClusterInfo
implements Serializable,
LicObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(Compliance.class);
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="clusterExtId")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String clusterExtId = null;
    @JsonProperty(value="type")
    public ClusterType type = null;
    @Size(min=0, max=20)
    @JsonProperty(value="services")
    public @Size(min=0, max=20) List<Service> services = null;

    public Compliance() {
    }

    public Compliance(String tenantId, String extId, List<ApiLink> links, Boolean isMulticluster, String clusterExtId, ClusterType type, List<Service> services) {
        super(tenantId, extId, links, isMulticluster);
        this.setClusterExtId(clusterExtId);
        this.setType(type);
        this.setServices(services);
    }

    @Override
    protected String initialize$objectType() {
        return "licensing.v4.config.Compliance";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r1";
    }

    public static ComplianceBuilder ComplianceBuilder() {
        return new ComplianceBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Compliance)) {
            return false;
        }
        Compliance other = (Compliance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$clusterExtId = this.getClusterExtId();
        String other$clusterExtId = other.getClusterExtId();
        if (this$clusterExtId == null ? other$clusterExtId != null : !this$clusterExtId.equals(other$clusterExtId)) {
            return false;
        }
        ClusterType this$type = this.getType();
        ClusterType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        List<Service> this$services = this.getServices();
        List<Service> other$services = other.getServices();
        return !(this$services == null ? other$services != null : !((Object)this$services).equals(other$services));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Compliance;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $clusterExtId = this.getClusterExtId();
        result = result * 59 + ($clusterExtId == null ? 43 : $clusterExtId.hashCode());
        ClusterType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        List<Service> $services = this.getServices();
        result = result * 59 + ($services == null ? 43 : ((Object)$services).hashCode());
        return result;
    }

    public String getClusterExtId() {
        return this.clusterExtId;
    }

    public ClusterType getType() {
        return this.type;
    }

    public List<Service> getServices() {
        return this.services;
    }

    @JsonProperty(value="clusterExtId")
    public void setClusterExtId(String clusterExtId) {
        this.clusterExtId = clusterExtId;
    }

    @JsonProperty(value="type")
    public void setType(ClusterType type) {
        this.type = type;
    }

    @JsonProperty(value="services")
    public void setServices(List<Service> services) {
        this.services = services;
    }

    @Override
    public String toString() {
        return "Compliance(clusterExtId=" + this.getClusterExtId() + ", type=" + (Object)((Object)this.getType()) + ", services=" + this.getServices() + ")";
    }

    public static class ComplianceBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private Boolean isMulticluster;
        private String clusterExtId;
        private ClusterType type;
        private List<Service> services;

        ComplianceBuilder() {
        }

        public ComplianceBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public ComplianceBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public ComplianceBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public ComplianceBuilder isMulticluster(Boolean isMulticluster) {
            this.isMulticluster = isMulticluster;
            return this;
        }

        public ComplianceBuilder clusterExtId(String clusterExtId) {
            this.clusterExtId = clusterExtId;
            return this;
        }

        public ComplianceBuilder type(ClusterType type) {
            this.type = type;
            return this;
        }

        public ComplianceBuilder services(List<Service> services) {
            this.services = services;
            return this;
        }

        public Compliance build() {
            return new Compliance(this.tenantId, this.extId, this.links, this.isMulticluster, this.clusterExtId, this.type, this.services);
        }

        public String toString() {
            return "Compliance.ComplianceBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", isMulticluster=" + this.isMulticluster + ", clusterExtId=" + this.clusterExtId + ", type=" + (Object)((Object)this.type) + ", services=" + this.services + ")";
        }
    }
}

