/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.lic.licensing.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.lic.common.v1.response.ApiLink;
import com.nutanix.dp1.lic.deserializers.LicObjectTypeTypedObject;
import com.nutanix.dp1.lic.licensing.v4.config.BaseClusterInfo;
import com.nutanix.dp1.lic.licensing.v4.config.ClusterType;
import com.nutanix.dp1.lic.licensing.v4.config.EntitlementDetail;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Entitlement
extends BaseClusterInfo
implements Serializable,
LicObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(Entitlement.class);
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="clusterExtId")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String clusterExtId = null;
    @JsonProperty(value="isRegistered")
    public Boolean isRegistered = null;
    @Size(max=100)
    @JsonProperty(value="name")
    public @Size(max=100) String name = null;
    @JsonProperty(value="type")
    public ClusterType type = null;
    @Size(min=0, max=100)
    @JsonProperty(value="details")
    public @Size(min=0, max=100) List<EntitlementDetail> details = null;

    public Entitlement() {
    }

    public Entitlement(String tenantId, String extId, List<ApiLink> links, Boolean isMulticluster, String clusterExtId, Boolean isRegistered, String name, ClusterType type, List<EntitlementDetail> details) {
        super(tenantId, extId, links, isMulticluster);
        this.setClusterExtId(clusterExtId);
        this.setIsRegistered(isRegistered);
        this.setName(name);
        this.setType(type);
        this.setDetails(details);
    }

    @Override
    protected String initialize$objectType() {
        return "licensing.v4.config.Entitlement";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r1";
    }

    public static EntitlementBuilder EntitlementBuilder() {
        return new EntitlementBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Entitlement)) {
            return false;
        }
        Entitlement other = (Entitlement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$clusterExtId = this.getClusterExtId();
        String other$clusterExtId = other.getClusterExtId();
        if (this$clusterExtId == null ? other$clusterExtId != null : !this$clusterExtId.equals(other$clusterExtId)) {
            return false;
        }
        Boolean this$isRegistered = this.getIsRegistered();
        Boolean other$isRegistered = other.getIsRegistered();
        if (this$isRegistered == null ? other$isRegistered != null : !((Object)this$isRegistered).equals(other$isRegistered)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ClusterType this$type = this.getType();
        ClusterType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        List<EntitlementDetail> this$details = this.getDetails();
        List<EntitlementDetail> other$details = other.getDetails();
        return !(this$details == null ? other$details != null : !((Object)this$details).equals(other$details));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Entitlement;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $clusterExtId = this.getClusterExtId();
        result = result * 59 + ($clusterExtId == null ? 43 : $clusterExtId.hashCode());
        Boolean $isRegistered = this.getIsRegistered();
        result = result * 59 + ($isRegistered == null ? 43 : ((Object)$isRegistered).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ClusterType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        List<EntitlementDetail> $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : ((Object)$details).hashCode());
        return result;
    }

    public String getClusterExtId() {
        return this.clusterExtId;
    }

    public Boolean getIsRegistered() {
        return this.isRegistered;
    }

    public String getName() {
        return this.name;
    }

    public ClusterType getType() {
        return this.type;
    }

    public List<EntitlementDetail> getDetails() {
        return this.details;
    }

    @JsonProperty(value="clusterExtId")
    public void setClusterExtId(String clusterExtId) {
        this.clusterExtId = clusterExtId;
    }

    @JsonProperty(value="isRegistered")
    public void setIsRegistered(Boolean isRegistered) {
        this.isRegistered = isRegistered;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="type")
    public void setType(ClusterType type) {
        this.type = type;
    }

    @JsonProperty(value="details")
    public void setDetails(List<EntitlementDetail> details) {
        this.details = details;
    }

    @Override
    public String toString() {
        return "Entitlement(clusterExtId=" + this.getClusterExtId() + ", isRegistered=" + this.getIsRegistered() + ", name=" + this.getName() + ", type=" + (Object)((Object)this.getType()) + ", details=" + this.getDetails() + ")";
    }

    public static class EntitlementBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private Boolean isMulticluster;
        private String clusterExtId;
        private Boolean isRegistered;
        private String name;
        private ClusterType type;
        private List<EntitlementDetail> details;

        EntitlementBuilder() {
        }

        public EntitlementBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public EntitlementBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public EntitlementBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public EntitlementBuilder isMulticluster(Boolean isMulticluster) {
            this.isMulticluster = isMulticluster;
            return this;
        }

        public EntitlementBuilder clusterExtId(String clusterExtId) {
            this.clusterExtId = clusterExtId;
            return this;
        }

        public EntitlementBuilder isRegistered(Boolean isRegistered) {
            this.isRegistered = isRegistered;
            return this;
        }

        public EntitlementBuilder name(String name) {
            this.name = name;
            return this;
        }

        public EntitlementBuilder type(ClusterType type) {
            this.type = type;
            return this;
        }

        public EntitlementBuilder details(List<EntitlementDetail> details) {
            this.details = details;
            return this;
        }

        public Entitlement build() {
            return new Entitlement(this.tenantId, this.extId, this.links, this.isMulticluster, this.clusterExtId, this.isRegistered, this.name, this.type, this.details);
        }

        public String toString() {
            return "Entitlement.EntitlementBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", isMulticluster=" + this.isMulticluster + ", clusterExtId=" + this.clusterExtId + ", isRegistered=" + this.isRegistered + ", name=" + this.name + ", type=" + (Object)((Object)this.type) + ", details=" + this.details + ")";
        }
    }
}

