/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.lic.licensing.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.lic.common.v1.response.ApiLink;
import com.nutanix.dp1.lic.deserializers.LicObjectTypeTypedObject;
import com.nutanix.dp1.lic.licensing.v4.config.BaseLicenseInfo;
import com.nutanix.dp1.lic.licensing.v4.config.LicenseCategory;
import com.nutanix.dp1.lic.licensing.v4.config.LicenseType;
import com.nutanix.dp1.lic.licensing.v4.config.Meter;
import com.nutanix.dp1.lic.licensing.v4.config.SubCategory;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import javax.validation.constraints.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpiredLicense
extends BaseLicenseInfo
implements Serializable,
LicObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(ExpiredLicense.class);
    @Pattern(regexp="^[A-Za-z0-9-]+$")
    @JsonProperty(value="licenseId")
    public @Pattern(regexp="^[A-Za-z0-9-]+$") String licenseId = null;
    @JsonProperty(value="meter")
    public Meter meter = null;
    @JsonProperty(value="usedQuantity")
    public Double usedQuantity = null;

    public ExpiredLicense() {
    }

    public ExpiredLicense(String tenantId, String extId, List<ApiLink> links, String name, LicenseType type, LicenseCategory category, SubCategory subCategory, LocalDate expiryDate, String licenseId, Meter meter, Double usedQuantity) {
        super(tenantId, extId, links, name, type, category, subCategory, expiryDate);
        this.setLicenseId(licenseId);
        this.setMeter(meter);
        this.setUsedQuantity(usedQuantity);
    }

    @Override
    protected String initialize$objectType() {
        return "licensing.v4.config.ExpiredLicense";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r1";
    }

    public static ExpiredLicenseBuilder ExpiredLicenseBuilder() {
        return new ExpiredLicenseBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExpiredLicense)) {
            return false;
        }
        ExpiredLicense other = (ExpiredLicense)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$licenseId = this.getLicenseId();
        String other$licenseId = other.getLicenseId();
        if (this$licenseId == null ? other$licenseId != null : !this$licenseId.equals(other$licenseId)) {
            return false;
        }
        Meter this$meter = this.getMeter();
        Meter other$meter = other.getMeter();
        if (this$meter == null ? other$meter != null : !((Object)((Object)this$meter)).equals((Object)other$meter)) {
            return false;
        }
        Double this$usedQuantity = this.getUsedQuantity();
        Double other$usedQuantity = other.getUsedQuantity();
        return !(this$usedQuantity == null ? other$usedQuantity != null : !((Object)this$usedQuantity).equals(other$usedQuantity));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ExpiredLicense;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $licenseId = this.getLicenseId();
        result = result * 59 + ($licenseId == null ? 43 : $licenseId.hashCode());
        Meter $meter = this.getMeter();
        result = result * 59 + ($meter == null ? 43 : ((Object)((Object)$meter)).hashCode());
        Double $usedQuantity = this.getUsedQuantity();
        result = result * 59 + ($usedQuantity == null ? 43 : ((Object)$usedQuantity).hashCode());
        return result;
    }

    public String getLicenseId() {
        return this.licenseId;
    }

    public Meter getMeter() {
        return this.meter;
    }

    public Double getUsedQuantity() {
        return this.usedQuantity;
    }

    @JsonProperty(value="licenseId")
    public void setLicenseId(String licenseId) {
        this.licenseId = licenseId;
    }

    @JsonProperty(value="meter")
    public void setMeter(Meter meter) {
        this.meter = meter;
    }

    @JsonProperty(value="usedQuantity")
    public void setUsedQuantity(Double usedQuantity) {
        this.usedQuantity = usedQuantity;
    }

    @Override
    public String toString() {
        return "ExpiredLicense(licenseId=" + this.getLicenseId() + ", meter=" + (Object)((Object)this.getMeter()) + ", usedQuantity=" + this.getUsedQuantity() + ")";
    }

    public static class ExpiredLicenseBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String name;
        private LicenseType type;
        private LicenseCategory category;
        private SubCategory subCategory;
        private LocalDate expiryDate;
        private String licenseId;
        private Meter meter;
        private Double usedQuantity;

        ExpiredLicenseBuilder() {
        }

        public ExpiredLicenseBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public ExpiredLicenseBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public ExpiredLicenseBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public ExpiredLicenseBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ExpiredLicenseBuilder type(LicenseType type) {
            this.type = type;
            return this;
        }

        public ExpiredLicenseBuilder category(LicenseCategory category) {
            this.category = category;
            return this;
        }

        public ExpiredLicenseBuilder subCategory(SubCategory subCategory) {
            this.subCategory = subCategory;
            return this;
        }

        public ExpiredLicenseBuilder expiryDate(LocalDate expiryDate) {
            this.expiryDate = expiryDate;
            return this;
        }

        public ExpiredLicenseBuilder licenseId(String licenseId) {
            this.licenseId = licenseId;
            return this;
        }

        public ExpiredLicenseBuilder meter(Meter meter) {
            this.meter = meter;
            return this;
        }

        public ExpiredLicenseBuilder usedQuantity(Double usedQuantity) {
            this.usedQuantity = usedQuantity;
            return this;
        }

        public ExpiredLicense build() {
            return new ExpiredLicense(this.tenantId, this.extId, this.links, this.name, this.type, this.category, this.subCategory, this.expiryDate, this.licenseId, this.meter, this.usedQuantity);
        }

        public String toString() {
            return "ExpiredLicense.ExpiredLicenseBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", name=" + this.name + ", type=" + (Object)((Object)this.type) + ", category=" + (Object)((Object)this.category) + ", subCategory=" + (Object)((Object)this.subCategory) + ", expiryDate=" + this.expiryDate + ", licenseId=" + this.licenseId + ", meter=" + (Object)((Object)this.meter) + ", usedQuantity=" + this.usedQuantity + ")";
        }
    }
}

