/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.lic.licensing.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.lic.common.v1.response.ApiLink;
import com.nutanix.dp1.lic.deserializers.LicObjectTypeTypedObject;
import com.nutanix.dp1.lic.licensing.v4.config.BaseLicenseInfo;
import com.nutanix.dp1.lic.licensing.v4.config.Consumption;
import com.nutanix.dp1.lic.licensing.v4.config.LicenseCategory;
import com.nutanix.dp1.lic.licensing.v4.config.LicenseType;
import com.nutanix.dp1.lic.licensing.v4.config.Meter;
import com.nutanix.dp1.lic.licensing.v4.config.Scope;
import com.nutanix.dp1.lic.licensing.v4.config.SubCategory;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class License
extends BaseLicenseInfo
implements Serializable,
LicObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(License.class);
    @Pattern(regexp="^[A-Za-z0-9-]+$")
    @JsonProperty(value="salesforceLicenseId")
    public @Pattern(regexp="^[A-Za-z0-9-]+$") String salesforceLicenseId = null;
    @JsonProperty(value="meter")
    public Meter meter = null;
    @JsonProperty(value="scope")
    public Scope scope = null;
    @JsonProperty(value="quantity")
    public Double quantity = null;
    @Size(min=0, max=100)
    @JsonProperty(value="consumptionDetails")
    public @Size(min=0, max=100) List<Consumption> consumptionDetails = null;

    public License() {
    }

    public License(String tenantId, String extId, List<ApiLink> links, String name, LicenseType type, LicenseCategory category, SubCategory subCategory, LocalDate expiryDate, String salesforceLicenseId, Meter meter, Scope scope, Double quantity, List<Consumption> consumptionDetails) {
        super(tenantId, extId, links, name, type, category, subCategory, expiryDate);
        this.setSalesforceLicenseId(salesforceLicenseId);
        this.setMeter(meter);
        this.setScope(scope);
        this.setQuantity(quantity);
        this.setConsumptionDetails(consumptionDetails);
    }

    @Override
    protected String initialize$objectType() {
        return "licensing.v4.config.License";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r1";
    }

    public static LicenseBuilder LicenseBuilder() {
        return new LicenseBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof License)) {
            return false;
        }
        License other = (License)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$salesforceLicenseId = this.getSalesforceLicenseId();
        String other$salesforceLicenseId = other.getSalesforceLicenseId();
        if (this$salesforceLicenseId == null ? other$salesforceLicenseId != null : !this$salesforceLicenseId.equals(other$salesforceLicenseId)) {
            return false;
        }
        Meter this$meter = this.getMeter();
        Meter other$meter = other.getMeter();
        if (this$meter == null ? other$meter != null : !((Object)((Object)this$meter)).equals((Object)other$meter)) {
            return false;
        }
        Scope this$scope = this.getScope();
        Scope other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !((Object)((Object)this$scope)).equals((Object)other$scope)) {
            return false;
        }
        Double this$quantity = this.getQuantity();
        Double other$quantity = other.getQuantity();
        if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
            return false;
        }
        List<Consumption> this$consumptionDetails = this.getConsumptionDetails();
        List<Consumption> other$consumptionDetails = other.getConsumptionDetails();
        return !(this$consumptionDetails == null ? other$consumptionDetails != null : !((Object)this$consumptionDetails).equals(other$consumptionDetails));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof License;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $salesforceLicenseId = this.getSalesforceLicenseId();
        result = result * 59 + ($salesforceLicenseId == null ? 43 : $salesforceLicenseId.hashCode());
        Meter $meter = this.getMeter();
        result = result * 59 + ($meter == null ? 43 : ((Object)((Object)$meter)).hashCode());
        Scope $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : ((Object)((Object)$scope)).hashCode());
        Double $quantity = this.getQuantity();
        result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
        List<Consumption> $consumptionDetails = this.getConsumptionDetails();
        result = result * 59 + ($consumptionDetails == null ? 43 : ((Object)$consumptionDetails).hashCode());
        return result;
    }

    public String getSalesforceLicenseId() {
        return this.salesforceLicenseId;
    }

    public Meter getMeter() {
        return this.meter;
    }

    public Scope getScope() {
        return this.scope;
    }

    public Double getQuantity() {
        return this.quantity;
    }

    public List<Consumption> getConsumptionDetails() {
        return this.consumptionDetails;
    }

    @JsonProperty(value="salesforceLicenseId")
    public void setSalesforceLicenseId(String salesforceLicenseId) {
        this.salesforceLicenseId = salesforceLicenseId;
    }

    @JsonProperty(value="meter")
    public void setMeter(Meter meter) {
        this.meter = meter;
    }

    @JsonProperty(value="scope")
    public void setScope(Scope scope) {
        this.scope = scope;
    }

    @JsonProperty(value="quantity")
    public void setQuantity(Double quantity) {
        this.quantity = quantity;
    }

    @JsonProperty(value="consumptionDetails")
    public void setConsumptionDetails(List<Consumption> consumptionDetails) {
        this.consumptionDetails = consumptionDetails;
    }

    @Override
    public String toString() {
        return "License(salesforceLicenseId=" + this.getSalesforceLicenseId() + ", meter=" + (Object)((Object)this.getMeter()) + ", scope=" + (Object)((Object)this.getScope()) + ", quantity=" + this.getQuantity() + ", consumptionDetails=" + this.getConsumptionDetails() + ")";
    }

    public static class LicenseBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String name;
        private LicenseType type;
        private LicenseCategory category;
        private SubCategory subCategory;
        private LocalDate expiryDate;
        private String salesforceLicenseId;
        private Meter meter;
        private Scope scope;
        private Double quantity;
        private List<Consumption> consumptionDetails;

        LicenseBuilder() {
        }

        public LicenseBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public LicenseBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public LicenseBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public LicenseBuilder name(String name) {
            this.name = name;
            return this;
        }

        public LicenseBuilder type(LicenseType type) {
            this.type = type;
            return this;
        }

        public LicenseBuilder category(LicenseCategory category) {
            this.category = category;
            return this;
        }

        public LicenseBuilder subCategory(SubCategory subCategory) {
            this.subCategory = subCategory;
            return this;
        }

        public LicenseBuilder expiryDate(LocalDate expiryDate) {
            this.expiryDate = expiryDate;
            return this;
        }

        public LicenseBuilder salesforceLicenseId(String salesforceLicenseId) {
            this.salesforceLicenseId = salesforceLicenseId;
            return this;
        }

        public LicenseBuilder meter(Meter meter) {
            this.meter = meter;
            return this;
        }

        public LicenseBuilder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public LicenseBuilder quantity(Double quantity) {
            this.quantity = quantity;
            return this;
        }

        public LicenseBuilder consumptionDetails(List<Consumption> consumptionDetails) {
            this.consumptionDetails = consumptionDetails;
            return this;
        }

        public License build() {
            return new License(this.tenantId, this.extId, this.links, this.name, this.type, this.category, this.subCategory, this.expiryDate, this.salesforceLicenseId, this.meter, this.scope, this.quantity, this.consumptionDetails);
        }

        public String toString() {
            return "License.LicenseBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", name=" + this.name + ", type=" + (Object)((Object)this.type) + ", category=" + (Object)((Object)this.category) + ", subCategory=" + (Object)((Object)this.subCategory) + ", expiryDate=" + this.expiryDate + ", salesforceLicenseId=" + this.salesforceLicenseId + ", meter=" + (Object)((Object)this.meter) + ", scope=" + (Object)((Object)this.scope) + ", quantity=" + this.quantity + ", consumptionDetails=" + this.consumptionDetails + ")";
        }
    }
}

