/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.lic.licensing.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.lic.common.v1.response.ApiLink;
import com.nutanix.dp1.lic.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.lic.deserializers.LicObjectTypeTypedObject;
import com.nutanix.dp1.lic.licensing.v4.config.ClusterLicenseKeyMapping;
import com.nutanix.dp1.lic.licensing.v4.config.LicenseCategory;
import com.nutanix.dp1.lic.licensing.v4.config.LicenseKeySubCategory;
import com.nutanix.dp1.lic.licensing.v4.config.LicenseType;
import com.nutanix.dp1.lic.licensing.v4.config.Meter;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseKey
extends ExternalizableAbstractModel
implements Serializable,
LicObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(LicenseKey.class);
    private LocalDate entitlementExpiryDate = null;
    private Double quantity = null;
    @Size(max=10)
    private @Size(max=10) String groupId = null;
    @Size(min=0, max=100)
    private @Size(min=0, max=100) List<ClusterLicenseKeyMapping> assignmentDetails = null;
    @Size(max=100)
    @JsonProperty(value="key")
    public @Size(max=100) String key = null;
    @Size(max=100)
    @JsonProperty(value="validationDetail")
    public @Size(max=100) String validationDetail = null;
    @JsonProperty(value="type")
    public LicenseType type = null;
    @JsonProperty(value="category")
    public LicenseCategory category = null;
    @JsonProperty(value="subCategory")
    public LicenseKeySubCategory subCategory = null;
    @JsonProperty(value="meter")
    public Meter meter = null;

    public LicenseKey() {
    }

    public LicenseKey(String tenantId, String extId, List<ApiLink> links, String key, String validationDetail, LicenseType type, LicenseCategory category, LicenseKeySubCategory subCategory, LocalDate entitlementExpiryDate, Meter meter, Double quantity, String groupId, List<ClusterLicenseKeyMapping> assignmentDetails) {
        super(tenantId, extId, links);
        this.setKey(key);
        this.setValidationDetail(validationDetail);
        this.setType(type);
        this.setCategory(category);
        this.setSubCategory(subCategory);
        this.setEntitlementExpiryDate(entitlementExpiryDate);
        this.setMeter(meter);
        this.setQuantity(quantity);
        this.setGroupId(groupId);
        this.setAssignmentDetails(assignmentDetails);
    }

    @Override
    protected String initialize$objectType() {
        return "licensing.v4.config.LicenseKey";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r1";
    }

    public void setEntitlementExpiryDate(LocalDate entitlementExpiryDate) {
        if (this.entitlementExpiryDate == null) {
            this.entitlementExpiryDate = entitlementExpiryDate;
        } else {
            log.warn("Read-only property entitlementExpiryDate already contains a non-null value and cannot be set again");
        }
    }

    public void setQuantity(Double quantity) {
        if (this.quantity == null) {
            this.quantity = quantity;
        } else {
            log.warn("Read-only property quantity already contains a non-null value and cannot be set again");
        }
    }

    public void setGroupId(String groupId) {
        if (this.groupId == null) {
            this.groupId = groupId;
        } else {
            log.warn("Read-only property groupId already contains a non-null value and cannot be set again");
        }
    }

    public void setAssignmentDetails(List<ClusterLicenseKeyMapping> assignmentDetails) {
        if (this.assignmentDetails == null) {
            this.assignmentDetails = assignmentDetails;
        } else {
            log.warn("Read-only property assignmentDetails already contains a non-null value and cannot be set again");
        }
    }

    public static LicenseKeyBuilder LicenseKeyBuilder() {
        return new LicenseKeyBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LicenseKey)) {
            return false;
        }
        LicenseKey other = (LicenseKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LocalDate this$entitlementExpiryDate = this.getEntitlementExpiryDate();
        LocalDate other$entitlementExpiryDate = other.getEntitlementExpiryDate();
        if (this$entitlementExpiryDate == null ? other$entitlementExpiryDate != null : !((Object)this$entitlementExpiryDate).equals(other$entitlementExpiryDate)) {
            return false;
        }
        Double this$quantity = this.getQuantity();
        Double other$quantity = other.getQuantity();
        if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        List<ClusterLicenseKeyMapping> this$assignmentDetails = this.getAssignmentDetails();
        List<ClusterLicenseKeyMapping> other$assignmentDetails = other.getAssignmentDetails();
        if (this$assignmentDetails == null ? other$assignmentDetails != null : !((Object)this$assignmentDetails).equals(other$assignmentDetails)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$validationDetail = this.getValidationDetail();
        String other$validationDetail = other.getValidationDetail();
        if (this$validationDetail == null ? other$validationDetail != null : !this$validationDetail.equals(other$validationDetail)) {
            return false;
        }
        LicenseType this$type = this.getType();
        LicenseType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        LicenseCategory this$category = this.getCategory();
        LicenseCategory other$category = other.getCategory();
        if (this$category == null ? other$category != null : !((Object)((Object)this$category)).equals((Object)other$category)) {
            return false;
        }
        LicenseKeySubCategory this$subCategory = this.getSubCategory();
        LicenseKeySubCategory other$subCategory = other.getSubCategory();
        if (this$subCategory == null ? other$subCategory != null : !((Object)((Object)this$subCategory)).equals((Object)other$subCategory)) {
            return false;
        }
        Meter this$meter = this.getMeter();
        Meter other$meter = other.getMeter();
        return !(this$meter == null ? other$meter != null : !((Object)((Object)this$meter)).equals((Object)other$meter));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LicenseKey;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        LocalDate $entitlementExpiryDate = this.getEntitlementExpiryDate();
        result = result * 59 + ($entitlementExpiryDate == null ? 43 : ((Object)$entitlementExpiryDate).hashCode());
        Double $quantity = this.getQuantity();
        result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        List<ClusterLicenseKeyMapping> $assignmentDetails = this.getAssignmentDetails();
        result = result * 59 + ($assignmentDetails == null ? 43 : ((Object)$assignmentDetails).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $validationDetail = this.getValidationDetail();
        result = result * 59 + ($validationDetail == null ? 43 : $validationDetail.hashCode());
        LicenseType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        LicenseCategory $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : ((Object)((Object)$category)).hashCode());
        LicenseKeySubCategory $subCategory = this.getSubCategory();
        result = result * 59 + ($subCategory == null ? 43 : ((Object)((Object)$subCategory)).hashCode());
        Meter $meter = this.getMeter();
        result = result * 59 + ($meter == null ? 43 : ((Object)((Object)$meter)).hashCode());
        return result;
    }

    public LocalDate getEntitlementExpiryDate() {
        return this.entitlementExpiryDate;
    }

    public Double getQuantity() {
        return this.quantity;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public List<ClusterLicenseKeyMapping> getAssignmentDetails() {
        return this.assignmentDetails;
    }

    public String getKey() {
        return this.key;
    }

    public String getValidationDetail() {
        return this.validationDetail;
    }

    public LicenseType getType() {
        return this.type;
    }

    public LicenseCategory getCategory() {
        return this.category;
    }

    public LicenseKeySubCategory getSubCategory() {
        return this.subCategory;
    }

    public Meter getMeter() {
        return this.meter;
    }

    @JsonProperty(value="key")
    public void setKey(String key) {
        this.key = key;
    }

    @JsonProperty(value="validationDetail")
    public void setValidationDetail(String validationDetail) {
        this.validationDetail = validationDetail;
    }

    @JsonProperty(value="type")
    public void setType(LicenseType type) {
        this.type = type;
    }

    @JsonProperty(value="category")
    public void setCategory(LicenseCategory category) {
        this.category = category;
    }

    @JsonProperty(value="subCategory")
    public void setSubCategory(LicenseKeySubCategory subCategory) {
        this.subCategory = subCategory;
    }

    @JsonProperty(value="meter")
    public void setMeter(Meter meter) {
        this.meter = meter;
    }

    @Override
    public String toString() {
        return "LicenseKey(entitlementExpiryDate=" + this.getEntitlementExpiryDate() + ", quantity=" + this.getQuantity() + ", groupId=" + this.getGroupId() + ", assignmentDetails=" + this.getAssignmentDetails() + ", key=" + this.getKey() + ", validationDetail=" + this.getValidationDetail() + ", type=" + (Object)((Object)this.getType()) + ", category=" + (Object)((Object)this.getCategory()) + ", subCategory=" + (Object)((Object)this.getSubCategory()) + ", meter=" + (Object)((Object)this.getMeter()) + ")";
    }

    public static class LicenseKeyBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String key;
        private String validationDetail;
        private LicenseType type;
        private LicenseCategory category;
        private LicenseKeySubCategory subCategory;
        private LocalDate entitlementExpiryDate;
        private Meter meter;
        private Double quantity;
        private String groupId;
        private List<ClusterLicenseKeyMapping> assignmentDetails;

        LicenseKeyBuilder() {
        }

        public LicenseKeyBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public LicenseKeyBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public LicenseKeyBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public LicenseKeyBuilder key(String key) {
            this.key = key;
            return this;
        }

        public LicenseKeyBuilder validationDetail(String validationDetail) {
            this.validationDetail = validationDetail;
            return this;
        }

        public LicenseKeyBuilder type(LicenseType type) {
            this.type = type;
            return this;
        }

        public LicenseKeyBuilder category(LicenseCategory category) {
            this.category = category;
            return this;
        }

        public LicenseKeyBuilder subCategory(LicenseKeySubCategory subCategory) {
            this.subCategory = subCategory;
            return this;
        }

        public LicenseKeyBuilder entitlementExpiryDate(LocalDate entitlementExpiryDate) {
            this.entitlementExpiryDate = entitlementExpiryDate;
            return this;
        }

        public LicenseKeyBuilder meter(Meter meter) {
            this.meter = meter;
            return this;
        }

        public LicenseKeyBuilder quantity(Double quantity) {
            this.quantity = quantity;
            return this;
        }

        public LicenseKeyBuilder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public LicenseKeyBuilder assignmentDetails(List<ClusterLicenseKeyMapping> assignmentDetails) {
            this.assignmentDetails = assignmentDetails;
            return this;
        }

        public LicenseKey build() {
            return new LicenseKey(this.tenantId, this.extId, this.links, this.key, this.validationDetail, this.type, this.category, this.subCategory, this.entitlementExpiryDate, this.meter, this.quantity, this.groupId, this.assignmentDetails);
        }

        public String toString() {
            return "LicenseKey.LicenseKeyBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", key=" + this.key + ", validationDetail=" + this.validationDetail + ", type=" + (Object)((Object)this.type) + ", category=" + (Object)((Object)this.category) + ", subCategory=" + (Object)((Object)this.subCategory) + ", entitlementExpiryDate=" + this.entitlementExpiryDate + ", meter=" + (Object)((Object)this.meter) + ", quantity=" + this.quantity + ", groupId=" + this.groupId + ", assignmentDetails=" + this.assignmentDetails + ")";
        }
    }
}

