/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.lic.licensing.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.lic.common.v1.response.ApiLink;
import com.nutanix.dp1.lic.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.lic.deserializers.LicObjectTypeTypedObject;
import com.nutanix.dp1.lic.licensing.v4.config.RecommendationDetail;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Recommendation
extends ExternalizableAbstractModel
implements Serializable,
LicObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(Recommendation.class);
    @Size(min=0, max=50)
    @JsonProperty(value="details")
    public @Size(min=0, max=50) List<RecommendationDetail> details = null;

    public Recommendation() {
    }

    public Recommendation(String tenantId, String extId, List<ApiLink> links, List<RecommendationDetail> details) {
        super(tenantId, extId, links);
        this.setDetails(details);
    }

    @Override
    protected String initialize$objectType() {
        return "licensing.v4.config.Recommendation";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r1";
    }

    public static RecommendationBuilder RecommendationBuilder() {
        return new RecommendationBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Recommendation)) {
            return false;
        }
        Recommendation other = (Recommendation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<RecommendationDetail> this$details = this.getDetails();
        List<RecommendationDetail> other$details = other.getDetails();
        return !(this$details == null ? other$details != null : !((Object)this$details).equals(other$details));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Recommendation;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<RecommendationDetail> $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : ((Object)$details).hashCode());
        return result;
    }

    public List<RecommendationDetail> getDetails() {
        return this.details;
    }

    @JsonProperty(value="details")
    public void setDetails(List<RecommendationDetail> details) {
        this.details = details;
    }

    @Override
    public String toString() {
        return "Recommendation(details=" + this.getDetails() + ")";
    }

    public static class RecommendationBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private List<RecommendationDetail> details;

        RecommendationBuilder() {
        }

        public RecommendationBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public RecommendationBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public RecommendationBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public RecommendationBuilder details(List<RecommendationDetail> details) {
            this.details = details;
            return this;
        }

        public Recommendation build() {
            return new Recommendation(this.tenantId, this.extId, this.links, this.details);
        }

        public String toString() {
            return "Recommendation.RecommendationBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", details=" + this.details + ")";
        }
    }
}

