/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.lic.licensing.v4.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.lic.common.v1.response.ApiLink;
import com.nutanix.dp1.lic.deserializers.LicObjectTypeTypedObject;
import com.nutanix.dp1.lic.licensing.v4.config.BaseClusterInfo;
import com.nutanix.dp1.lic.licensing.v4.config.CapacityViolation;
import com.nutanix.dp1.lic.licensing.v4.config.ExpiredLicense;
import com.nutanix.dp1.lic.licensing.v4.config.FeatureViolation;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Violation
extends BaseClusterInfo
implements Serializable,
LicObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(Violation.class);
    @Size(min=0, max=100)
    @JsonProperty(value="featureViolations")
    public @Size(min=0, max=100) List<FeatureViolation> featureViolations = null;
    @Size(min=0, max=100)
    @JsonProperty(value="capacityViolations")
    public @Size(min=0, max=100) List<CapacityViolation> capacityViolations = null;
    @Size(min=0, max=100)
    @JsonProperty(value="expiredLicenses")
    public @Size(min=0, max=100) List<ExpiredLicense> expiredLicenses = null;

    public Violation() {
    }

    public Violation(String tenantId, String extId, List<ApiLink> links, Boolean isMulticluster, List<FeatureViolation> featureViolations, List<CapacityViolation> capacityViolations, List<ExpiredLicense> expiredLicenses) {
        super(tenantId, extId, links, isMulticluster);
        this.setFeatureViolations(featureViolations);
        this.setCapacityViolations(capacityViolations);
        this.setExpiredLicenses(expiredLicenses);
    }

    @Override
    protected String initialize$objectType() {
        return "licensing.v4.config.Violation";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r1";
    }

    public static ViolationBuilder ViolationBuilder() {
        return new ViolationBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Violation)) {
            return false;
        }
        Violation other = (Violation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<FeatureViolation> this$featureViolations = this.getFeatureViolations();
        List<FeatureViolation> other$featureViolations = other.getFeatureViolations();
        if (this$featureViolations == null ? other$featureViolations != null : !((Object)this$featureViolations).equals(other$featureViolations)) {
            return false;
        }
        List<CapacityViolation> this$capacityViolations = this.getCapacityViolations();
        List<CapacityViolation> other$capacityViolations = other.getCapacityViolations();
        if (this$capacityViolations == null ? other$capacityViolations != null : !((Object)this$capacityViolations).equals(other$capacityViolations)) {
            return false;
        }
        List<ExpiredLicense> this$expiredLicenses = this.getExpiredLicenses();
        List<ExpiredLicense> other$expiredLicenses = other.getExpiredLicenses();
        return !(this$expiredLicenses == null ? other$expiredLicenses != null : !((Object)this$expiredLicenses).equals(other$expiredLicenses));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Violation;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<FeatureViolation> $featureViolations = this.getFeatureViolations();
        result = result * 59 + ($featureViolations == null ? 43 : ((Object)$featureViolations).hashCode());
        List<CapacityViolation> $capacityViolations = this.getCapacityViolations();
        result = result * 59 + ($capacityViolations == null ? 43 : ((Object)$capacityViolations).hashCode());
        List<ExpiredLicense> $expiredLicenses = this.getExpiredLicenses();
        result = result * 59 + ($expiredLicenses == null ? 43 : ((Object)$expiredLicenses).hashCode());
        return result;
    }

    public List<FeatureViolation> getFeatureViolations() {
        return this.featureViolations;
    }

    public List<CapacityViolation> getCapacityViolations() {
        return this.capacityViolations;
    }

    public List<ExpiredLicense> getExpiredLicenses() {
        return this.expiredLicenses;
    }

    @JsonProperty(value="featureViolations")
    public void setFeatureViolations(List<FeatureViolation> featureViolations) {
        this.featureViolations = featureViolations;
    }

    @JsonProperty(value="capacityViolations")
    public void setCapacityViolations(List<CapacityViolation> capacityViolations) {
        this.capacityViolations = capacityViolations;
    }

    @JsonProperty(value="expiredLicenses")
    public void setExpiredLicenses(List<ExpiredLicense> expiredLicenses) {
        this.expiredLicenses = expiredLicenses;
    }

    @Override
    public String toString() {
        return "Violation(featureViolations=" + this.getFeatureViolations() + ", capacityViolations=" + this.getCapacityViolations() + ", expiredLicenses=" + this.getExpiredLicenses() + ")";
    }

    public static class ViolationBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private Boolean isMulticluster;
        private List<FeatureViolation> featureViolations;
        private List<CapacityViolation> capacityViolations;
        private List<ExpiredLicense> expiredLicenses;

        ViolationBuilder() {
        }

        public ViolationBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public ViolationBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public ViolationBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public ViolationBuilder isMulticluster(Boolean isMulticluster) {
            this.isMulticluster = isMulticluster;
            return this;
        }

        public ViolationBuilder featureViolations(List<FeatureViolation> featureViolations) {
            this.featureViolations = featureViolations;
            return this;
        }

        public ViolationBuilder capacityViolations(List<CapacityViolation> capacityViolations) {
            this.capacityViolations = capacityViolations;
            return this;
        }

        public ViolationBuilder expiredLicenses(List<ExpiredLicense> expiredLicenses) {
            this.expiredLicenses = expiredLicenses;
            return this;
        }

        public Violation build() {
            return new Violation(this.tenantId, this.extId, this.links, this.isMulticluster, this.featureViolations, this.capacityViolations, this.expiredLicenses);
        }

        public String toString() {
            return "Violation.ViolationBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", isMulticluster=" + this.isMulticluster + ", featureViolations=" + this.featureViolations + ", capacityViolations=" + this.capacityViolations + ", expiredLicenses=" + this.expiredLicenses + ")";
        }
    }
}

