/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.lic.java.client.api;

import com.nutanix.dp1.lic.licensing.v4.agreements.AddUserApiResponse;
import com.nutanix.dp1.lic.licensing.v4.agreements.EndUser;
import com.nutanix.dp1.lic.licensing.v4.agreements.GetEulaApiResponse;
import com.nutanix.lic.java.client.ApiClient;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.util.UriComponentsBuilder;

@Component(value="com.nutanix.lic.java.client.api.EndUserLicenseAgreementApi")
public class EndUserLicenseAgreementApi {
    private static final Logger log = LoggerFactory.getLogger(EndUserLicenseAgreementApi.class);
    private ApiClient apiClient;
    private final Set<String> headersToSkip;

    public EndUserLicenseAgreementApi() {
        this(new ApiClient());
    }

    @Autowired
    public EndUserLicenseAgreementApi(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.headersToSkip = new HashSet<String>(Arrays.asList("authorization", "cookie", "host", "user-agent"));
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public AddUserApiResponse addUser(EndUser body, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        EndUser postBody = body;
        if (body == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling addUser");
        }
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/licensing/v4.1/agreements/eula/$actions/add-user").build().toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<AddUserApiResponse> returnType = new ParameterizedTypeReference<AddUserApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public GetEulaApiResponse getEula(Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        Object postBody = null;
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/licensing/v4.1/agreements/eula").build().toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<GetEulaApiResponse> returnType = new ParameterizedTypeReference<GetEulaApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.GET, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }
}

